@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.inputs

import com.pulumi.alicloud.cloudstoragegateway.inputs.GetStorageBundlesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStorageBundles.
 * @property backendBucketRegionId
 * @property ids
 * @property nameRegex
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetStorageBundlesPlainArgs(
    public val backendBucketRegionId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cloudstoragegateway.inputs.GetStorageBundlesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cloudstoragegateway.inputs.GetStorageBundlesPlainArgs =
        com.pulumi.alicloud.cloudstoragegateway.inputs.GetStorageBundlesPlainArgs.builder()
            .backendBucketRegionId(backendBucketRegionId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageBundlesPlainArgs].
 */
@PulumiTagMarker
public class GetStorageBundlesPlainArgsBuilder internal constructor() {
    private var backendBucketRegionId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value
     */
    @JvmName("xpqvsxrgwdkedcah")
    public suspend fun backendBucketRegionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backendBucketRegionId = mapped
    }

    /**
     * @param value
     */
    @JvmName("nhvwxmaptgbhossk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("kxmuhaxbyrhtxcra")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("yduvoustuvqvupcu")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("pbibdrnymugsyoao")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("bqerpvbbhjkkkask")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("lvvospmbolcyglip")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetStorageBundlesPlainArgs = GetStorageBundlesPlainArgs(
        backendBucketRegionId = backendBucketRegionId ?: throw
            PulumiNullFieldException("backendBucketRegionId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
