@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getExpressSyncs.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property syncs
 */
public data class GetExpressSyncsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val syncs: List<GetExpressSyncsSync>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetExpressSyncsResult): GetExpressSyncsResult = GetExpressSyncsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            syncs = javaType.syncs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetExpressSyncsSync.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
