@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The name of the OSS Bucket.
 * @property bucketPrefix The prefix of the OSS Bucket.
 * @property bucketRegion The region of the OSS Bucket.
 * @property description The description of the Express Sync.
 * @property expressSyncId The ID of the Express Sync.
 * @property expressSyncName The name of the Express Sync.
 * @property id
 * @property mnsTopic The name of the message topic (Topic) corresponding to the Express Sync in the Alibaba Cloud Message Service MNS.
 */
public data class GetExpressSyncsSync(
    public val bucketName: String,
    public val bucketPrefix: String,
    public val bucketRegion: String,
    public val description: String,
    public val expressSyncId: String,
    public val expressSyncName: String,
    public val id: String,
    public val mnsTopic: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetExpressSyncsSync): GetExpressSyncsSync = GetExpressSyncsSync(
            bucketName = javaType.bucketName(),
            bucketPrefix = javaType.bucketPrefix(),
            bucketRegion = javaType.bucketRegion(),
            description = javaType.description(),
            expressSyncId = javaType.expressSyncId(),
            expressSyncName = javaType.expressSyncName(),
            id = javaType.id(),
            mnsTopic = javaType.mnsTopic(),
        )
    }
}
