@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The IP ADDRESS.
 * @property cacheMode The Block volume set mode to cache mode. Valid values: `Cache`, `WriteThrough`.
 * @property chapEnabled Whether to enable iSCSI access of CHAP authentication, which currently supports both CHAP inbound authentication.  Default value: `false`.
 * @property chapInUser The Inbound CHAP user.**NOTE:** When the `chap_enabled` is  `true` is,The `chap_in_password` is valid.
 * @property chunkSize The Block volume storage allocation unit.  Valid values: `8192`, `16384`, `32768`, `65536`, `131072`. Default value: `32768`. Unit: `Byte`.
 * @property diskId The cache disk ID.
 * @property diskType The cache disk type.
 * @property enabled Whether to enable Volume.
 * @property gatewayBlockVolumeName The Block volume name.  The name must be 1 to 32 characters in length, and can contain lowercase letters, numbers.
 * @property gatewayId The Gateway ID.
 * @property id The ID of the Gateway Block Volume. The value formats as `<gateway_id>:<index_id>`.
 * @property indexId The ID of the index.
 * @property localPath CThe Cache disk to local path. **NOTE:**  When the `cache_mode` is  `Cache` is,The `chap_in_password` is valid.
 * @property lunId The Lun identifier.
 * @property ossBucketName The name of the OSS Bucket.
 * @property ossBucketSsl Whether to enable SSL access your OSS Buckets. Default value: `true`.
 * @property ossEndpoint The endpoint of the OSS Bucket.
 * @property port The Port.
 * @property protocol The Protocol.
 * @property size The Volume size.
 * @property state The Buffer status.
 * @property status The status of volume.
 * @property target The target.
 * @property totalDownload The total amount of downloaded data. Unit: `B`.
 * @property totalUpload The total amount of uploaded data. Unit: `B`.
 * @property volumeState
 */
public data class GetGatewayBlockVolumesVolume(
    public val address: String,
    public val cacheMode: String,
    public val chapEnabled: Boolean,
    public val chapInUser: String,
    public val chunkSize: Int,
    public val diskId: String,
    public val diskType: String,
    public val enabled: Boolean,
    public val gatewayBlockVolumeName: String,
    public val gatewayId: String,
    public val id: String,
    public val indexId: String,
    public val localPath: String,
    public val lunId: Int,
    public val ossBucketName: String,
    public val ossBucketSsl: Boolean,
    public val ossEndpoint: String,
    public val port: Int,
    public val protocol: String,
    public val size: Int,
    public val state: String,
    public val status: Int,
    public val target: String,
    public val totalDownload: Int,
    public val totalUpload: Int,
    public val volumeState: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetGatewayBlockVolumesVolume): GetGatewayBlockVolumesVolume = GetGatewayBlockVolumesVolume(
            address = javaType.address(),
            cacheMode = javaType.cacheMode(),
            chapEnabled = javaType.chapEnabled(),
            chapInUser = javaType.chapInUser(),
            chunkSize = javaType.chunkSize(),
            diskId = javaType.diskId(),
            diskType = javaType.diskType(),
            enabled = javaType.enabled(),
            gatewayBlockVolumeName = javaType.gatewayBlockVolumeName(),
            gatewayId = javaType.gatewayId(),
            id = javaType.id(),
            indexId = javaType.indexId(),
            localPath = javaType.localPath(),
            lunId = javaType.lunId(),
            ossBucketName = javaType.ossBucketName(),
            ossBucketSsl = javaType.ossBucketSsl(),
            ossEndpoint = javaType.ossEndpoint(),
            port = javaType.port(),
            protocol = javaType.protocol(),
            size = javaType.size(),
            state = javaType.state(),
            status = javaType.status(),
            target = javaType.target(),
            totalDownload = javaType.totalDownload(),
            totalUpload = javaType.totalUpload(),
            volumeState = javaType.volumeState(),
        )
    }
}
