@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cacheDiskCategory The category of eht cache disk.
 * @property cacheDiskSizeInGb The size of the cache disk.
 * @property cacheId The ID of the cache disk.
 * @property expiredTime The expiration time. Time stamp in seconds (s).
 * @property gatewayId The ID of the gateway.
 * @property id The ID of the Gateway Cache Disk.
 * @property iops Per second of the input output.
 * @property isUsed Whether it is used.
 * @property localFilePath The cache disk inside the device name.
 * @property renewUrl A renewal link of the cache disk.
 * @property status The status of the resource.
 */
public data class GetGatewayCacheDisksDisk(
    public val cacheDiskCategory: String,
    public val cacheDiskSizeInGb: Int,
    public val cacheId: String,
    public val expiredTime: Int,
    public val gatewayId: String,
    public val id: String,
    public val iops: Int,
    public val isUsed: Boolean,
    public val localFilePath: String,
    public val renewUrl: String,
    public val status: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetGatewayCacheDisksDisk): GetGatewayCacheDisksDisk = GetGatewayCacheDisksDisk(
            cacheDiskCategory = javaType.cacheDiskCategory(),
            cacheDiskSizeInGb = javaType.cacheDiskSizeInGb(),
            cacheId = javaType.cacheId(),
            expiredTime = javaType.expiredTime(),
            gatewayId = javaType.gatewayId(),
            id = javaType.id(),
            iops = javaType.iops(),
            isUsed = javaType.isUsed(),
            localFilePath = javaType.localFilePath(),
            renewUrl = javaType.renewUrl(),
            status = javaType.status(),
        )
    }
}
