@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGatewayCacheDisks.
 * @property disks
 * @property gatewayId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property status
 */
public data class GetGatewayCacheDisksResult(
    public val disks: List<GetGatewayCacheDisksDisk>,
    public val gatewayId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetGatewayCacheDisksResult): GetGatewayCacheDisksResult = GetGatewayCacheDisksResult(
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewayCacheDisksDisk.Companion.toKotlin(args0)
                })
            }),
            gatewayId = javaType.gatewayId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
