@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessBasedEnumeration The set up gateway file share Server Message Block (SMB) protocol, whether to enable Windows ABE, the prime minister, need windowsAcl parameter is set to true in the entry into force of. Default value: `false`. **NOTE:** Gateway version >= 1.0.45 above support.
 * @property address Share the private IP address of the RDS instance.
 * @property backendLimit The set up gateway file share Max upload speed. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`. **NOTE:** at the same time if you have to limit the maximum write speed, maximum upload speed is no less than the maximum write speed.
 * @property browsable The set up gateway file share Server Message Block (SMB) protocol whether browsable (that is, in the network neighborhood of whether you can find). The parameters in the NFS protocol not valid under. Default value: `true`.
 * @property bucketInfos Multi-Bucket information.
 * @property bucketsStub Whether there are multiple buckets.
 * @property bypassCacheRead Direct reading OSS of the gateway file share.
 * @property cacheMode The cache mode of the gateway file share. Value range: Cache: cached mode. Sync: replication mode are available.
 * @property clientSideCmk File share is enabled to client-side encryption, the encryption by the use of the KMS key. **NOTE:** note: This KMS key must be the gateway and is in the same Region.
 * @property clientSideEncryption Whether to enabled to client-side encryption of the gateway file share. Default value: `false`. **NOTE:** need to contact us open whitelist before you can the settings, and only supports enhanced more than online gateway, at the same time, server-side encryption and to client-side encryption can not simultaneously configuration.
 * @property directIo Whether directio (direct I/O data transfer) is enabled for file share. Default: `false`.
 * @property diskId The ID of the disk.
 * @property diskType The cache disk type. Valid values: `cloud_efficiency`: Ultra cloud disk. `cloud_ssd`:SSD cloud disk.
 * @property downloadLimit The set up gateway file share maximum download speed. Unit: `MB/s`. `0` means unlimited. Value range: `0` ~ `1280`. **NOTE:** only in copy mode and enable download file data can be set. only when the shared opens the reverse synchronization or acceded to by the speed synchronization Group when, this parameter will not take effect. Gateway version >= 1.3.0 above support.
 * @property enabled Shared whether the changes take effect.
 * @property expressSyncId Speed synchronization group ID.
 * @property fastReclaim The set up gateway file share whether to enable Upload optimization, which is suitable for data pure backup migration scenarios. Default value: `false`. **NOTE:** Gateway version >= 1.0.39 above support.
 * @property feLimit The set up gateway file share and the maximum write speed. Unit: `MB/s`, `0` means unlimited. Value range: `0` ~ `1280`. Default value: `0`.
 * @property fileNumLimit Supported by the file system file number.
 * @property fsSizeLimit File system capacity. Unit: `B`.
 * @property gatewayFileShareName The name of the file share. Length from `1` to `255` characters can contain lowercase letters, digits, (.), (_) Or (-), at the same time, must start with a lowercase letter.
 * @property gatewayId The ID of the gateway.
 * @property id The ID of the Gateway File Share.
 * @property ignoreDelete Whether to ignore deleted of the gateway file share. After the opening of the Gateway side delete file or delete cloud (OSS) corresponding to the file. Default value: `false`. **NOTE:** Gateway version >= 1.0.40 above support.
 * @property inPlace Whether debris optimization of the gateway file share. Default value: `false`.
 * @property inRate Cache growth. Unit: `B/s`.
 * @property indexId The ID of the file share.
 * @property kmsRotatePeriod File share is enabled to client-side encryption, key rotation period of time. Seconds. 0 represents no rotation. Rotation of the value range: `3600` ~ `86400`. Default value: `0`.
 * @property lagPeriod The synchronization delay, I.e. gateway local cache sync to Alibaba Cloud Object Storage Service (oss) of the delay time. Unit: `Seconds`. Value range: `5` ~ `120`. Default value: `5`. **NOTE:** Gateway version >= 1.0.40 above support.
 * @property localPath The cache disk inside the device name.
 * @property mnsHealth The messages from the queue health types. Valid values: `TopicAndQueueFailure`: A Message Queuing message theme can be accessed during the black hole period. `TopicFailure`: a message theme can be accessed during the black hole period. `MNSFullSyncInit`: full synchronization wait. `MNSFullSyncing`: full synchronization in progress. `QueueFailure`: a message queue can be accessed during the black hole period. `MNSNotEnabled`: Top speed synchronization is not enabled. `MNSHealthy`: sync fine.
 * @property nfsV4Optimization The set up gateway file share NFS protocol, whether to enable NFS v4 optimization improve Mount Upload efficiency. Default value: `false`. **NOTE:** turns on after I will not support NFS v3 mount the filesystem on a. Gateway version >= 1.2.0 above support.
 * @property obsoleteBuckets Multi-Bucket, removing the Bucket.
 * @property ossBucketName The name of the Bucket.
 * @property ossBucketSsl Whether they are using SSL connect to OSS Bucket.
 * @property ossEndpoint The set up gateway file share corresponds to the Object Storage SERVICE (OSS), Bucket Endpoint. **NOTE:** distinguish between intranet and internet Endpoint. We recommend that if the OSS Bucket and the gateway is in the same Region is use the RDS intranet IP Endpoint:oss-cn-hangzhou-internal.aliyuncs.com.
 * @property ossHealth The OSS Bucket of type. Valid values: `BucketHealthy`: OSS connectivity. `BucketAccessDenied`: OBJECT STORAGE Service (OSS) access to an exception. `BucketMiscFailure`: OBJECT STORAGE Service (OSS) access to additional exception. `BucketNetworkFailure`: OBJECT STORAGE Service (OSS) access network an exception. `BucketNotExist`: OSS Bucket does not exist. `Nothing returns`: We may not have ever known existed.
 * @property ossUsed For a cloud-based data is. Unit: `B`.
 * @property outRate Upload speed. Unit: `B/s`.
 * @property partialSyncPaths In part mode, the directory path group JSON format.
 * @property pathPrefix The prefix of the OSS.
 * @property pollingInterval The reverse synchronization time intervals of the gateway file share. Value range: `15` ~ `36000`. **NOTE:** in copy mode + reverse synchronization is enabled Download file data, value range: `3600` ~ `36000`.
 * @property protocol Share types. Valid values: `SMB`, `NFS`.
 * @property remainingMetaSpace You can use the metadata space. Unit: `B`.
 * @property remoteSync Whether to enable reverse synchronization of the gateway file share. Default value: `false`.
 * @property remoteSyncDownload Copy mode, whether to download the file data. Default value: `false`. **NOTE:** only when the shared opens the reverse synchronization or acceded to by the speed synchronization group, this parameter will not take effect.
 * @property roClientList The read-only client list. When Protocol NFS is returned when the status is.
 * @property roUserList The read-only client list. When Protocol for Server Message Block (SMB) to go back to.
 * @property rwClientList Read and write the client list. When Protocol NFS is returned when the status is.
 * @property rwUserList Read-write user list. When Protocol for Server Message Block (SMB) to go back to.
 * @property serverSideCmk File share is enabled server-side encryption, encryption used by the KMS key.
 * @property serverSideEncryption If the OSS Bucket side encryption.
 * @property size The caching capacity. Unit: `B`.
 * @property squash The set up gateway file share NFS protocol user mapping. Valid values: `none`, `root_squash`, `all_squash`, `all_anonymous`. Default value: `none`.
 * @property state File synchronization types. Valid values: `clean`, `dirty`. `clean`: synchronization is complete. `dirty`: synchronization has not been completed.
 * @property supportArchive Whether to support the archive transparent read.
 * @property syncProgress Full synchronization progress. When the share has been added for a synchronization group, the return parameters are valid, that shared full synchronization progress (0~100). `-2`: indicates that share the Gateway version does not support this feature. `-1`: the share does not occur full synchronization.
 * @property totalDownload The OSS Bucket to the Gateway total downloads. Unit: `B`.
 * @property totalUpload The OSS Bucket to the Gateway total Upload amount. Unit: `B`.
 * @property transferAcceleration The set up gateway file share whether to enable transmission acceleration needs corresponding OSS Bucket enabled transport acceleration. **NOTE:** Gateway version >= 1.3.0 above support.
 * @property used Used cache. Unit: `B`.
 * @property windowsAcl The set up gateway file share Server Message Block (SMB) protocol, whether to enable by Windows access list (requires AD domain) the permissions control. Default value: `false`. **NOTE:** Gateway version >= 1.0.45 above support.
 */
public data class GetGatewayFileSharesShare(
    public val accessBasedEnumeration: Boolean,
    public val address: String,
    public val backendLimit: Int,
    public val browsable: Boolean,
    public val bucketInfos: String,
    public val bucketsStub: Boolean,
    public val bypassCacheRead: Boolean,
    public val cacheMode: String,
    public val clientSideCmk: String,
    public val clientSideEncryption: Boolean,
    public val directIo: Boolean,
    public val diskId: String,
    public val diskType: String,
    public val downloadLimit: Int,
    public val enabled: Boolean,
    public val expressSyncId: String,
    public val fastReclaim: Boolean,
    public val feLimit: Int,
    public val fileNumLimit: String,
    public val fsSizeLimit: String,
    public val gatewayFileShareName: String,
    public val gatewayId: String,
    public val id: String,
    public val ignoreDelete: Boolean,
    public val inPlace: Boolean,
    public val inRate: String,
    public val indexId: String,
    public val kmsRotatePeriod: Int,
    public val lagPeriod: String,
    public val localPath: String,
    public val mnsHealth: String,
    public val nfsV4Optimization: Boolean,
    public val obsoleteBuckets: String,
    public val ossBucketName: String,
    public val ossBucketSsl: Boolean,
    public val ossEndpoint: String,
    public val ossHealth: String,
    public val ossUsed: String,
    public val outRate: String,
    public val partialSyncPaths: String,
    public val pathPrefix: String,
    public val pollingInterval: Int,
    public val protocol: String,
    public val remainingMetaSpace: String,
    public val remoteSync: Boolean,
    public val remoteSyncDownload: Boolean,
    public val roClientList: String,
    public val roUserList: String,
    public val rwClientList: String,
    public val rwUserList: String,
    public val serverSideCmk: String,
    public val serverSideEncryption: Boolean,
    public val size: String,
    public val squash: String,
    public val state: String,
    public val supportArchive: Boolean,
    public val syncProgress: Int,
    public val totalDownload: String,
    public val totalUpload: String,
    public val transferAcceleration: Boolean,
    public val used: String,
    public val windowsAcl: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetGatewayFileSharesShare): GetGatewayFileSharesShare = GetGatewayFileSharesShare(
            accessBasedEnumeration = javaType.accessBasedEnumeration(),
            address = javaType.address(),
            backendLimit = javaType.backendLimit(),
            browsable = javaType.browsable(),
            bucketInfos = javaType.bucketInfos(),
            bucketsStub = javaType.bucketsStub(),
            bypassCacheRead = javaType.bypassCacheRead(),
            cacheMode = javaType.cacheMode(),
            clientSideCmk = javaType.clientSideCmk(),
            clientSideEncryption = javaType.clientSideEncryption(),
            directIo = javaType.directIo(),
            diskId = javaType.diskId(),
            diskType = javaType.diskType(),
            downloadLimit = javaType.downloadLimit(),
            enabled = javaType.enabled(),
            expressSyncId = javaType.expressSyncId(),
            fastReclaim = javaType.fastReclaim(),
            feLimit = javaType.feLimit(),
            fileNumLimit = javaType.fileNumLimit(),
            fsSizeLimit = javaType.fsSizeLimit(),
            gatewayFileShareName = javaType.gatewayFileShareName(),
            gatewayId = javaType.gatewayId(),
            id = javaType.id(),
            ignoreDelete = javaType.ignoreDelete(),
            inPlace = javaType.inPlace(),
            inRate = javaType.inRate(),
            indexId = javaType.indexId(),
            kmsRotatePeriod = javaType.kmsRotatePeriod(),
            lagPeriod = javaType.lagPeriod(),
            localPath = javaType.localPath(),
            mnsHealth = javaType.mnsHealth(),
            nfsV4Optimization = javaType.nfsV4Optimization(),
            obsoleteBuckets = javaType.obsoleteBuckets(),
            ossBucketName = javaType.ossBucketName(),
            ossBucketSsl = javaType.ossBucketSsl(),
            ossEndpoint = javaType.ossEndpoint(),
            ossHealth = javaType.ossHealth(),
            ossUsed = javaType.ossUsed(),
            outRate = javaType.outRate(),
            partialSyncPaths = javaType.partialSyncPaths(),
            pathPrefix = javaType.pathPrefix(),
            pollingInterval = javaType.pollingInterval(),
            protocol = javaType.protocol(),
            remainingMetaSpace = javaType.remainingMetaSpace(),
            remoteSync = javaType.remoteSync(),
            remoteSyncDownload = javaType.remoteSyncDownload(),
            roClientList = javaType.roClientList(),
            roUserList = javaType.roUserList(),
            rwClientList = javaType.rwClientList(),
            rwUserList = javaType.rwUserList(),
            serverSideCmk = javaType.serverSideCmk(),
            serverSideEncryption = javaType.serverSideEncryption(),
            size = javaType.size(),
            squash = javaType.squash(),
            state = javaType.state(),
            supportArchive = javaType.supportArchive(),
            syncProgress = javaType.syncProgress(),
            totalDownload = javaType.totalDownload(),
            totalUpload = javaType.totalUpload(),
            transferAcceleration = javaType.transferAcceleration(),
            used = javaType.used(),
            windowsAcl = javaType.windowsAcl(),
        )
    }
}
