@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGatewaySmbUsers.
 * @property gatewayId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property outputFile
 * @property users
 */
public data class GetGatewaySmbUsersResult(
    public val gatewayId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val users: List<GetGatewaySmbUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetGatewaySmbUsersResult): GetGatewaySmbUsersResult = GetGatewaySmbUsersResult(
            gatewayId = javaType.gatewayId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            users = javaType.users().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewaySmbUsersUser.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
