@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property activatedTime gateway .
 * @property buyUrl
 * @property category gateway category.
 * @property createTime gateway created timestamp in second format.
 * @property description gateway description.
 * @property ecsInstanceId gateway ecs instance id.
 * @property expireStatus gateway expiration status.
 * @property expiredTime gateway expiration timestamp in second format.
 * @property gatewayClass gateway class.
 * @property gatewayId gateway id.
 * @property gatewayName gateway name.
 * @property gatewayVersion gateway version.
 * @property id The ID of the Gateway.
 * @property innerIp gateway service ip.
 * @property ip gateway public ip.
 * @property isReleaseAfterExpiration whether subscription gateway is released after expiration or not.
 * @property location gateway location.
 * @property paymentType gateway payment type. The Payment type of gateway. The valid value: `PayAsYouGo`, `Subscription`.
 * @property publicNetworkBandwidth gateway public network bandwidth.
 * @property renewUrl
 * @property status gateway status.
 * @property storageBundleId storage bundle id.
 * @property taskId gateway task id.
 * @property type gateway type.
 * @property vpcId gateway vpc id.
 * @property vswitchId The vswitch id.
 */
public data class GetGatewaysGateway(
    public val activatedTime: String,
    public val buyUrl: String,
    public val category: String,
    public val createTime: String,
    public val description: String,
    public val ecsInstanceId: String,
    public val expireStatus: Int,
    public val expiredTime: String,
    public val gatewayClass: String,
    public val gatewayId: String,
    public val gatewayName: String,
    public val gatewayVersion: String,
    public val id: String,
    public val innerIp: String,
    public val ip: String,
    public val isReleaseAfterExpiration: Boolean,
    public val location: String,
    public val paymentType: String,
    public val publicNetworkBandwidth: Int,
    public val renewUrl: String,
    public val status: String,
    public val storageBundleId: String,
    public val taskId: String,
    public val type: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetGatewaysGateway): GetGatewaysGateway = GetGatewaysGateway(
            activatedTime = javaType.activatedTime(),
            buyUrl = javaType.buyUrl(),
            category = javaType.category(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            ecsInstanceId = javaType.ecsInstanceId(),
            expireStatus = javaType.expireStatus(),
            expiredTime = javaType.expiredTime(),
            gatewayClass = javaType.gatewayClass(),
            gatewayId = javaType.gatewayId(),
            gatewayName = javaType.gatewayName(),
            gatewayVersion = javaType.gatewayVersion(),
            id = javaType.id(),
            innerIp = javaType.innerIp(),
            ip = javaType.ip(),
            isReleaseAfterExpiration = javaType.isReleaseAfterExpiration(),
            location = javaType.location(),
            paymentType = javaType.paymentType(),
            publicNetworkBandwidth = javaType.publicNetworkBandwidth(),
            renewUrl = javaType.renewUrl(),
            status = javaType.status(),
            storageBundleId = javaType.storageBundleId(),
            taskId = javaType.taskId(),
            type = javaType.type(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
