@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGateways.
 * @property gateways
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status
 * @property storageBundleId
 * @property totalCount
 */
public data class GetGatewaysResult(
    public val gateways: List<GetGatewaysGateway>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    public val storageBundleId: String,
    public val totalCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetGatewaysResult): GetGatewaysResult = GetGatewaysResult(
            gateways = javaType.gateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetGatewaysGateway.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            storageBundleId = javaType.storageBundleId(),
            totalCount = javaType.totalCount(),
        )
    }
}
