@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getStocks.
 * @property gatewayClass
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property stocks
 */
public data class GetStocksResult(
    public val gatewayClass: String? = null,
    public val id: String,
    public val outputFile: String? = null,
    public val stocks: List<GetStocksStock>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cloudstoragegateway.outputs.GetStocksResult): GetStocksResult = GetStocksResult(
            gatewayClass = javaType.gatewayClass().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            stocks = javaType.stocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cloudstoragegateway.kotlin.outputs.GetStocksStock.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
