@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.AlarmCompositeExpression
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmEscalationsCritical
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmEscalationsInfo
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmEscalationsWarn
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmPrometheus
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmTarget
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmCompositeExpression.Companion.toKotlin as alarmCompositeExpressionToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmEscalationsCritical.Companion.toKotlin as alarmEscalationsCriticalToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmEscalationsInfo.Companion.toKotlin as alarmEscalationsInfoToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmEscalationsWarn.Companion.toKotlin as alarmEscalationsWarnToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmPrometheus.Companion.toKotlin as alarmPrometheusToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.AlarmTarget.Companion.toKotlin as alarmTargetToKotlin

/**
 * Builder for [Alarm].
 */
@PulumiTagMarker
public class AlarmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlarmArgs = AlarmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlarmArgsBuilder.() -> Unit) {
        val builder = AlarmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Alarm {
        val builtJavaResource = com.pulumi.alicloud.cms.Alarm(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alarm(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Alarm resource.
 * For information about Cloud Monitor Service Alarm and how to use it, see [What is Alarm](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putresourcemetricrule).
 * > **NOTE:** Available since v1.9.1.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultGetInstanceTypes = Promise.all([_default, defaultGetImages])&#46;then(([_default, defaultGetImages]) => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     imageId: defaultGetImages.images?.[0]?.id,
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     instanceName: name,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroups: [defaultSecurityGroup&#46;id],
 *     vswitchId: defaultSwitch.id,
 * });
 * const defaultAlarmContactGroup = new alicloud.cms.AlarmContactGroup("default", {alarmContactGroupName: name});
 * const defaultAlarm = new alicloud.cms.Alarm("default", {
 *     name: name,
 *     project: "acs_ecs_dashboard",
 *     metric: "disk_writebytes",
 *     period: 900,
 *     contactGroups: [defaultAlarmContactGroup&#46;alarmContactGroupName],
 *     effectiveInterval: "06:00-20:00",
 *     metricDimensions: pulumi.interpolate`  [
 *     {
 *       "instanceId": "${defaultInstance.id}",
 *       "device": "/dev/vda1"
 *     }
 *   ]
 * `,
 *     escalationsCritical: {
 *         statistics: "Average",
 *         comparisonOperator: "<=",
 *         threshold: "35",
 *         times: 2,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_images = alicloud.ecs.get_images(most_recent=True,
 *     owners="system")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     image_id=default_get_images.images[0].id)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_instance = alicloud.ecs.Instance("default",
 *     availability_zone=default.zones[0].id,
 *     instance_name=name,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_groups=[default_security_group&#46;id],
 *     vswitch_id=default_switch.id)
 * default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
 * default_alarm = alicloud.cms.Alarm("default",
 *     name=name,
 *     project="acs_ecs_dashboard",
 *     metric="disk_writebytes",
 *     period=900,
 *     contact_groups=[default_alarm_contact_group&#46;alarm_contact_group_name],
 *     effective_interval="06:00-20:00",
 *     metric_dimensions=default_instance.id.apply(lambda id: f"""  [
 *     {{
 *       "instanceId": "{id}",
 *       "device": "/dev/vda1"
 *     }}
 *   ]
 * """),
 *     escalations_critical={
 *         "statistics": "Average",
 *         "comparison_operator": "<=",
 *         "threshold": "35",
 *         "times": 2,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         InstanceName = name,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroups = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var defaultAlarmContactGroup = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *     });
 *     var defaultAlarm = new AliCloud.Cms.Alarm("default", new()
 *     {
 *         Name = name,
 *         Project = "acs_ecs_dashboard",
 *         Metric = "disk_writebytes",
 *         Period = 900,
 *         ContactGroups = new[]
 *         {
 *             defaultAlarmContactGroup.AlarmContactGroupName,
 *         },
 *         EffectiveInterval = "06:00-20:00",
 *         MetricDimensions = defaultInstance.Id.Apply(id => @$"  [
 *     {{
 *       ""instanceId"": ""{id}"",
 *       ""device"": ""/dev/vda1""
 *     }}
 *   ]
 * "),
 *         EscalationsCritical = new AliCloud.Cms.Inputs.AlarmEscalationsCriticalArgs
 *         {
 *             Statistics = "Average",
 *             ComparisonOperator = "<=",
 *             Threshold = "35",
 *             Times = 2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			ImageId:          pulumi.StringRef(defaultGetImages.Images[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * 			InstanceName:     pulumi.String(name),
 * 			ImageId:          pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:     pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroups: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			VswitchId: defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlarmContactGroup, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewAlarm(ctx, "default", &cms.AlarmArgs{
 * 			Name:    pulumi.String(name),
 * 			Project: pulumi.String("acs_ecs_dashboard"),
 * 			Metric:  pulumi.String("disk_writebytes"),
 * 			Period:  pulumi.Int(900),
 * 			ContactGroups: pulumi.StringArray{
 * 				defaultAlarmContactGroup.AlarmContactGroupName,
 * 			},
 * 			EffectiveInterval: pulumi.String("06:00-20:00"),
 * 			MetricDimensions: defaultInstance.ID().ApplyT(func(id string) (string, error) {
 * 				return fmt.Sprintf(`  [
 *     {
 *       "instanceId": "%v",
 *       "device": "/dev/vda1"
 *     }
 *   ]
 * `, id), nil
 * 			}).(pulumi.StringOutput),
 * 			EscalationsCritical: &cms.AlarmEscalationsCriticalArgs{
 * 				Statistics:         pulumi.String("Average"),
 * 				ComparisonOperator: pulumi.String("<="),
 * 				Threshold:          pulumi.String("35"),
 * 				Times:              pulumi.Int(2),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.cms.Alarm;
 * import com.pulumi.alicloud.cms.AlarmArgs;
 * import com.pulumi.alicloud.cms.inputs.AlarmEscalationsCriticalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceName(name)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroups(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         var defaultAlarmContactGroup = new AlarmContactGroup("defaultAlarmContactGroup", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .build());
 *         var defaultAlarm = new Alarm("defaultAlarm", AlarmArgs.builder()
 *             .name(name)
 *             .project("acs_ecs_dashboard")
 *             .metric("disk_writebytes")
 *             .period(900)
 *             .contactGroups(defaultAlarmContactGroup.alarmContactGroupName())
 *             .effectiveInterval("06:00-20:00")
 *             .metricDimensions(defaultInstance.id().applyValue(id -> """
 *   [
 *     {
 *       "instanceId": "%s",
 *       "device": "/dev/vda1"
 *     }
 *   ]
 * ", id)))
 *             .escalationsCritical(AlarmEscalationsCriticalArgs.builder()
 *                 .statistics("Average")
 *                 .comparisonOperator("<=")
 *                 .threshold(35)
 *                 .times(2)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:ecs:Instance
 *     name: default
 *     properties:
 *       availabilityZone: ${default.zones[0].id}
 *       instanceName: ${name}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroups:
 *         - ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *   defaultAlarmContactGroup:
 *     type: alicloud:cms:AlarmContactGroup
 *     name: default
 *     properties:
 *       alarmContactGroupName: ${name}
 *   defaultAlarm:
 *     type: alicloud:cms:Alarm
 *     name: default
 *     properties:
 *       name: ${name}
 *       project: acs_ecs_dashboard
 *       metric: disk_writebytes
 *       period: 900
 *       contactGroups:
 *         - ${defaultAlarmContactGroup.alarmContactGroupName}
 *       effectiveInterval: 06:00-20:00
 *       metricDimensions: |2
 *           [
 *             {
 *               "instanceId": "${defaultInstance.id}",
 *               "device": "/dev/vda1"
 *             }
 *           ]
 *       escalationsCritical:
 *         statistics: Average
 *         comparisonOperator: <=
 *         threshold: 35
 *         times: 2
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         mostRecent: true
 *         owners: system
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         imageId: ${defaultGetImages.images[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Alarm can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/alarm:Alarm example <id>
 * ```
 */
public class Alarm internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.Alarm,
) : KotlinCustomResource(javaResource, AlarmMapper) {
    /**
     * The trigger conditions for multiple metrics. See `composite_expression` below.
     */
    public val compositeExpression: Output<AlarmCompositeExpression>?
        get() = javaResource.compositeExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> alarmCompositeExpressionToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List contact groups of the alarm rule, which must have been created on the console.
     */
    public val contactGroups: Output<List<String>>
        get() = javaResource.contactGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
     */
    @Deprecated(
        message = """
  Field `dimensions` has been deprecated from provider version 1.173.0. New field
      `metric_dimensions` instead.
  """,
    )
    public val dimensions: Output<Map<String, String>>
        get() = javaResource.dimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
     */
    public val effectiveInterval: Output<String>?
        get() = javaResource.effectiveInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable alarm rule. Default value: `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
     */
    @Deprecated(
        message = """
  Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval`
      instead.
  """,
    )
    public val endTime: Output<Int>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A configuration of critical alarm. See `escalations_critical` below.
     */
    public val escalationsCritical: Output<AlarmEscalationsCritical>
        get() = javaResource.escalationsCritical().applyValue({ args0 ->
            args0.let({ args0 ->
                alarmEscalationsCriticalToKotlin(args0)
            })
        })

    /**
     * A configuration of critical info. See `escalations_info` below.
     */
    public val escalationsInfo: Output<AlarmEscalationsInfo>
        get() = javaResource.escalationsInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                alarmEscalationsInfoToKotlin(args0)
            })
        })

    /**
     * A configuration of critical warn. See `escalations_warn` below.
     */
    public val escalationsWarn: Output<AlarmEscalationsWarn>
        get() = javaResource.escalationsWarn().applyValue({ args0 ->
            args0.let({ args0 ->
                alarmEscalationsWarnToKotlin(args0)
            })
        })

    /**
     * The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    public val metric: Output<String>
        get() = javaResource.metric().applyValue({ args0 -> args0 })

    /**
     * Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    public val metricDimensions: Output<String>
        get() = javaResource.metricDimensions().applyValue({ args0 -> args0 })

    /**
     * The name of the alert rule.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The statistical period of the metric. Unit: seconds. Default value: `300`.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     * **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
     */
    public val prometheuses: Output<List<AlarmPrometheus>>
        get() = javaResource.prometheuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    alarmPrometheusToKotlin(args0)
                })
            })
        })

    /**
     * Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
     */
    public val silenceTime: Output<Int>?
        get() = javaResource.silenceTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
     */
    @Deprecated(
        message = """
  Field `start_time` has been deprecated from provider version 1.50.0. New field
      `effective_interval` instead.
  """,
    )
    public val startTime: Output<Int>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the Alarm.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The information about the resource for which alerts are triggered. See `targets` below.
     */
    public val targets: Output<List<AlarmTarget>>
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    alarmTargetToKotlin(args0)
                })
            })
        })

    /**
     * The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
     */
    public val webhook: Output<String>?
        get() = javaResource.webhook().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AlarmMapper : ResourceMapper<Alarm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.Alarm::class == javaResource::class

    override fun map(javaResource: Resource): Alarm = Alarm(
        javaResource as
            com.pulumi.alicloud.cms.Alarm,
    )
}

/**
 * @see [Alarm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alarm].
 */
public suspend fun alarm(name: String, block: suspend AlarmResourceBuilder.() -> Unit): Alarm {
    val builder = AlarmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alarm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alarm(name: String): Alarm {
    val builder = AlarmResourceBuilder()
    builder.name(name)
    return builder.build()
}
