@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.AlarmArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmCompositeExpressionArgs
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmCompositeExpressionArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmEscalationsCriticalArgs
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmEscalationsCriticalArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmEscalationsInfoArgs
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmEscalationsInfoArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmEscalationsWarnArgs
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmEscalationsWarnArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmPrometheusArgs
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmPrometheusArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmTargetArgs
import com.pulumi.alicloud.cms.kotlin.inputs.AlarmTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Alarm resource.
 * For information about Cloud Monitor Service Alarm and how to use it, see [What is Alarm](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putresourcemetricrule).
 * > **NOTE:** Available since v1.9.1.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultGetInstanceTypes = Promise.all([_default, defaultGetImages])&#46;then(([_default, defaultGetImages]) => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     imageId: defaultGetImages.images?.[0]?.id,
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     instanceName: name,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroups: [defaultSecurityGroup&#46;id],
 *     vswitchId: defaultSwitch.id,
 * });
 * const defaultAlarmContactGroup = new alicloud.cms.AlarmContactGroup("default", {alarmContactGroupName: name});
 * const defaultAlarm = new alicloud.cms.Alarm("default", {
 *     name: name,
 *     project: "acs_ecs_dashboard",
 *     metric: "disk_writebytes",
 *     period: 900,
 *     contactGroups: [defaultAlarmContactGroup&#46;alarmContactGroupName],
 *     effectiveInterval: "06:00-20:00",
 *     metricDimensions: pulumi.interpolate`  [
 *     {
 *       "instanceId": "${defaultInstance.id}",
 *       "device": "/dev/vda1"
 *     }
 *   ]
 * `,
 *     escalationsCritical: {
 *         statistics: "Average",
 *         comparisonOperator: "<=",
 *         threshold: "35",
 *         times: 2,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_images = alicloud.ecs.get_images(most_recent=True,
 *     owners="system")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     image_id=default_get_images.images[0].id)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_instance = alicloud.ecs.Instance("default",
 *     availability_zone=default.zones[0].id,
 *     instance_name=name,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_groups=[default_security_group&#46;id],
 *     vswitch_id=default_switch.id)
 * default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
 * default_alarm = alicloud.cms.Alarm("default",
 *     name=name,
 *     project="acs_ecs_dashboard",
 *     metric="disk_writebytes",
 *     period=900,
 *     contact_groups=[default_alarm_contact_group&#46;alarm_contact_group_name],
 *     effective_interval="06:00-20:00",
 *     metric_dimensions=default_instance.id.apply(lambda id: f"""  [
 *     {{
 *       "instanceId": "{id}",
 *       "device": "/dev/vda1"
 *     }}
 *   ]
 * """),
 *     escalations_critical={
 *         "statistics": "Average",
 *         "comparison_operator": "<=",
 *         "threshold": "35",
 *         "times": 2,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         InstanceName = name,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroups = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var defaultAlarmContactGroup = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *     });
 *     var defaultAlarm = new AliCloud.Cms.Alarm("default", new()
 *     {
 *         Name = name,
 *         Project = "acs_ecs_dashboard",
 *         Metric = "disk_writebytes",
 *         Period = 900,
 *         ContactGroups = new[]
 *         {
 *             defaultAlarmContactGroup.AlarmContactGroupName,
 *         },
 *         EffectiveInterval = "06:00-20:00",
 *         MetricDimensions = defaultInstance.Id.Apply(id => @$"  [
 *     {{
 *       ""instanceId"": ""{id}"",
 *       ""device"": ""/dev/vda1""
 *     }}
 *   ]
 * "),
 *         EscalationsCritical = new AliCloud.Cms.Inputs.AlarmEscalationsCriticalArgs
 *         {
 *             Statistics = "Average",
 *             ComparisonOperator = "<=",
 *             Threshold = "35",
 *             Times = 2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			ImageId:          pulumi.StringRef(defaultGetImages.Images[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * 			InstanceName:     pulumi.String(name),
 * 			ImageId:          pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:     pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroups: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			VswitchId: defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlarmContactGroup, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewAlarm(ctx, "default", &cms.AlarmArgs{
 * 			Name:    pulumi.String(name),
 * 			Project: pulumi.String("acs_ecs_dashboard"),
 * 			Metric:  pulumi.String("disk_writebytes"),
 * 			Period:  pulumi.Int(900),
 * 			ContactGroups: pulumi.StringArray{
 * 				defaultAlarmContactGroup.AlarmContactGroupName,
 * 			},
 * 			EffectiveInterval: pulumi.String("06:00-20:00"),
 * 			MetricDimensions: defaultInstance.ID().ApplyT(func(id string) (string, error) {
 * 				return fmt.Sprintf(`  [
 *     {
 *       "instanceId": "%v",
 *       "device": "/dev/vda1"
 *     }
 *   ]
 * `, id), nil
 * 			}).(pulumi.StringOutput),
 * 			EscalationsCritical: &cms.AlarmEscalationsCriticalArgs{
 * 				Statistics:         pulumi.String("Average"),
 * 				ComparisonOperator: pulumi.String("<="),
 * 				Threshold:          pulumi.String("35"),
 * 				Times:              pulumi.Int(2),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.cms.Alarm;
 * import com.pulumi.alicloud.cms.AlarmArgs;
 * import com.pulumi.alicloud.cms.inputs.AlarmEscalationsCriticalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceName(name)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroups(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         var defaultAlarmContactGroup = new AlarmContactGroup("defaultAlarmContactGroup", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .build());
 *         var defaultAlarm = new Alarm("defaultAlarm", AlarmArgs.builder()
 *             .name(name)
 *             .project("acs_ecs_dashboard")
 *             .metric("disk_writebytes")
 *             .period(900)
 *             .contactGroups(defaultAlarmContactGroup.alarmContactGroupName())
 *             .effectiveInterval("06:00-20:00")
 *             .metricDimensions(defaultInstance.id().applyValue(id -> """
 *   [
 *     {
 *       "instanceId": "%s",
 *       "device": "/dev/vda1"
 *     }
 *   ]
 * ", id)))
 *             .escalationsCritical(AlarmEscalationsCriticalArgs.builder()
 *                 .statistics("Average")
 *                 .comparisonOperator("<=")
 *                 .threshold(35)
 *                 .times(2)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:ecs:Instance
 *     name: default
 *     properties:
 *       availabilityZone: ${default.zones[0].id}
 *       instanceName: ${name}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroups:
 *         - ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *   defaultAlarmContactGroup:
 *     type: alicloud:cms:AlarmContactGroup
 *     name: default
 *     properties:
 *       alarmContactGroupName: ${name}
 *   defaultAlarm:
 *     type: alicloud:cms:Alarm
 *     name: default
 *     properties:
 *       name: ${name}
 *       project: acs_ecs_dashboard
 *       metric: disk_writebytes
 *       period: 900
 *       contactGroups:
 *         - ${defaultAlarmContactGroup.alarmContactGroupName}
 *       effectiveInterval: 06:00-20:00
 *       metricDimensions: |2
 *           [
 *             {
 *               "instanceId": "${defaultInstance.id}",
 *               "device": "/dev/vda1"
 *             }
 *           ]
 *       escalationsCritical:
 *         statistics: Average
 *         comparisonOperator: <=
 *         threshold: 35
 *         times: 2
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         mostRecent: true
 *         owners: system
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         imageId: ${defaultGetImages.images[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Alarm can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/alarm:Alarm example <id>
 * ```
 * @property compositeExpression The trigger conditions for multiple metrics. See `composite_expression` below.
 * @property contactGroups List contact groups of the alarm rule, which must have been created on the console.
 * @property dimensions Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
 * @property effectiveInterval The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
 * @property enabled Whether to enable alarm rule. Default value: `true`.
 * @property endTime Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
 * @property escalationsCritical A configuration of critical alarm. See `escalations_critical` below.
 * @property escalationsInfo A configuration of critical info. See `escalations_info` below.
 * @property escalationsWarn A configuration of critical warn. See `escalations_warn` below.
 * @property metric The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
 * @property metricDimensions Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
 * @property name The name of the alert rule.
 * @property period The statistical period of the metric. Unit: seconds. Default value: `300`.
 * @property project The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
 * **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
 * @property prometheuses The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
 * @property silenceTime Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
 * @property startTime Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
 * @property tags A mapping of tags to assign to the resource.
 * @property targets The information about the resource for which alerts are triggered. See `targets` below.
 * @property webhook The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
 */
public data class AlarmArgs(
    public val compositeExpression: Output<AlarmCompositeExpressionArgs>? = null,
    public val contactGroups: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field `dimensions` has been deprecated from provider version 1.173.0. New field
      `metric_dimensions` instead.
  """,
    )
    public val dimensions: Output<Map<String, String>>? = null,
    public val effectiveInterval: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval`
      instead.
  """,
    )
    public val endTime: Output<Int>? = null,
    public val escalationsCritical: Output<AlarmEscalationsCriticalArgs>? = null,
    public val escalationsInfo: Output<AlarmEscalationsInfoArgs>? = null,
    public val escalationsWarn: Output<AlarmEscalationsWarnArgs>? = null,
    public val metric: Output<String>? = null,
    public val metricDimensions: Output<String>? = null,
    public val name: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val project: Output<String>? = null,
    public val prometheuses: Output<List<AlarmPrometheusArgs>>? = null,
    public val silenceTime: Output<Int>? = null,
    @Deprecated(
        message = """
  Field `start_time` has been deprecated from provider version 1.50.0. New field
      `effective_interval` instead.
  """,
    )
    public val startTime: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targets: Output<List<AlarmTargetArgs>>? = null,
    public val webhook: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.AlarmArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.AlarmArgs =
        com.pulumi.alicloud.cms.AlarmArgs.builder()
            .compositeExpression(
                compositeExpression?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .contactGroups(contactGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .effectiveInterval(effectiveInterval?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .escalationsCritical(
                escalationsCritical?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .escalationsInfo(escalationsInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .escalationsWarn(escalationsWarn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metric(metric?.applyValue({ args0 -> args0 }))
            .metricDimensions(metricDimensions?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .prometheuses(
                prometheuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .silenceTime(silenceTime?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .webhook(webhook?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmArgs].
 */
@PulumiTagMarker
public class AlarmArgsBuilder internal constructor() {
    private var compositeExpression: Output<AlarmCompositeExpressionArgs>? = null

    private var contactGroups: Output<List<String>>? = null

    private var dimensions: Output<Map<String, String>>? = null

    private var effectiveInterval: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var endTime: Output<Int>? = null

    private var escalationsCritical: Output<AlarmEscalationsCriticalArgs>? = null

    private var escalationsInfo: Output<AlarmEscalationsInfoArgs>? = null

    private var escalationsWarn: Output<AlarmEscalationsWarnArgs>? = null

    private var metric: Output<String>? = null

    private var metricDimensions: Output<String>? = null

    private var name: Output<String>? = null

    private var period: Output<Int>? = null

    private var project: Output<String>? = null

    private var prometheuses: Output<List<AlarmPrometheusArgs>>? = null

    private var silenceTime: Output<Int>? = null

    private var startTime: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targets: Output<List<AlarmTargetArgs>>? = null

    private var webhook: Output<String>? = null

    /**
     * @param value The trigger conditions for multiple metrics. See `composite_expression` below.
     */
    @JvmName("arwutevrsbuppacf")
    public suspend fun compositeExpression(`value`: Output<AlarmCompositeExpressionArgs>) {
        this.compositeExpression = value
    }

    /**
     * @param value List contact groups of the alarm rule, which must have been created on the console.
     */
    @JvmName("ctbdqnchtvqhrxye")
    public suspend fun contactGroups(`value`: Output<List<String>>) {
        this.contactGroups = value
    }

    @JvmName("begbjypjmygbghen")
    public suspend fun contactGroups(vararg values: Output<String>) {
        this.contactGroups = Output.all(values.asList())
    }

    /**
     * @param values List contact groups of the alarm rule, which must have been created on the console.
     */
    @JvmName("xfkbfeintiqxeffm")
    public suspend fun contactGroups(values: List<Output<String>>) {
        this.contactGroups = Output.all(values)
    }

    /**
     * @param value Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
     */
    @Deprecated(
        message = """
  Field `dimensions` has been deprecated from provider version 1.173.0. New field
      `metric_dimensions` instead.
  """,
    )
    @JvmName("aqxxvxdmugtndjcy")
    public suspend fun dimensions(`value`: Output<Map<String, String>>) {
        this.dimensions = value
    }

    /**
     * @param value The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
     */
    @JvmName("vdxmwayrggipjhiy")
    public suspend fun effectiveInterval(`value`: Output<String>) {
        this.effectiveInterval = value
    }

    /**
     * @param value Whether to enable alarm rule. Default value: `true`.
     */
    @JvmName("rmwmfdiwrcspkkyd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
     */
    @Deprecated(
        message = """
  Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval`
      instead.
  """,
    )
    @JvmName("tbrgpnyvrgrmkhsb")
    public suspend fun endTime(`value`: Output<Int>) {
        this.endTime = value
    }

    /**
     * @param value A configuration of critical alarm. See `escalations_critical` below.
     */
    @JvmName("wfyubhpteuuejcyy")
    public suspend fun escalationsCritical(`value`: Output<AlarmEscalationsCriticalArgs>) {
        this.escalationsCritical = value
    }

    /**
     * @param value A configuration of critical info. See `escalations_info` below.
     */
    @JvmName("lyccxjquivhvilxo")
    public suspend fun escalationsInfo(`value`: Output<AlarmEscalationsInfoArgs>) {
        this.escalationsInfo = value
    }

    /**
     * @param value A configuration of critical warn. See `escalations_warn` below.
     */
    @JvmName("cjaqpikfrvnxnsxa")
    public suspend fun escalationsWarn(`value`: Output<AlarmEscalationsWarnArgs>) {
        this.escalationsWarn = value
    }

    /**
     * @param value The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    @JvmName("queyxpfayxmflisd")
    public suspend fun metric(`value`: Output<String>) {
        this.metric = value
    }

    /**
     * @param value Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    @JvmName("lyavydppoitqybuv")
    public suspend fun metricDimensions(`value`: Output<String>) {
        this.metricDimensions = value
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("phatyuarfjkduqoq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The statistical period of the metric. Unit: seconds. Default value: `300`.
     */
    @JvmName("bsxkejugeuuhvaak")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     * **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
     */
    @JvmName("ckmidowkggeshfxy")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
     */
    @JvmName("sfnmmyhejaqneuvv")
    public suspend fun prometheuses(`value`: Output<List<AlarmPrometheusArgs>>) {
        this.prometheuses = value
    }

    @JvmName("qivkgawwvgeywxvo")
    public suspend fun prometheuses(vararg values: Output<AlarmPrometheusArgs>) {
        this.prometheuses = Output.all(values.asList())
    }

    /**
     * @param values The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
     */
    @JvmName("yifcgvtncidwxtna")
    public suspend fun prometheuses(values: List<Output<AlarmPrometheusArgs>>) {
        this.prometheuses = Output.all(values)
    }

    /**
     * @param value Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
     */
    @JvmName("niuvlmrxxjmrubwh")
    public suspend fun silenceTime(`value`: Output<Int>) {
        this.silenceTime = value
    }

    /**
     * @param value Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
     */
    @Deprecated(
        message = """
  Field `start_time` has been deprecated from provider version 1.50.0. New field
      `effective_interval` instead.
  """,
    )
    @JvmName("ngdelwhlfbowifwj")
    public suspend fun startTime(`value`: Output<Int>) {
        this.startTime = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("yurvjxsnysfvfusu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("ldbedyrbytajjnup")
    public suspend fun targets(`value`: Output<List<AlarmTargetArgs>>) {
        this.targets = value
    }

    @JvmName("hymsllkpqkmqsxie")
    public suspend fun targets(vararg values: Output<AlarmTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("cprnvgqnmqyaehaf")
    public suspend fun targets(values: List<Output<AlarmTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
     */
    @JvmName("pvdeedjfqpapjcaa")
    public suspend fun webhook(`value`: Output<String>) {
        this.webhook = value
    }

    /**
     * @param value The trigger conditions for multiple metrics. See `composite_expression` below.
     */
    @JvmName("wiccdombackoymyp")
    public suspend fun compositeExpression(`value`: AlarmCompositeExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compositeExpression = mapped
    }

    /**
     * @param argument The trigger conditions for multiple metrics. See `composite_expression` below.
     */
    @JvmName("sxhlothrgolisunw")
    public suspend fun compositeExpression(argument: suspend AlarmCompositeExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = AlarmCompositeExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.compositeExpression = mapped
    }

    /**
     * @param value List contact groups of the alarm rule, which must have been created on the console.
     */
    @JvmName("xtbffxudevntsgax")
    public suspend fun contactGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param values List contact groups of the alarm rule, which must have been created on the console.
     */
    @JvmName("chbqvdmwuaoyxeof")
    public suspend fun contactGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param value Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
     */
    @Deprecated(
        message = """
  Field `dimensions` has been deprecated from provider version 1.173.0. New field
      `metric_dimensions` instead.
  """,
    )
    @JvmName("cpbmwoljtbtwlugq")
    public suspend fun dimensions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param values Field `dimensions` has been deprecated from provider version 1.173.0. New field `metric_dimensions` instead.
     */
    @Deprecated(
        message = """
  Field `dimensions` has been deprecated from provider version 1.173.0. New field
      `metric_dimensions` instead.
  """,
    )
    @JvmName("lkuaeuyfcqpfkwhi")
    public fun dimensions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The interval of effecting alarm rule. It format as "hh:mm-hh:mm", like "0:00-4:00". Default value: `00:00-23:59`.
     */
    @JvmName("eefpqpylpilprkqx")
    public suspend fun effectiveInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveInterval = mapped
    }

    /**
     * @param value Whether to enable alarm rule. Default value: `true`.
     */
    @JvmName("nuhncxgdydpwqjkb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
     */
    @Deprecated(
        message = """
  Field `end_time` has been deprecated from provider version 1.50.0. New field `effective_interval`
      instead.
  """,
    )
    @JvmName("ldyirprgwejnonrd")
    public suspend fun endTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value A configuration of critical alarm. See `escalations_critical` below.
     */
    @JvmName("qljeaqawfcwveidw")
    public suspend fun escalationsCritical(`value`: AlarmEscalationsCriticalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.escalationsCritical = mapped
    }

    /**
     * @param argument A configuration of critical alarm. See `escalations_critical` below.
     */
    @JvmName("swxaveeddooaqfyk")
    public suspend fun escalationsCritical(argument: suspend AlarmEscalationsCriticalArgsBuilder.() -> Unit) {
        val toBeMapped = AlarmEscalationsCriticalArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.escalationsCritical = mapped
    }

    /**
     * @param value A configuration of critical info. See `escalations_info` below.
     */
    @JvmName("sfudklqditrgyxpp")
    public suspend fun escalationsInfo(`value`: AlarmEscalationsInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.escalationsInfo = mapped
    }

    /**
     * @param argument A configuration of critical info. See `escalations_info` below.
     */
    @JvmName("tcdnfnafqbpskskf")
    public suspend fun escalationsInfo(argument: suspend AlarmEscalationsInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AlarmEscalationsInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.escalationsInfo = mapped
    }

    /**
     * @param value A configuration of critical warn. See `escalations_warn` below.
     */
    @JvmName("yvqhrqglaqxkpjwk")
    public suspend fun escalationsWarn(`value`: AlarmEscalationsWarnArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.escalationsWarn = mapped
    }

    /**
     * @param argument A configuration of critical warn. See `escalations_warn` below.
     */
    @JvmName("jmaoftqprgsjttwd")
    public suspend fun escalationsWarn(argument: suspend AlarmEscalationsWarnArgsBuilder.() -> Unit) {
        val toBeMapped = AlarmEscalationsWarnArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.escalationsWarn = mapped
    }

    /**
     * @param value The name of the metric, such as `CPUUtilization` and `networkin_rate`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    @JvmName("xqphirgrvdmyhcou")
    public suspend fun metric(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param value Map of the resources associated with the alarm rule, such as "instanceId", "device" and "port". Each key's value is a string, and it uses comma to split multiple items. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    @JvmName("nushwggvsnbifkhx")
    public suspend fun metricDimensions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricDimensions = mapped
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("usykjyvshjibexmf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The statistical period of the metric. Unit: seconds. Default value: `300`.
     */
    @JvmName("sogdxwkjhuoqeuii")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The namespace of the cloud service, such as `acs_ecs_dashboard` and `acs_rds_dashboard`. For more information, see [Metrics Reference](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     * **NOTE:** The `dimensions` and `metric_dimensions` must be empty when `project` is `acs_prometheus`, otherwise, one of them must be set.
     */
    @JvmName("badntmywwkjiivke")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
     */
    @JvmName("rvijoqqrifqtpgdq")
    public suspend fun prometheuses(`value`: List<AlarmPrometheusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheuses = mapped
    }

    /**
     * @param argument The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
     */
    @JvmName("leejwcjgidneknka")
    public suspend fun prometheuses(argument: List<suspend AlarmPrometheusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlarmPrometheusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.prometheuses = mapped
    }

    /**
     * @param argument The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
     */
    @JvmName("xrejofogrgcsbfin")
    public suspend fun prometheuses(vararg argument: suspend AlarmPrometheusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlarmPrometheusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.prometheuses = mapped
    }

    /**
     * @param argument The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
     */
    @JvmName("ilhqcihwgtnisclv")
    public suspend fun prometheuses(argument: suspend AlarmPrometheusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlarmPrometheusArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.prometheuses = mapped
    }

    /**
     * @param values The Prometheus alert rule. See `prometheus` below. **Note:** This parameter is required only when you create a Prometheus alert rule for Hybrid Cloud Monitoring.
     */
    @JvmName("xgtpwhkfmxwlbcqc")
    public suspend fun prometheuses(vararg values: AlarmPrometheusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prometheuses = mapped
    }

    /**
     * @param value Notification silence period in the alarm state, in seconds. Default value: `86400`. Valid value range: [300, 86400].
     */
    @JvmName("avviycgaigbuthpx")
    public suspend fun silenceTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.silenceTime = mapped
    }

    /**
     * @param value Field `start_time` has been deprecated from provider version 1.50.0. New field `effective_interval` instead.
     */
    @Deprecated(
        message = """
  Field `start_time` has been deprecated from provider version 1.50.0. New field
      `effective_interval` instead.
  """,
    )
    @JvmName("xyuxktcugwcwkmtk")
    public suspend fun startTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("bkvdtaqgxrecbyhy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("idxcocmcfticysgn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("brypemrnawpdiapb")
    public suspend fun targets(`value`: List<AlarmTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("tourselpxscgdyti")
    public suspend fun targets(argument: List<suspend AlarmTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AlarmTargetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("jyrawgohrablfiti")
    public suspend fun targets(vararg argument: suspend AlarmTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AlarmTargetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("ouytpgaxafdmrjkw")
    public suspend fun targets(argument: suspend AlarmTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlarmTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("qytkiqnibybfhlkj")
    public suspend fun targets(vararg values: AlarmTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param value The webhook that should be called when the alarm is triggered. Currently, only http protocol is supported. Default is empty string.
     */
    @JvmName("myyhdalfmoqcdayt")
    public suspend fun webhook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhook = mapped
    }

    internal fun build(): AlarmArgs = AlarmArgs(
        compositeExpression = compositeExpression,
        contactGroups = contactGroups,
        dimensions = dimensions,
        effectiveInterval = effectiveInterval,
        enabled = enabled,
        endTime = endTime,
        escalationsCritical = escalationsCritical,
        escalationsInfo = escalationsInfo,
        escalationsWarn = escalationsWarn,
        metric = metric,
        metricDimensions = metricDimensions,
        name = name,
        period = period,
        project = project,
        prometheuses = prometheuses,
        silenceTime = silenceTime,
        startTime = startTime,
        tags = tags,
        targets = targets,
        webhook = webhook,
    )
}
