@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlarmContact].
 */
@PulumiTagMarker
public class AlarmContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlarmContactArgs = AlarmContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlarmContactArgsBuilder.() -> Unit) {
        val builder = AlarmContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlarmContact {
        val builtJavaResource = com.pulumi.alicloud.cms.AlarmContact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlarmContact(builtJavaResource)
    }
}

/**
 * Creates or modifies an alarm contact. For information about alarm contact and how to use it, see [What is alarm contact](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putcontact).
 * > **NOTE:** Available since v1.99.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 * const example = new alicloud.cms.AlarmContact("example", {
 *     alarmContactName: "tf-example",
 *     describe: "For example",
 *     channelsMail: "terraform@test.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 * example = alicloud.cms.AlarmContact("example",
 *     alarm_contact_name="tf-example",
 *     describe="For example",
 *     channels_mail="terraform@test.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 *     var example = new AliCloud.Cms.AlarmContact("example", new()
 *     {
 *         AlarmContactName = "tf-example",
 *         Describe = "For example",
 *         ChannelsMail = "terraform@test.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 * 		_, err := cms.NewAlarmContact(ctx, "example", &cms.AlarmContactArgs{
 * 			AlarmContactName: pulumi.String("tf-example"),
 * 			Describe:         pulumi.String("For example"),
 * 			ChannelsMail:     pulumi.String("terraform@test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContact;
 * import com.pulumi.alicloud.cms.AlarmContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 *         var example = new AlarmContact("example", AlarmContactArgs.builder()
 *             .alarmContactName("tf-example")
 *             .describe("For example")
 *             .channelsMail("terraform@test.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 *   example:
 *     type: alicloud:cms:AlarmContact
 *     properties:
 *       alarmContactName: tf-example
 *       describe: For example
 *       channelsMail: terraform@test.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alarm contact can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/alarmContact:AlarmContact example abc12345
 * ```
 */
public class AlarmContact internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.AlarmContact,
) : KotlinCustomResource(javaResource, AlarmContactMapper) {
    /**
     * The name of the alarm contact. The length should between 2 and 40 characters.
     */
    public val alarmContactName: Output<String>
        get() = javaResource.alarmContactName().applyValue({ args0 -> args0 })

    /**
     * The TradeManager ID of the alarm contact.
     */
    public val channelsAliim: Output<String>?
        get() = javaResource.channelsAliim().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The webhook URL of the DingTalk chatbot.
     */
    public val channelsDingWebHook: Output<String>?
        get() = javaResource.channelsDingWebHook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
     */
    public val channelsMail: Output<String>?
        get() = javaResource.channelsMail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
     */
    public val channelsSms: Output<String>?
        get() = javaResource.channelsSms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the alarm contact.
     */
    public val describe: Output<String>
        get() = javaResource.describe().applyValue({ args0 -> args0 })

    /**
     * The language type of the alarm. Valid values: `en`, `zh-cn`.
     * > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AlarmContactMapper : ResourceMapper<AlarmContact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.AlarmContact::class == javaResource::class

    override fun map(javaResource: Resource): AlarmContact = AlarmContact(
        javaResource as
            com.pulumi.alicloud.cms.AlarmContact,
    )
}

/**
 * @see [AlarmContact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlarmContact].
 */
public suspend fun alarmContact(
    name: String,
    block: suspend AlarmContactResourceBuilder.() -> Unit,
): AlarmContact {
    val builder = AlarmContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlarmContact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alarmContact(name: String): AlarmContact {
    val builder = AlarmContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
