@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.AlarmContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates or modifies an alarm contact. For information about alarm contact and how to use it, see [What is alarm contact](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putcontact).
 * > **NOTE:** Available since v1.99.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 * const example = new alicloud.cms.AlarmContact("example", {
 *     alarmContactName: "tf-example",
 *     describe: "For example",
 *     channelsMail: "terraform@test.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 * example = alicloud.cms.AlarmContact("example",
 *     alarm_contact_name="tf-example",
 *     describe="For example",
 *     channels_mail="terraform@test.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 *     var example = new AliCloud.Cms.AlarmContact("example", new()
 *     {
 *         AlarmContactName = "tf-example",
 *         Describe = "For example",
 *         ChannelsMail = "terraform@test.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 * 		_, err := cms.NewAlarmContact(ctx, "example", &cms.AlarmContactArgs{
 * 			AlarmContactName: pulumi.String("tf-example"),
 * 			Describe:         pulumi.String("For example"),
 * 			ChannelsMail:     pulumi.String("terraform@test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContact;
 * import com.pulumi.alicloud.cms.AlarmContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 *         var example = new AlarmContact("example", AlarmContactArgs.builder()
 *             .alarmContactName("tf-example")
 *             .describe("For example")
 *             .channelsMail("terraform@test.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # You need to activate the link before you can return to the alarm contact information, otherwise diff will appear in terraform. So please confirm the activation link as soon as possible. Besides, you can ignore the diff of the alarm contact information by `lifestyle`.
 *   example:
 *     type: alicloud:cms:AlarmContact
 *     properties:
 *       alarmContactName: tf-example
 *       describe: For example
 *       channelsMail: terraform@test.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alarm contact can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/alarmContact:AlarmContact example abc12345
 * ```
 * @property alarmContactName The name of the alarm contact. The length should between 2 and 40 characters.
 * @property channelsAliim The TradeManager ID of the alarm contact.
 * @property channelsDingWebHook The webhook URL of the DingTalk chatbot.
 * @property channelsMail The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
 * @property channelsSms The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
 * @property describe The description of the alarm contact.
 * @property lang The language type of the alarm. Valid values: `en`, `zh-cn`.
 * > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
 */
public data class AlarmContactArgs(
    public val alarmContactName: Output<String>? = null,
    public val channelsAliim: Output<String>? = null,
    public val channelsDingWebHook: Output<String>? = null,
    public val channelsMail: Output<String>? = null,
    public val channelsSms: Output<String>? = null,
    public val describe: Output<String>? = null,
    public val lang: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.AlarmContactArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.AlarmContactArgs =
        com.pulumi.alicloud.cms.AlarmContactArgs.builder()
            .alarmContactName(alarmContactName?.applyValue({ args0 -> args0 }))
            .channelsAliim(channelsAliim?.applyValue({ args0 -> args0 }))
            .channelsDingWebHook(channelsDingWebHook?.applyValue({ args0 -> args0 }))
            .channelsMail(channelsMail?.applyValue({ args0 -> args0 }))
            .channelsSms(channelsSms?.applyValue({ args0 -> args0 }))
            .describe(describe?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmContactArgs].
 */
@PulumiTagMarker
public class AlarmContactArgsBuilder internal constructor() {
    private var alarmContactName: Output<String>? = null

    private var channelsAliim: Output<String>? = null

    private var channelsDingWebHook: Output<String>? = null

    private var channelsMail: Output<String>? = null

    private var channelsSms: Output<String>? = null

    private var describe: Output<String>? = null

    private var lang: Output<String>? = null

    /**
     * @param value The name of the alarm contact. The length should between 2 and 40 characters.
     */
    @JvmName("pijmydelabxeyssk")
    public suspend fun alarmContactName(`value`: Output<String>) {
        this.alarmContactName = value
    }

    /**
     * @param value The TradeManager ID of the alarm contact.
     */
    @JvmName("proikuljqeeqwyis")
    public suspend fun channelsAliim(`value`: Output<String>) {
        this.channelsAliim = value
    }

    /**
     * @param value The webhook URL of the DingTalk chatbot.
     */
    @JvmName("yipwdfbmxkoyekyo")
    public suspend fun channelsDingWebHook(`value`: Output<String>) {
        this.channelsDingWebHook = value
    }

    /**
     * @param value The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
     */
    @JvmName("swplkjafhvmqynul")
    public suspend fun channelsMail(`value`: Output<String>) {
        this.channelsMail = value
    }

    /**
     * @param value The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
     */
    @JvmName("uuhblrncnjpccghd")
    public suspend fun channelsSms(`value`: Output<String>) {
        this.channelsSms = value
    }

    /**
     * @param value The description of the alarm contact.
     */
    @JvmName("ebaqqajrcmvjhnuu")
    public suspend fun describe(`value`: Output<String>) {
        this.describe = value
    }

    /**
     * @param value The language type of the alarm. Valid values: `en`, `zh-cn`.
     * > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
     */
    @JvmName("ogyvicelwfgrrkrf")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The name of the alarm contact. The length should between 2 and 40 characters.
     */
    @JvmName("eyqnngpsdnpjvoyl")
    public suspend fun alarmContactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmContactName = mapped
    }

    /**
     * @param value The TradeManager ID of the alarm contact.
     */
    @JvmName("ejmandaypokrabgl")
    public suspend fun channelsAliim(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelsAliim = mapped
    }

    /**
     * @param value The webhook URL of the DingTalk chatbot.
     */
    @JvmName("gpufpvgvkpxhfkwa")
    public suspend fun channelsDingWebHook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelsDingWebHook = mapped
    }

    /**
     * @param value The email address of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
     */
    @JvmName("runvyqwmsduxvpox")
    public suspend fun channelsMail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelsMail = mapped
    }

    /**
     * @param value The phone number of the alarm contact. After you add or modify an email address, the recipient receives an email that contains an activation link. The system adds the recipient to the list of alarm contacts only after the recipient activates the email address.
     */
    @JvmName("ewktodvrrogaglpf")
    public suspend fun channelsSms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelsSms = mapped
    }

    /**
     * @param value The description of the alarm contact.
     */
    @JvmName("berymqnuwmwwnjtf")
    public suspend fun describe(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.describe = mapped
    }

    /**
     * @param value The language type of the alarm. Valid values: `en`, `zh-cn`.
     * > **NOTE:** Specify at least one of the following alarm notification targets: `channels_aliim`, `channels_ding_web_hook`, `channels_mail`, `channels_sms`.
     */
    @JvmName("ebsfxhmdftlfpgpu")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    internal fun build(): AlarmContactArgs = AlarmContactArgs(
        alarmContactName = alarmContactName,
        channelsAliim = channelsAliim,
        channelsDingWebHook = channelsDingWebHook,
        channelsMail = channelsMail,
        channelsSms = channelsSms,
        describe = describe,
        lang = lang,
    )
}
