@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AlarmContactGroup].
 */
@PulumiTagMarker
public class AlarmContactGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlarmContactGroupArgs = AlarmContactGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlarmContactGroupArgsBuilder.() -> Unit) {
        val builder = AlarmContactGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlarmContactGroup {
        val builtJavaResource = com.pulumi.alicloud.cms.AlarmContactGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlarmContactGroup(builtJavaResource)
    }
}

/**
 * Provides a CMS Alarm Contact Group resource.
 * For information about CMS Alarm Contact Group and how to use it, see [What is Alarm Contact Group](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putcontactgroup).
 * > **NOTE:** Available since v1.101.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cms.AlarmContactGroup("example", {alarmContactGroupName: "tf-example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cms.AlarmContactGroup("example", alarm_contact_group_name="tf-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cms.AlarmContactGroup("example", new()
 *     {
 *         AlarmContactGroupName = "tf-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cms.NewAlarmContactGroup(ctx, "example", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AlarmContactGroup("example", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName("tf-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cms:AlarmContactGroup
 *     properties:
 *       alarmContactGroupName: tf-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CMS Alarm Contact Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/alarmContactGroup:AlarmContactGroup example tf-testacc123
 * ```
 */
public class AlarmContactGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.AlarmContactGroup,
) : KotlinCustomResource(javaResource, AlarmContactGroupMapper) {
    /**
     * The name of the alarm group.
     */
    public val alarmContactGroupName: Output<String>
        get() = javaResource.alarmContactGroupName().applyValue({ args0 -> args0 })

    /**
     * The name of the alert contact.
     */
    public val contacts: Output<List<String>>?
        get() = javaResource.contacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The description of the alert group.
     */
    public val describe: Output<String>?
        get() = javaResource.describe().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to open weekly subscription.
     */
    public val enableSubscribed: Output<Boolean>
        get() = javaResource.enableSubscribed().applyValue({ args0 -> args0 })
}

public object AlarmContactGroupMapper : ResourceMapper<AlarmContactGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.AlarmContactGroup::class == javaResource::class

    override fun map(javaResource: Resource): AlarmContactGroup = AlarmContactGroup(
        javaResource as
            com.pulumi.alicloud.cms.AlarmContactGroup,
    )
}

/**
 * @see [AlarmContactGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlarmContactGroup].
 */
public suspend fun alarmContactGroup(
    name: String,
    block: suspend AlarmContactGroupResourceBuilder.() -> Unit,
): AlarmContactGroup {
    val builder = AlarmContactGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlarmContactGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alarmContactGroup(name: String): AlarmContactGroup {
    val builder = AlarmContactGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
