@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.AlarmContactGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CMS Alarm Contact Group resource.
 * For information about CMS Alarm Contact Group and how to use it, see [What is Alarm Contact Group](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putcontactgroup).
 * > **NOTE:** Available since v1.101.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cms.AlarmContactGroup("example", {alarmContactGroupName: "tf-example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cms.AlarmContactGroup("example", alarm_contact_group_name="tf-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cms.AlarmContactGroup("example", new()
 *     {
 *         AlarmContactGroupName = "tf-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cms.NewAlarmContactGroup(ctx, "example", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AlarmContactGroup("example", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName("tf-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cms:AlarmContactGroup
 *     properties:
 *       alarmContactGroupName: tf-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CMS Alarm Contact Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/alarmContactGroup:AlarmContactGroup example tf-testacc123
 * ```
 * @property alarmContactGroupName The name of the alarm group.
 * @property contacts The name of the alert contact.
 * @property describe The description of the alert group.
 * @property enableSubscribed Whether to open weekly subscription.
 */
public data class AlarmContactGroupArgs(
    public val alarmContactGroupName: Output<String>? = null,
    public val contacts: Output<List<String>>? = null,
    public val describe: Output<String>? = null,
    public val enableSubscribed: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.AlarmContactGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.AlarmContactGroupArgs =
        com.pulumi.alicloud.cms.AlarmContactGroupArgs.builder()
            .alarmContactGroupName(alarmContactGroupName?.applyValue({ args0 -> args0 }))
            .contacts(contacts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .describe(describe?.applyValue({ args0 -> args0 }))
            .enableSubscribed(enableSubscribed?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmContactGroupArgs].
 */
@PulumiTagMarker
public class AlarmContactGroupArgsBuilder internal constructor() {
    private var alarmContactGroupName: Output<String>? = null

    private var contacts: Output<List<String>>? = null

    private var describe: Output<String>? = null

    private var enableSubscribed: Output<Boolean>? = null

    /**
     * @param value The name of the alarm group.
     */
    @JvmName("bxsmwmoyargdwbox")
    public suspend fun alarmContactGroupName(`value`: Output<String>) {
        this.alarmContactGroupName = value
    }

    /**
     * @param value The name of the alert contact.
     */
    @JvmName("hfjlhgavcrqosnji")
    public suspend fun contacts(`value`: Output<List<String>>) {
        this.contacts = value
    }

    @JvmName("gskgmhioiowhcnkm")
    public suspend fun contacts(vararg values: Output<String>) {
        this.contacts = Output.all(values.asList())
    }

    /**
     * @param values The name of the alert contact.
     */
    @JvmName("shaqvughglcmpgsa")
    public suspend fun contacts(values: List<Output<String>>) {
        this.contacts = Output.all(values)
    }

    /**
     * @param value The description of the alert group.
     */
    @JvmName("rktyghnfpikhvivo")
    public suspend fun describe(`value`: Output<String>) {
        this.describe = value
    }

    /**
     * @param value Whether to open weekly subscription.
     */
    @JvmName("nnuarrxvysaukwft")
    public suspend fun enableSubscribed(`value`: Output<Boolean>) {
        this.enableSubscribed = value
    }

    /**
     * @param value The name of the alarm group.
     */
    @JvmName("jpbhgsejsxyljdlk")
    public suspend fun alarmContactGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmContactGroupName = mapped
    }

    /**
     * @param value The name of the alert contact.
     */
    @JvmName("mlipjnrjvoqqytdr")
    public suspend fun contacts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contacts = mapped
    }

    /**
     * @param values The name of the alert contact.
     */
    @JvmName("pcoxxcmreldixoes")
    public suspend fun contacts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contacts = mapped
    }

    /**
     * @param value The description of the alert group.
     */
    @JvmName("xjovixvpxvfdbiow")
    public suspend fun describe(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.describe = mapped
    }

    /**
     * @param value Whether to open weekly subscription.
     */
    @JvmName("ehdphhartoqidcyh")
    public suspend fun enableSubscribed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSubscribed = mapped
    }

    internal fun build(): AlarmContactGroupArgs = AlarmContactGroupArgs(
        alarmContactGroupName = alarmContactGroupName,
        contacts = contacts,
        describe = describe,
        enableSubscribed = enableSubscribed,
    )
}
