@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.CmsFunctions.getAlarmContactGroupsPlain
import com.pulumi.alicloud.cms.CmsFunctions.getAlarmContactsPlain
import com.pulumi.alicloud.cms.CmsFunctions.getDynamicTagGroupsPlain
import com.pulumi.alicloud.cms.CmsFunctions.getEventRulesPlain
import com.pulumi.alicloud.cms.CmsFunctions.getGroupMetricRulesPlain
import com.pulumi.alicloud.cms.CmsFunctions.getHybridMonitorDatasPlain
import com.pulumi.alicloud.cms.CmsFunctions.getHybridMonitorFcTasksPlain
import com.pulumi.alicloud.cms.CmsFunctions.getHybridMonitorSlsTasksPlain
import com.pulumi.alicloud.cms.CmsFunctions.getMetricRuleBlackListsPlain
import com.pulumi.alicloud.cms.CmsFunctions.getMetricRuleTemplatesPlain
import com.pulumi.alicloud.cms.CmsFunctions.getMonitorGroupInstancesPlain
import com.pulumi.alicloud.cms.CmsFunctions.getMonitorGroupsPlain
import com.pulumi.alicloud.cms.CmsFunctions.getNamespacesPlain
import com.pulumi.alicloud.cms.CmsFunctions.getServicePlain
import com.pulumi.alicloud.cms.CmsFunctions.getSiteMonitorsPlain
import com.pulumi.alicloud.cms.CmsFunctions.getSlsGroupsPlain
import com.pulumi.alicloud.cms.kotlin.inputs.GetAlarmContactGroupsPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetAlarmContactGroupsPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetAlarmContactsPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetAlarmContactsPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetDynamicTagGroupsPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetDynamicTagGroupsPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetEventRulesPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetEventRulesPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetGroupMetricRulesPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetGroupMetricRulesPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetHybridMonitorDatasPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetHybridMonitorDatasPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetHybridMonitorFcTasksPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetHybridMonitorFcTasksPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetHybridMonitorSlsTasksPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetHybridMonitorSlsTasksPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetMetricRuleBlackListsPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetMetricRuleBlackListsPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetMetricRuleTemplatesPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetMetricRuleTemplatesPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetMonitorGroupInstancesPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetMonitorGroupInstancesPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetMonitorGroupsPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetMonitorGroupsPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetNamespacesPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetNamespacesPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetSiteMonitorsPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetSiteMonitorsPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GetSlsGroupsPlainArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GetSlsGroupsPlainArgsBuilder
import com.pulumi.alicloud.cms.kotlin.outputs.GetAlarmContactGroupsResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetAlarmContactsResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetDynamicTagGroupsResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetEventRulesResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetGroupMetricRulesResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorDatasResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorFcTasksResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleBlackListsResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleTemplatesResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetMonitorGroupInstancesResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetMonitorGroupsResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetNamespacesResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetSiteMonitorsResult
import com.pulumi.alicloud.cms.kotlin.outputs.GetSlsGroupsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cms.kotlin.outputs.GetAlarmContactGroupsResult.Companion.toKotlin as getAlarmContactGroupsResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetAlarmContactsResult.Companion.toKotlin as getAlarmContactsResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetDynamicTagGroupsResult.Companion.toKotlin as getDynamicTagGroupsResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetEventRulesResult.Companion.toKotlin as getEventRulesResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetGroupMetricRulesResult.Companion.toKotlin as getGroupMetricRulesResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorDatasResult.Companion.toKotlin as getHybridMonitorDatasResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorFcTasksResult.Companion.toKotlin as getHybridMonitorFcTasksResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksResult.Companion.toKotlin as getHybridMonitorSlsTasksResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleBlackListsResult.Companion.toKotlin as getMetricRuleBlackListsResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleTemplatesResult.Companion.toKotlin as getMetricRuleTemplatesResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetMonitorGroupInstancesResult.Companion.toKotlin as getMonitorGroupInstancesResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetMonitorGroupsResult.Companion.toKotlin as getMonitorGroupsResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetNamespacesResult.Companion.toKotlin as getNamespacesResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetSiteMonitorsResult.Companion.toKotlin as getSiteMonitorsResultToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GetSlsGroupsResult.Companion.toKotlin as getSlsGroupsResultToKotlin

public object CmsFunctions {
    /**
     * This data source provides the CMS Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.101.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cms.getAlarmContactGroups({
     *     nameRegex: "tf-testacc",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cms.get_alarm_contact_groups(name_regex="tf-testacc")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cms.GetAlarmContactGroups.Invoke(new()
     *     {
     *         NameRegex = "tf-testacc",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cms.GetAlarmContactGroups(ctx, &cms.GetAlarmContactGroupsArgs{
     * 			NameRegex: pulumi.StringRef("tf-testacc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetAlarmContactGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CmsFunctions.getAlarmContactGroups(GetAlarmContactGroupsArgs.builder()
     *             .nameRegex("tf-testacc")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cms:getAlarmContactGroups
     *       Arguments:
     *         nameRegex: tf-testacc
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlarmContactGroups.
     * @return A collection of values returned by getAlarmContactGroups.
     */
    public suspend fun getAlarmContactGroups(argument: GetAlarmContactGroupsPlainArgs): GetAlarmContactGroupsResult =
        getAlarmContactGroupsResultToKotlin(getAlarmContactGroupsPlain(argument.toJava()).await())

    /**
     * @see [getAlarmContactGroups].
     * @param ids A list of Alarm Contact Group IDs.
     * @param nameRegex A regex string to filter results by Alarm Contact Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAlarmContactGroups.
     */
    public suspend fun getAlarmContactGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAlarmContactGroupsResult {
        val argument = GetAlarmContactGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAlarmContactGroupsResultToKotlin(getAlarmContactGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlarmContactGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetAlarmContactGroupsPlainArgs].
     * @return A collection of values returned by getAlarmContactGroups.
     */
    public suspend fun getAlarmContactGroups(argument: suspend GetAlarmContactGroupsPlainArgsBuilder.() -> Unit): GetAlarmContactGroupsResult {
        val builder = GetAlarmContactGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlarmContactGroupsResultToKotlin(getAlarmContactGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a list of alarm contact owned by an Alibaba Cloud account.
     * > **NOTE:** Available in v1.99.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * export = async () => {
     *     const example = await alicloud.cms.getAlarmContacts({
     *         ids: ["tf-testAccCmsAlarmContact"],
     *     });
     *     return {
     *         "first-contact": _this.contacts,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cms.get_alarm_contacts(ids=["tf-testAccCmsAlarmContact"])
     * pulumi.export("first-contact", this["contacts"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cms.GetAlarmContacts.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "tf-testAccCmsAlarmContact",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["first-contact"] = @this.Contacts,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cms.GetAlarmContacts(ctx, &cms.GetAlarmContactsArgs{
     * 			Ids: []string{
     * 				"tf-testAccCmsAlarmContact",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("first-contact", this.Contacts)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetAlarmContactsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CmsFunctions.getAlarmContacts(GetAlarmContactsArgs.builder()
     *             .ids("tf-testAccCmsAlarmContact")
     *             .build());
     *         ctx.export("first-contact", this_.contacts());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cms:getAlarmContacts
     *       Arguments:
     *         ids:
     *           - tf-testAccCmsAlarmContact
     * outputs:
     *   first-contact: ${this.contacts}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlarmContacts.
     * @return A collection of values returned by getAlarmContacts.
     */
    public suspend fun getAlarmContacts(argument: GetAlarmContactsPlainArgs): GetAlarmContactsResult =
        getAlarmContactsResultToKotlin(getAlarmContactsPlain(argument.toJava()).await())

    /**
     * @see [getAlarmContacts].
     * @param chanelType The alarm notification method. Alarm notifications can be sent by using `Email` or `DingWebHook`.
     * @param chanelValue The alarm notification target.
     * @param ids A list of alarm contact IDs.
     * @param nameRegex A regex string to filter results by alarm contact name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * > **NOTE:** Specify at least one of the following alarm notification targets: phone number, email address, webhook URL of the DingTalk chatbot, and TradeManager ID.
     * @return A collection of values returned by getAlarmContacts.
     */
    public suspend fun getAlarmContacts(
        chanelType: String? = null,
        chanelValue: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAlarmContactsResult {
        val argument = GetAlarmContactsPlainArgs(
            chanelType = chanelType,
            chanelValue = chanelValue,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAlarmContactsResultToKotlin(getAlarmContactsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlarmContacts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetAlarmContactsPlainArgs].
     * @return A collection of values returned by getAlarmContacts.
     */
    public suspend fun getAlarmContacts(argument: suspend GetAlarmContactsPlainArgsBuilder.() -> Unit): GetAlarmContactsResult {
        val builder = GetAlarmContactsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlarmContactsResultToKotlin(getAlarmContactsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Dynamic Tag Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "example_value";
     * const _default = new alicloud.cms.AlarmContactGroup("default", {
     *     alarmContactGroupName: name,
     *     describe: "example_value",
     *     enableSubscribed: true,
     * });
     * const defaultDynamicTagGroup = new alicloud.cms.DynamicTagGroup("default", {
     *     contactGroupLists: [_default&#46;id],
     *     tagKey: "your_tag_key",
     *     matchExpresses: [{
     *         tagValue: "your_tag_value",
     *         tagValueMatchFunction: "all",
     *     }],
     * });
     * const ids = alicloud.cms.getDynamicTagGroupsOutput({
     *     ids: [defaultDynamicTagGroup&#46;id],
     * });
     * export const cmsDynamicTagGroupId1 = ids.apply(ids => ids.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "example_value"
     * default = alicloud.cms.AlarmContactGroup("default",
     *     alarm_contact_group_name=name,
     *     describe="example_value",
     *     enable_subscribed=True)
     * default_dynamic_tag_group = alicloud.cms.DynamicTagGroup("default",
     *     contact_group_lists=[default&#46;id],
     *     tag_key="your_tag_key",
     *     match_expresses=[{
     *         "tag_value": "your_tag_value",
     *         "tag_value_match_function": "all",
     *     }])
     * ids = alicloud.cms.get_dynamic_tag_groups_output(ids=[default_dynamic_tag_group&#46;id])
     * pulumi.export("cmsDynamicTagGroupId1", ids.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "example_value";
     *     var @default = new AliCloud.Cms.AlarmContactGroup("default", new()
     *     {
     *         AlarmContactGroupName = name,
     *         Describe = "example_value",
     *         EnableSubscribed = true,
     *     });
     *     var defaultDynamicTagGroup = new AliCloud.Cms.DynamicTagGroup("default", new()
     *     {
     *         ContactGroupLists = new[]
     *         {
     *             @default.Id,
     *         },
     *         TagKey = "your_tag_key",
     *         MatchExpresses = new[]
     *         {
     *             new AliCloud.Cms.Inputs.DynamicTagGroupMatchExpressArgs
     *             {
     *                 TagValue = "your_tag_value",
     *                 TagValueMatchFunction = "all",
     *             },
     *         },
     *     });
     *     var ids = AliCloud.Cms.GetDynamicTagGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultDynamicTagGroup.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cmsDynamicTagGroupId1"] = ids&#46;Apply(getDynamicTagGroupsResult => getDynamicTagGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "example_value"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
     * 			AlarmContactGroupName: pulumi.String(name),
     * 			Describe:              pulumi.String("example_value"),
     * 			EnableSubscribed:      pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultDynamicTagGroup, err := cms.NewDynamicTagGroup(ctx, "default", &cms.DynamicTagGroupArgs{
     * 			ContactGroupLists: pulumi.StringArray{
     * 				_default.ID(),
     * 			},
     * 			TagKey: pulumi.String("your_tag_key"),
     * 			MatchExpresses: cms.DynamicTagGroupMatchExpressArray{
     * 				&cms.DynamicTagGroupMatchExpressArgs{
     * 					TagValue:              pulumi.String("your_tag_value"),
     * 					TagValueMatchFunction: pulumi.String("all"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := cms.GetDynamicTagGroupsOutput(ctx, cms.GetDynamicTagGroupsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultDynamicTagGroup.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("cmsDynamicTagGroupId1", ids.ApplyT(func(ids cms.GetDynamicTagGroupsResult) (*string, error) {
     * 			return &ids.Groups[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.AlarmContactGroup;
     * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
     * import com.pulumi.alicloud.cms.DynamicTagGroup;
     * import com.pulumi.alicloud.cms.DynamicTagGroupArgs;
     * import com.pulumi.alicloud.cms.inputs.DynamicTagGroupMatchExpressArgs;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetDynamicTagGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("example_value");
     *         var default_ = new AlarmContactGroup("default", AlarmContactGroupArgs.builder()
     *             .alarmContactGroupName(name)
     *             .describe("example_value")
     *             .enableSubscribed(true)
     *             .build());
     *         var defaultDynamicTagGroup = new DynamicTagGroup("defaultDynamicTagGroup", DynamicTagGroupArgs.builder()
     *             .contactGroupLists(default_.id())
     *             .tagKey("your_tag_key")
     *             .matchExpresses(DynamicTagGroupMatchExpressArgs.builder()
     *                 .tagValue("your_tag_value")
     *                 .tagValueMatchFunction("all")
     *                 .build())
     *             .build());
     *         final var ids = CmsFunctions.getDynamicTagGroups(GetDynamicTagGroupsArgs.builder()
     *             .ids(defaultDynamicTagGroup.id())
     *             .build());
     *         ctx.export("cmsDynamicTagGroupId1", ids.applyValue(getDynamicTagGroupsResult -> getDynamicTagGroupsResult).applyValue(ids -> ids.applyValue(getDynamicTagGroupsResult -> getDynamicTagGroupsResult.groups()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: example_value
     * resources:
     *   default:
     *     type: alicloud:cms:AlarmContactGroup
     *     properties:
     *       alarmContactGroupName: ${name}
     *       describe: example_value
     *       enableSubscribed: true
     *   defaultDynamicTagGroup:
     *     type: alicloud:cms:DynamicTagGroup
     *     name: default
     *     properties:
     *       contactGroupLists:
     *         - ${default.id}
     *       tagKey: your_tag_key
     *       matchExpresses:
     *         - tagValue: your_tag_value
     *           tagValueMatchFunction: all
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cms:getDynamicTagGroups
     *       Arguments:
     *         ids:
     *           - ${defaultDynamicTagGroup.id}
     * outputs:
     *   cmsDynamicTagGroupId1: ${ids.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDynamicTagGroups.
     * @return A collection of values returned by getDynamicTagGroups.
     */
    public suspend fun getDynamicTagGroups(argument: GetDynamicTagGroupsPlainArgs): GetDynamicTagGroupsResult =
        getDynamicTagGroupsResultToKotlin(getDynamicTagGroupsPlain(argument.toJava()).await())

    /**
     * @see [getDynamicTagGroups].
     * @param ids A list of Dynamic Tag Group IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `RUNNING`, `FINISH`.
     * @param tagKey The tag key of the tag.
     * @return A collection of values returned by getDynamicTagGroups.
     */
    public suspend fun getDynamicTagGroups(
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        tagKey: String? = null,
    ): GetDynamicTagGroupsResult {
        val argument = GetDynamicTagGroupsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
            tagKey = tagKey,
        )
        return getDynamicTagGroupsResultToKotlin(getDynamicTagGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDynamicTagGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetDynamicTagGroupsPlainArgs].
     * @return A collection of values returned by getDynamicTagGroups.
     */
    public suspend fun getDynamicTagGroups(argument: suspend GetDynamicTagGroupsPlainArgsBuilder.() -> Unit): GetDynamicTagGroupsResult {
        val builder = GetDynamicTagGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDynamicTagGroupsResultToKotlin(getDynamicTagGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Event Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.182.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cms.getEventRules({
     *     ids: ["example_id"],
     * });
     * export const cmsEventRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * const nameRegex = alicloud.cms.getEventRules({
     *     nameRegex: "^my-EventRule",
     * });
     * export const cmsEventRuleId2 = nameRegex.then(nameRegex => nameRegex.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cms.get_event_rules(ids=["example_id"])
     * pulumi.export("cmsEventRuleId1", ids.rules[0].id)
     * name_regex = alicloud.cms.get_event_rules(name_regex="^my-EventRule")
     * pulumi.export("cmsEventRuleId2", name_regex.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cms.GetEventRules.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Cms.GetEventRules.Invoke(new()
     *     {
     *         NameRegex = "^my-EventRule",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cmsEventRuleId1"] = ids&#46;Apply(getEventRulesResult => getEventRulesResult&#46;Rules[0]?.Id),
     *         ["cmsEventRuleId2"] = nameRegex&#46;Apply(getEventRulesResult => getEventRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cms.GetEventRules(ctx, &cms.GetEventRulesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsEventRuleId1", ids.Rules[0].Id)
     * 		nameRegex, err := cms.GetEventRules(ctx, &cms.GetEventRulesArgs{
     * 			NameRegex: pulumi.StringRef("^my-EventRule"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsEventRuleId2", nameRegex.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetEventRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CmsFunctions.getEventRules(GetEventRulesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("cmsEventRuleId1", ids.applyValue(getEventRulesResult -> getEventRulesResult.rules()[0].id()));
     *         final var nameRegex = CmsFunctions.getEventRules(GetEventRulesArgs.builder()
     *             .nameRegex("^my-EventRule")
     *             .build());
     *         ctx.export("cmsEventRuleId2", nameRegex.applyValue(getEventRulesResult -> getEventRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cms:getEventRules
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cms:getEventRules
     *       Arguments:
     *         nameRegex: ^my-EventRule
     * outputs:
     *   cmsEventRuleId1: ${ids.rules[0].id}
     *   cmsEventRuleId2: ${nameRegex.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEventRules.
     * @return A collection of values returned by getEventRules.
     */
    public suspend fun getEventRules(argument: GetEventRulesPlainArgs): GetEventRulesResult =
        getEventRulesResultToKotlin(getEventRulesPlain(argument.toJava()).await())

    /**
     * @see [getEventRules].
     * @param ids A list of Event Rule IDs. Its element value is same as Event Rule Name.
     * @param namePrefix The name prefix.
     * @param nameRegex A regex string to filter results by Event Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the resource. Valid values: `DISABLED`, `ENABLED`.
     * @return A collection of values returned by getEventRules.
     */
    public suspend fun getEventRules(
        ids: List<String>? = null,
        namePrefix: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetEventRulesResult {
        val argument = GetEventRulesPlainArgs(
            ids = ids,
            namePrefix = namePrefix,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return getEventRulesResultToKotlin(getEventRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetEventRulesPlainArgs].
     * @return A collection of values returned by getEventRules.
     */
    public suspend fun getEventRules(argument: suspend GetEventRulesPlainArgsBuilder.() -> Unit): GetEventRulesResult {
        val builder = GetEventRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventRulesResultToKotlin(getEventRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Group Metric Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.104.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cms.getGroupMetricRules({
     *     ids: ["4a9a8978-a9cc-55ca-aa7c-530ccd91ae57"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstCmsGroupMetricRuleId = example.then(example => example.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cms.get_group_metric_rules(ids=["4a9a8978-a9cc-55ca-aa7c-530ccd91ae57"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstCmsGroupMetricRuleId", example.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cms.GetGroupMetricRules.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "4a9a8978-a9cc-55ca-aa7c-530ccd91ae57",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCmsGroupMetricRuleId"] = example&#46;Apply(getGroupMetricRulesResult => getGroupMetricRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cms.GetGroupMetricRules(ctx, &cms.GetGroupMetricRulesArgs{
     * 			Ids: []string{
     * 				"4a9a8978-a9cc-55ca-aa7c-530ccd91ae57",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCmsGroupMetricRuleId", example.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetGroupMetricRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CmsFunctions.getGroupMetricRules(GetGroupMetricRulesArgs.builder()
     *             .ids("4a9a8978-a9cc-55ca-aa7c-530ccd91ae57")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstCmsGroupMetricRuleId", example.applyValue(getGroupMetricRulesResult -> getGroupMetricRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cms:getGroupMetricRules
     *       Arguments:
     *         ids:
     *           - 4a9a8978-a9cc-55ca-aa7c-530ccd91ae57
     *         nameRegex: the_resource_name
     * outputs:
     *   firstCmsGroupMetricRuleId: ${example.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroupMetricRules.
     * @return A collection of values returned by getGroupMetricRules.
     */
    public suspend fun getGroupMetricRules(argument: GetGroupMetricRulesPlainArgs): GetGroupMetricRulesResult =
        getGroupMetricRulesResultToKotlin(getGroupMetricRulesPlain(argument.toJava()).await())

    /**
     * @see [getGroupMetricRules].
     * @param dimensions The dimensions that specify the resources to be associated with the alert rule.
     * @param enableState EnableState.
     * @param groupId The ID of the application group.
     * @param groupMetricRuleName The name of the alert rule.
     * @param ids A list of Group Metric Rule IDs.
     * @param metricName The name of the metric.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param namespace The namespace of the service.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of Group Metric Rule.
     * @return A collection of values returned by getGroupMetricRules.
     */
    public suspend fun getGroupMetricRules(
        dimensions: String? = null,
        enableState: Boolean? = null,
        groupId: String? = null,
        groupMetricRuleName: String? = null,
        ids: List<String>? = null,
        metricName: String? = null,
        nameRegex: String? = null,
        namespace: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetGroupMetricRulesResult {
        val argument = GetGroupMetricRulesPlainArgs(
            dimensions = dimensions,
            enableState = enableState,
            groupId = groupId,
            groupMetricRuleName = groupMetricRuleName,
            ids = ids,
            metricName = metricName,
            nameRegex = nameRegex,
            namespace = namespace,
            outputFile = outputFile,
            status = status,
        )
        return getGroupMetricRulesResultToKotlin(getGroupMetricRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupMetricRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetGroupMetricRulesPlainArgs].
     * @return A collection of values returned by getGroupMetricRules.
     */
    public suspend fun getGroupMetricRules(argument: suspend GetGroupMetricRulesPlainArgsBuilder.() -> Unit): GetGroupMetricRulesResult {
        val builder = GetGroupMetricRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupMetricRulesResultToKotlin(getGroupMetricRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Hybrid Monitor Datas of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.177.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cms.getHybridMonitorDatas({
     *     namespace: "example_value",
     *     promSql: "AliyunEcs_cpu_total",
     *     start: "1657505665",
     *     end: "1657520065",
     * });
     * export const cmsMetricRuleTemplateId1 = _default.then(_default => _default.datas?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cms.get_hybrid_monitor_datas(namespace="example_value",
     *     prom_sql="AliyunEcs_cpu_total",
     *     start="1657505665",
     *     end="1657520065")
     * pulumi.export("cmsMetricRuleTemplateId1", default.datas[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cms.GetHybridMonitorDatas.Invoke(new()
     *     {
     *         Namespace = "example_value",
     *         PromSql = "AliyunEcs_cpu_total",
     *         Start = "1657505665",
     *         End = "1657520065",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cmsMetricRuleTemplateId1"] = @default&#46;Apply(@default => @default&#46;Apply(getHybridMonitorDatasResult => getHybridMonitorDatasResult&#46;Datas[0])),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cms.GetHybridMonitorDatas(ctx, &cms.GetHybridMonitorDatasArgs{
     * 			Namespace: "example_value",
     * 			PromSql:   "AliyunEcs_cpu_total",
     * 			Start:     "1657505665",
     * 			End:       "1657520065",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsMetricRuleTemplateId1", _default.Datas[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetHybridMonitorDatasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CmsFunctions.getHybridMonitorDatas(GetHybridMonitorDatasArgs.builder()
     *             .namespace("example_value")
     *             .promSql("AliyunEcs_cpu_total")
     *             .start("1657505665")
     *             .end("1657520065")
     *             .build());
     *         ctx.export("cmsMetricRuleTemplateId1", default_.datas()[0]);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cms:getHybridMonitorDatas
     *       Arguments:
     *         namespace: example_value
     *         promSql: AliyunEcs_cpu_total
     *         start: '1657505665'
     *         end: '1657520065'
     * outputs:
     *   cmsMetricRuleTemplateId1: ${default.datas[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHybridMonitorDatas.
     * @return A collection of values returned by getHybridMonitorDatas.
     */
    public suspend fun getHybridMonitorDatas(argument: GetHybridMonitorDatasPlainArgs): GetHybridMonitorDatasResult =
        getHybridMonitorDatasResultToKotlin(getHybridMonitorDatasPlain(argument.toJava()).await())

    /**
     * @see [getHybridMonitorDatas].
     * @param end The timestamp that specifies the end of the time range to query.
     * @param namespace The name of the namespace.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param period The interval at which monitoring data is collected. Unit: seconds.
     * @param promSql The name of the metric. Note PromQL statements are supported.
     * @param start The timestamp that specifies the beginning of the time range to query.
     * @return A collection of values returned by getHybridMonitorDatas.
     */
    public suspend fun getHybridMonitorDatas(
        end: String,
        namespace: String,
        outputFile: String? = null,
        period: String? = null,
        promSql: String,
        start: String,
    ): GetHybridMonitorDatasResult {
        val argument = GetHybridMonitorDatasPlainArgs(
            end = end,
            namespace = namespace,
            outputFile = outputFile,
            period = period,
            promSql = promSql,
            start = start,
        )
        return getHybridMonitorDatasResultToKotlin(getHybridMonitorDatasPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridMonitorDatas].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetHybridMonitorDatasPlainArgs].
     * @return A collection of values returned by getHybridMonitorDatas.
     */
    public suspend fun getHybridMonitorDatas(argument: suspend GetHybridMonitorDatasPlainArgsBuilder.() -> Unit): GetHybridMonitorDatasResult {
        val builder = GetHybridMonitorDatasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridMonitorDatasResultToKotlin(getHybridMonitorDatasPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Hybrid Monitor Fc Tasks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.179.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cms.getHybridMonitorFcTasks({
     *     ids: ["example_value"],
     * });
     * export const cmsHybridMonitorFcTaskId1 = ids.then(ids => ids.tasks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cms.get_hybrid_monitor_fc_tasks(ids=["example_value"])
     * pulumi.export("cmsHybridMonitorFcTaskId1", ids.tasks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cms.GetHybridMonitorFcTasks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cmsHybridMonitorFcTaskId1"] = ids&#46;Apply(getHybridMonitorFcTasksResult => getHybridMonitorFcTasksResult&#46;Tasks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cms.GetHybridMonitorFcTasks(ctx, &cms.GetHybridMonitorFcTasksArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsHybridMonitorFcTaskId1", ids.Tasks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetHybridMonitorFcTasksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CmsFunctions.getHybridMonitorFcTasks(GetHybridMonitorFcTasksArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("cmsHybridMonitorFcTaskId1", ids.applyValue(getHybridMonitorFcTasksResult -> getHybridMonitorFcTasksResult.tasks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cms:getHybridMonitorFcTasks
     *       Arguments:
     *         ids:
     *           - example_value
     * outputs:
     *   cmsHybridMonitorFcTaskId1: ${ids.tasks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHybridMonitorFcTasks.
     * @return A collection of values returned by getHybridMonitorFcTasks.
     */
    public suspend fun getHybridMonitorFcTasks(argument: GetHybridMonitorFcTasksPlainArgs): GetHybridMonitorFcTasksResult =
        getHybridMonitorFcTasksResultToKotlin(getHybridMonitorFcTasksPlain(argument.toJava()).await())

    /**
     * @see [getHybridMonitorFcTasks].
     * @param ids A list of Hybrid Monitor Fc Task IDs.
     * @param namespace The name of the namespace.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getHybridMonitorFcTasks.
     */
    public suspend fun getHybridMonitorFcTasks(
        ids: List<String>? = null,
        namespace: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetHybridMonitorFcTasksResult {
        val argument = GetHybridMonitorFcTasksPlainArgs(
            ids = ids,
            namespace = namespace,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getHybridMonitorFcTasksResultToKotlin(getHybridMonitorFcTasksPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridMonitorFcTasks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetHybridMonitorFcTasksPlainArgs].
     * @return A collection of values returned by getHybridMonitorFcTasks.
     */
    public suspend fun getHybridMonitorFcTasks(argument: suspend GetHybridMonitorFcTasksPlainArgsBuilder.() -> Unit): GetHybridMonitorFcTasksResult {
        val builder = GetHybridMonitorFcTasksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridMonitorFcTasksResultToKotlin(getHybridMonitorFcTasksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Hybrid Monitor Sls Tasks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.179.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cms.getHybridMonitorSlsTasks({
     *     ids: ["example_value"],
     * });
     * export const cmsHybridMonitorSlsTaskId1 = ids.then(ids => ids.tasks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cms.get_hybrid_monitor_sls_tasks(ids=["example_value"])
     * pulumi.export("cmsHybridMonitorSlsTaskId1", ids.tasks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cms.GetHybridMonitorSlsTasks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cmsHybridMonitorSlsTaskId1"] = ids&#46;Apply(getHybridMonitorSlsTasksResult => getHybridMonitorSlsTasksResult&#46;Tasks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cms.GetHybridMonitorSlsTasks(ctx, &cms.GetHybridMonitorSlsTasksArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsHybridMonitorSlsTaskId1", ids.Tasks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetHybridMonitorSlsTasksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CmsFunctions.getHybridMonitorSlsTasks(GetHybridMonitorSlsTasksArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("cmsHybridMonitorSlsTaskId1", ids.applyValue(getHybridMonitorSlsTasksResult -> getHybridMonitorSlsTasksResult.tasks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cms:getHybridMonitorSlsTasks
     *       Arguments:
     *         ids:
     *           - example_value
     * outputs:
     *   cmsHybridMonitorSlsTaskId1: ${ids.tasks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHybridMonitorSlsTasks.
     * @return A collection of values returned by getHybridMonitorSlsTasks.
     */
    public suspend fun getHybridMonitorSlsTasks(argument: GetHybridMonitorSlsTasksPlainArgs): GetHybridMonitorSlsTasksResult =
        getHybridMonitorSlsTasksResultToKotlin(getHybridMonitorSlsTasksPlain(argument.toJava()).await())

    /**
     * @see [getHybridMonitorSlsTasks].
     * @param ids A list of Hybrid Monitor Sls Task IDs.
     * @param keyword The keyword that is used to search for metric import tasks.
     * @param namespace The name of the namespace.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getHybridMonitorSlsTasks.
     */
    public suspend fun getHybridMonitorSlsTasks(
        ids: List<String>? = null,
        keyword: String? = null,
        namespace: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetHybridMonitorSlsTasksResult {
        val argument = GetHybridMonitorSlsTasksPlainArgs(
            ids = ids,
            keyword = keyword,
            namespace = namespace,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getHybridMonitorSlsTasksResultToKotlin(getHybridMonitorSlsTasksPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridMonitorSlsTasks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetHybridMonitorSlsTasksPlainArgs].
     * @return A collection of values returned by getHybridMonitorSlsTasks.
     */
    public suspend fun getHybridMonitorSlsTasks(argument: suspend GetHybridMonitorSlsTasksPlainArgsBuilder.() -> Unit): GetHybridMonitorSlsTasksResult {
        val builder = GetHybridMonitorSlsTasksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridMonitorSlsTasksResultToKotlin(getHybridMonitorSlsTasksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cloud Monitor Service Metric Rule Black List available to the user.[What is Metric Rule Black List](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruleblacklist)
     * > **NOTE:** Available in 1.194.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cms.getMetricRuleBlackLists({
     *     ids: [defaultAlicloudCmsMetricRuleBlackLists&#46;id],
     *     category: "ecs",
     *     namespace: "acs_ecs_dashboard",
     * });
     * export const alicloudCmsRuleBlackListExampleId = lists[0].id;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cms.get_metric_rule_black_lists(ids=[default_alicloud_cms_metric_rule_black_lists["id"]],
     *     category="ecs",
     *     namespace="acs_ecs_dashboard")
     * pulumi.export("alicloudCmsRuleBlackListExampleId", lists[0]["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cms.GetMetricRuleBlackLists.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudCmsMetricRuleBlackLists.Id,
     *         },
     *         Category = "ecs",
     *         Namespace = "acs_ecs_dashboard",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCmsRuleBlackListExampleId"] = lists[0].Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := cms.GetMetricRuleBlackLists(ctx, &cms.GetMetricRuleBlackListsArgs{
     * Ids: interface{}{
     * defaultAlicloudCmsMetricRuleBlackLists.Id,
     * },
     * Category: pulumi.StringRef("ecs"),
     * Namespace: pulumi.StringRef("acs_ecs_dashboard"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudCmsRuleBlackListExampleId", lists[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetMetricRuleBlackListsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CmsFunctions.getMetricRuleBlackLists(GetMetricRuleBlackListsArgs.builder()
     *             .ids(defaultAlicloudCmsMetricRuleBlackLists.id())
     *             .category("ecs")
     *             .namespace("acs_ecs_dashboard")
     *             .build());
     *         ctx.export("alicloudCmsRuleBlackListExampleId", lists[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cms:getMetricRuleBlackLists
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudCmsMetricRuleBlackLists.id}
     *         category: ecs
     *         namespace: acs_ecs_dashboard
     * outputs:
     *   alicloudCmsRuleBlackListExampleId: ${lists[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMetricRuleBlackLists.
     * @return A collection of values returned by getMetricRuleBlackLists.
     */
    public suspend fun getMetricRuleBlackLists(argument: GetMetricRuleBlackListsPlainArgs): GetMetricRuleBlackListsResult =
        getMetricRuleBlackListsResultToKotlin(getMetricRuleBlackListsPlain(argument.toJava()).await())

    /**
     * @see [getMetricRuleBlackLists].
     * @param category Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
     * @param ids A list of Metric Rule Black List IDs.
     * @param metricRuleBlackListId The first ID of the resource
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param namespace The data namespace of the cloud service.
     * @param order
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getMetricRuleBlackLists.
     */
    public suspend fun getMetricRuleBlackLists(
        category: String? = null,
        ids: List<String>? = null,
        metricRuleBlackListId: String? = null,
        nameRegex: String? = null,
        namespace: String? = null,
        order: Int? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetMetricRuleBlackListsResult {
        val argument = GetMetricRuleBlackListsPlainArgs(
            category = category,
            ids = ids,
            metricRuleBlackListId = metricRuleBlackListId,
            nameRegex = nameRegex,
            namespace = namespace,
            order = order,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getMetricRuleBlackListsResultToKotlin(getMetricRuleBlackListsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMetricRuleBlackLists].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetMetricRuleBlackListsPlainArgs].
     * @return A collection of values returned by getMetricRuleBlackLists.
     */
    public suspend fun getMetricRuleBlackLists(argument: suspend GetMetricRuleBlackListsPlainArgsBuilder.() -> Unit): GetMetricRuleBlackListsResult {
        val builder = GetMetricRuleBlackListsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMetricRuleBlackListsResultToKotlin(getMetricRuleBlackListsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Metric Rule Templates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cms.getMetricRuleTemplates({
     *     ids: ["example_value"],
     * });
     * export const cmsMetricRuleTemplateId1 = ids.then(ids => ids.templates?.[0]?.id);
     * const nameRegex = alicloud.cms.getMetricRuleTemplates({
     *     nameRegex: "^my-MetricRuleTemplate",
     * });
     * export const cmsMetricRuleTemplateId2 = nameRegex.then(nameRegex => nameRegex.templates?.[0]?.id);
     * const keyword = alicloud.cms.getMetricRuleTemplates({
     *     keyword: "^my-MetricRuleTemplate",
     * });
     * export const cmsMetricRuleTemplateId3 = nameRegex.then(nameRegex => nameRegex.templates?.[0]?.id);
     * const templateId = alicloud.cms.getMetricRuleTemplates({
     *     templateId: "example_value",
     * });
     * export const cmsMetricRuleTemplateId4 = nameRegex.then(nameRegex => nameRegex.templates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cms.get_metric_rule_templates(ids=["example_value"])
     * pulumi.export("cmsMetricRuleTemplateId1", ids.templates[0].id)
     * name_regex = alicloud.cms.get_metric_rule_templates(name_regex="^my-MetricRuleTemplate")
     * pulumi.export("cmsMetricRuleTemplateId2", name_regex.templates[0].id)
     * keyword = alicloud.cms.get_metric_rule_templates(keyword="^my-MetricRuleTemplate")
     * pulumi.export("cmsMetricRuleTemplateId3", name_regex.templates[0].id)
     * template_id = alicloud.cms.get_metric_rule_templates(template_id="example_value")
     * pulumi.export("cmsMetricRuleTemplateId4", name_regex.templates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cms.GetMetricRuleTemplates.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var nameRegex = AliCloud.Cms.GetMetricRuleTemplates.Invoke(new()
     *     {
     *         NameRegex = "^my-MetricRuleTemplate",
     *     });
     *     var keyword = AliCloud.Cms.GetMetricRuleTemplates.Invoke(new()
     *     {
     *         Keyword = "^my-MetricRuleTemplate",
     *     });
     *     var templateId = AliCloud.Cms.GetMetricRuleTemplates.Invoke(new()
     *     {
     *         TemplateId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cmsMetricRuleTemplateId1"] = ids&#46;Apply(getMetricRuleTemplatesResult => getMetricRuleTemplatesResult&#46;Templates[0]?.Id),
     *         ["cmsMetricRuleTemplateId2"] = nameRegex&#46;Apply(getMetricRuleTemplatesResult => getMetricRuleTemplatesResult&#46;Templates[0]?.Id),
     *         ["cmsMetricRuleTemplateId3"] = nameRegex&#46;Apply(getMetricRuleTemplatesResult => getMetricRuleTemplatesResult&#46;Templates[0]?.Id),
     *         ["cmsMetricRuleTemplateId4"] = nameRegex&#46;Apply(getMetricRuleTemplatesResult => getMetricRuleTemplatesResult&#46;Templates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cms.GetMetricRuleTemplates(ctx, &cms.GetMetricRuleTemplatesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsMetricRuleTemplateId1", ids.Templates[0].Id)
     * 		nameRegex, err := cms.GetMetricRuleTemplates(ctx, &cms.GetMetricRuleTemplatesArgs{
     * 			NameRegex: pulumi.StringRef("^my-MetricRuleTemplate"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsMetricRuleTemplateId2", nameRegex.Templates[0].Id)
     * 		_, err = cms.GetMetricRuleTemplates(ctx, &cms.GetMetricRuleTemplatesArgs{
     * 			Keyword: pulumi.StringRef("^my-MetricRuleTemplate"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsMetricRuleTemplateId3", nameRegex.Templates[0].Id)
     * 		_, err = cms.GetMetricRuleTemplates(ctx, &cms.GetMetricRuleTemplatesArgs{
     * 			TemplateId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsMetricRuleTemplateId4", nameRegex.Templates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetMetricRuleTemplatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CmsFunctions.getMetricRuleTemplates(GetMetricRuleTemplatesArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("cmsMetricRuleTemplateId1", ids.applyValue(getMetricRuleTemplatesResult -> getMetricRuleTemplatesResult.templates()[0].id()));
     *         final var nameRegex = CmsFunctions.getMetricRuleTemplates(GetMetricRuleTemplatesArgs.builder()
     *             .nameRegex("^my-MetricRuleTemplate")
     *             .build());
     *         ctx.export("cmsMetricRuleTemplateId2", nameRegex.applyValue(getMetricRuleTemplatesResult -> getMetricRuleTemplatesResult.templates()[0].id()));
     *         final var keyword = CmsFunctions.getMetricRuleTemplates(GetMetricRuleTemplatesArgs.builder()
     *             .keyword("^my-MetricRuleTemplate")
     *             .build());
     *         ctx.export("cmsMetricRuleTemplateId3", nameRegex.applyValue(getMetricRuleTemplatesResult -> getMetricRuleTemplatesResult.templates()[0].id()));
     *         final var templateId = CmsFunctions.getMetricRuleTemplates(GetMetricRuleTemplatesArgs.builder()
     *             .templateId("example_value")
     *             .build());
     *         ctx.export("cmsMetricRuleTemplateId4", nameRegex.applyValue(getMetricRuleTemplatesResult -> getMetricRuleTemplatesResult.templates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cms:getMetricRuleTemplates
     *       Arguments:
     *         ids:
     *           - example_value
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cms:getMetricRuleTemplates
     *       Arguments:
     *         nameRegex: ^my-MetricRuleTemplate
     *   keyword:
     *     fn::invoke:
     *       Function: alicloud:cms:getMetricRuleTemplates
     *       Arguments:
     *         keyword: ^my-MetricRuleTemplate
     *   templateId:
     *     fn::invoke:
     *       Function: alicloud:cms:getMetricRuleTemplates
     *       Arguments:
     *         templateId: example_value
     * outputs:
     *   cmsMetricRuleTemplateId1: ${ids.templates[0].id}
     *   cmsMetricRuleTemplateId2: ${nameRegex.templates[0].id}
     *   cmsMetricRuleTemplateId3: ${nameRegex.templates[0].id}
     *   cmsMetricRuleTemplateId4: ${nameRegex.templates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMetricRuleTemplates.
     * @return A collection of values returned by getMetricRuleTemplates.
     */
    public suspend fun getMetricRuleTemplates(argument: GetMetricRuleTemplatesPlainArgs): GetMetricRuleTemplatesResult =
        getMetricRuleTemplatesResultToKotlin(getMetricRuleTemplatesPlain(argument.toJava()).await())

    /**
     * @see [getMetricRuleTemplates].
     * @param enableDetails Valid values: `true` or `false`. Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Metric Rule Template IDs.
     * @param keyword The name of the alert template. You can perform fuzzy search based on the template name.
     * @param metricRuleTemplateName The name of the alert template.
     * @param nameRegex A regex string to filter results by Metric Rule Template name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param templateId The ID of the alert template.
     * @return A collection of values returned by getMetricRuleTemplates.
     */
    public suspend fun getMetricRuleTemplates(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        keyword: String? = null,
        metricRuleTemplateName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        templateId: String? = null,
    ): GetMetricRuleTemplatesResult {
        val argument = GetMetricRuleTemplatesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            keyword = keyword,
            metricRuleTemplateName = metricRuleTemplateName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            templateId = templateId,
        )
        return getMetricRuleTemplatesResultToKotlin(getMetricRuleTemplatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getMetricRuleTemplates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetMetricRuleTemplatesPlainArgs].
     * @return A collection of values returned by getMetricRuleTemplates.
     */
    public suspend fun getMetricRuleTemplates(argument: suspend GetMetricRuleTemplatesPlainArgsBuilder.() -> Unit): GetMetricRuleTemplatesResult {
        val builder = GetMetricRuleTemplatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMetricRuleTemplatesResultToKotlin(getMetricRuleTemplatesPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getMonitorGroupInstances.
     * @return A collection of values returned by getMonitorGroupInstances.
     */
    public suspend fun getMonitorGroupInstances(argument: GetMonitorGroupInstancesPlainArgs): GetMonitorGroupInstancesResult =
        getMonitorGroupInstancesResultToKotlin(getMonitorGroupInstancesPlain(argument.toJava()).await())

    /**
     * @see [getMonitorGroupInstances].
     * @param ids
     * @param keyword
     * @param outputFile
     * @return A collection of values returned by getMonitorGroupInstances.
     */
    public suspend fun getMonitorGroupInstances(
        ids: String,
        keyword: String? = null,
        outputFile: String? = null,
    ): GetMonitorGroupInstancesResult {
        val argument = GetMonitorGroupInstancesPlainArgs(
            ids = ids,
            keyword = keyword,
            outputFile = outputFile,
        )
        return getMonitorGroupInstancesResultToKotlin(getMonitorGroupInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitorGroupInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetMonitorGroupInstancesPlainArgs].
     * @return A collection of values returned by getMonitorGroupInstances.
     */
    public suspend fun getMonitorGroupInstances(argument: suspend GetMonitorGroupInstancesPlainArgsBuilder.() -> Unit): GetMonitorGroupInstancesResult {
        val builder = GetMonitorGroupInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitorGroupInstancesResultToKotlin(getMonitorGroupInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Monitor Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.113.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cms.getMonitorGroups({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstCmsMonitorGroupId = example.then(example => example.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cms.get_monitor_groups(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstCmsMonitorGroupId", example.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cms.GetMonitorGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCmsMonitorGroupId"] = example&#46;Apply(getMonitorGroupsResult => getMonitorGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cms.GetMonitorGroups(ctx, &cms.GetMonitorGroupsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCmsMonitorGroupId", example.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetMonitorGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CmsFunctions.getMonitorGroups(GetMonitorGroupsArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstCmsMonitorGroupId", example.applyValue(getMonitorGroupsResult -> getMonitorGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cms:getMonitorGroups
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstCmsMonitorGroupId: ${example.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMonitorGroups.
     * @return A collection of values returned by getMonitorGroups.
     */
    public suspend fun getMonitorGroups(argument: GetMonitorGroupsPlainArgs): GetMonitorGroupsResult =
        getMonitorGroupsResultToKotlin(getMonitorGroupsPlain(argument.toJava()).await())

    /**
     * @see [getMonitorGroups].
     * @param dynamicTagRuleId The ID of the tag rule.
     * @param ids A list of Monitor Group IDs.
     * @param includeTemplateHistory The include template history.
     * @param keyword The keyword to be matched.
     * @param monitorGroupName The name of the application group.
     * @param nameRegex A regex string to filter results by Monitor Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param selectContactGroups The select contact groups.
     * @param tags
     * @param type The type of the application group. Valid values: `custom`, `ehpc_cluster`, `kubernetes`.
     * @return A collection of values returned by getMonitorGroups.
     */
    public suspend fun getMonitorGroups(
        dynamicTagRuleId: String? = null,
        ids: List<String>? = null,
        includeTemplateHistory: Boolean? = null,
        keyword: String? = null,
        monitorGroupName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        selectContactGroups: Boolean? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
    ): GetMonitorGroupsResult {
        val argument = GetMonitorGroupsPlainArgs(
            dynamicTagRuleId = dynamicTagRuleId,
            ids = ids,
            includeTemplateHistory = includeTemplateHistory,
            keyword = keyword,
            monitorGroupName = monitorGroupName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            selectContactGroups = selectContactGroups,
            tags = tags,
            type = type,
        )
        return getMonitorGroupsResultToKotlin(getMonitorGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitorGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetMonitorGroupsPlainArgs].
     * @return A collection of values returned by getMonitorGroups.
     */
    public suspend fun getMonitorGroups(argument: suspend GetMonitorGroupsPlainArgsBuilder.() -> Unit): GetMonitorGroupsResult {
        val builder = GetMonitorGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitorGroupsResultToKotlin(getMonitorGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Namespaces of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.171.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cms.getNamespaces({
     *     ids: ["example_id"],
     * });
     * export const cmsNamespaceId1 = ids.then(ids => ids.namespaces?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cms.get_namespaces(ids=["example_id"])
     * pulumi.export("cmsNamespaceId1", ids.namespaces[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cms.GetNamespaces.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cmsNamespaceId1"] = ids&#46;Apply(getNamespacesResult => getNamespacesResult&#46;Namespaces[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cms.GetNamespaces(ctx, &cms.GetNamespacesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsNamespaceId1", ids.Namespaces[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetNamespacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CmsFunctions.getNamespaces(GetNamespacesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("cmsNamespaceId1", ids.applyValue(getNamespacesResult -> getNamespacesResult.namespaces()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cms:getNamespaces
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   cmsNamespaceId1: ${ids.namespaces[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNamespaces.
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: GetNamespacesPlainArgs): GetNamespacesResult =
        getNamespacesResultToKotlin(getNamespacesPlain(argument.toJava()).await())

    /**
     * @see [getNamespaces].
     * @param ids A list of Namespace IDs.
     * @param keyword The keywords of the `namespace` or `description` of the namespace.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(
        ids: List<String>? = null,
        keyword: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetNamespacesResult {
        val argument = GetNamespacesPlainArgs(
            ids = ids,
            keyword = keyword,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getNamespacesResultToKotlin(getNamespacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetNamespacesPlainArgs].
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: suspend GetNamespacesPlainArgsBuilder.() -> Unit): GetNamespacesResult {
        val builder = GetNamespacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespacesResultToKotlin(getNamespacesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open CMS service automatically. If the service has been opened, it will return opened.
     * For information about CMS and how to use it, see [What is CMS](https://help.aliyun.com/product/28572.html).
     * > **NOTE:** Available in v1.111.0+
     * > **DEPRECATED:**  This data source has been deprecated from version `1.219.0`. The Cloud Monitor Service is no longer needed to open in the product dimension and the OpenAPI has been taken [offline](https://api.alibabacloud.com/api/Cms/2019-01-01/OpenCmsService).
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.cms.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.cms.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Cms.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cms.GetService(ctx, &cms.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = CmsFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:cms:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the CMS service that means you have read and agreed the [CMS Terms of Service](https://help.aliyun.com/document_detail/68185.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cloud Monitor Service Site Monitor available to the user.[What is Site Monitor](https://www.alibabacloud.com/help/en/)
     * > **NOTE:** Available since v1.224.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * import * as random from "@pulumi/random";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf_example";
     * const defaultInteger = new random.index.Integer("default", {
     *     min: 10000,
     *     max: 99999,
     * });
     * const defaultSiteMonitor = new alicloud.cms.SiteMonitor("default", {
     *     address: "http://www.alibabacloud.com",
     *     taskName: `terraform-example-${defaultInteger.result}`,
     *     taskType: "HTTP",
     *     interval: 5,
     *     ispCities: [{
     *         city: "546",
     *         isp: "465",
     *     }],
     *     optionsJson: `{
     *     "http_method": "get",
     *     "waitTime_after_completion": null,
     *     "ipv6_task": false,
     *     "diagnosis_ping": false,
     *     "diagnosis_mtr": false,
     *     "assertions": [
     *         {
     *             "operator": "lessThan",
     *             "type": "response_time",
     *             "target": 1000
     *         }
     *     ],
     *     "time_out": 30000
     * }
     * `,
     * });
     * const default = alicloud.cms.getSiteMonitorsOutput({
     *     ids: [defaultSiteMonitor&#46;id],
     *     taskType: "HTTP",
     * });
     * export const alicloudCmsSiteMonitorExampleId = _default.apply(_default => _default.monitors?.[0]?.taskId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * import pulumi_random as random
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf_example"
     * default_integer = random.index.Integer("default",
     *     min=10000,
     *     max=99999)
     * default_site_monitor = alicloud.cms.SiteMonitor("default",
     *     address="http://www.alibabacloud.com",
     *     task_name=f"terraform-example-{default_integer['result']}",
     *     task_type="HTTP",
     *     interval=5,
     *     isp_cities=[{
     *         "city": "546",
     *         "isp": "465",
     *     }],
     *     options_json="""{
     *     "http_method": "get",
     *     "waitTime_after_completion": null,
     *     "ipv6_task": false,
     *     "diagnosis_ping": false,
     *     "diagnosis_mtr": false,
     *     "assertions": [
     *         {
     *             "operator": "lessThan",
     *             "type": "response_time",
     *             "target": 1000
     *         }
     *     ],
     *     "time_out": 30000
     * }
     * """)
     * default = alicloud.cms.get_site_monitors_output(ids=[default_site_monitor&#46;id],
     *     task_type="HTTP")
     * pulumi.export("alicloudCmsSiteMonitorExampleId", default.monitors[0].task_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * using Random = Pulumi.Random;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf_example";
     *     var defaultInteger = new Random.Index.Integer("default", new()
     *     {
     *         Min = 10000,
     *         Max = 99999,
     *     });
     *     var defaultSiteMonitor = new AliCloud.Cms.SiteMonitor("default", new()
     *     {
     *         Address = "http://www.alibabacloud.com",
     *         TaskName = $"terraform-example-{defaultInteger.Result}",
     *         TaskType = "HTTP",
     *         Interval = 5,
     *         IspCities = new[]
     *         {
     *             new AliCloud.Cms.Inputs.SiteMonitorIspCityArgs
     *             {
     *                 City = "546",
     *                 Isp = "465",
     *             },
     *         },
     *         OptionsJson = @"{
     *     ""http_method"": ""get"",
     *     ""waitTime_after_completion"": null,
     *     ""ipv6_task"": false,
     *     ""diagnosis_ping"": false,
     *     ""diagnosis_mtr"": false,
     *     ""assertions"": [
     *         {
     *             ""operator"": ""lessThan"",
     *             ""type"": ""response_time"",
     *             ""target"": 1000
     *         }
     *     ],
     *     ""time_out"": 30000
     * }
     * ",
     *     });
     *     var @default = AliCloud.Cms.GetSiteMonitors.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultSiteMonitor.Id,
     *         },
     *         TaskType = "HTTP",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCmsSiteMonitorExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getSiteMonitorsResult => getSiteMonitorsResult&#46;Monitors[0]?.TaskId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * cfg := config.New(ctx, "")
     * name := "tf_example";
     * if param := cfg.Get("name"); param != ""{
     * name = param
     * }
     * defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
     * Min: 10000,
     * Max: 99999,
     * })
     * if err != nil {
     * return err
     * }
     * defaultSiteMonitor, err := cms.NewSiteMonitor(ctx, "default", &cms.SiteMonitorArgs{
     * Address: pulumi.String("http://www.alibabacloud.com"),
     * TaskName: pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
     * TaskType: pulumi.String("HTTP"),
     * Interval: pulumi.Int(5),
     * IspCities: cms.SiteMonitorIspCityArray{
     * &cms.SiteMonitorIspCityArgs{
     * City: pulumi.String("546"),
     * Isp: pulumi.String("465"),
     * },
     * },
     * OptionsJson: pulumi.String(`{
     *     "http_method": "get",
     *     "waitTime_after_completion": null,
     *     "ipv6_task": false,
     *     "diagnosis_ping": false,
     *     "diagnosis_mtr": false,
     *     "assertions": [
     *         {
     *             "operator": "lessThan",
     *             "type": "response_time",
     *             "target": 1000
     *         }
     *     ],
     *     "time_out": 30000
     * }
     * `),
     * })
     * if err != nil {
     * return err
     * }
     * _default := cms.GetSiteMonitorsOutput(ctx, cms.GetSiteMonitorsOutputArgs{
     * Ids: pulumi.StringArray{
     * defaultSiteMonitor.ID(),
     * },
     * TaskType: pulumi.String("HTTP"),
     * }, nil);
     * ctx.Export("alicloudCmsSiteMonitorExampleId", _default.ApplyT(func(_default cms.GetSiteMonitorsResult) (*string, error) {
     * return &default.Monitors[0].TaskId, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.random.integer;
     * import com.pulumi.random.IntegerArgs;
     * import com.pulumi.alicloud.cms.SiteMonitor;
     * import com.pulumi.alicloud.cms.SiteMonitorArgs;
     * import com.pulumi.alicloud.cms.inputs.SiteMonitorIspCityArgs;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetSiteMonitorsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("tf_example");
     *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
     *             .min(10000)
     *             .max(99999)
     *             .build());
     *         var defaultSiteMonitor = new SiteMonitor("defaultSiteMonitor", SiteMonitorArgs.builder()
     *             .address("http://www.alibabacloud.com")
     *             .taskName(String.format("terraform-example-%s", defaultInteger.result()))
     *             .taskType("HTTP")
     *             .interval(5)
     *             .ispCities(SiteMonitorIspCityArgs.builder()
     *                 .city("546")
     *                 .isp("465")
     *                 .build())
     *             .optionsJson("""
     * {
     *     "http_method": "get",
     *     "waitTime_after_completion": null,
     *     "ipv6_task": false,
     *     "diagnosis_ping": false,
     *     "diagnosis_mtr": false,
     *     "assertions": [
     *         {
     *             "operator": "lessThan",
     *             "type": "response_time",
     *             "target": 1000
     *         }
     *     ],
     *     "time_out": 30000
     * }
     *             """)
     *             .build());
     *         final var default = CmsFunctions.getSiteMonitors(GetSiteMonitorsArgs.builder()
     *             .ids(defaultSiteMonitor.id())
     *             .taskType("HTTP")
     *             .build());
     *         ctx.export("alicloudCmsSiteMonitorExampleId", default_.applyValue(default_ -> default_.monitors()[0].taskId()));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf_example
     * resources:
     *   defaultInteger:
     *     type: random:integer
     *     name: default
     *     properties:
     *       min: 10000
     *       max: 99999
     *   defaultSiteMonitor:
     *     type: alicloud:cms:SiteMonitor
     *     name: default
     *     properties:
     *       address: http://www.alibabacloud.com
     *       taskName: terraform-example-${defaultInteger.result}
     *       taskType: HTTP
     *       interval: 5
     *       ispCities:
     *         - city: '546'
     *           isp: '465'
     *       optionsJson: |
     *         {
     *             "http_method": "get",
     *             "waitTime_after_completion": null,
     *             "ipv6_task": false,
     *             "diagnosis_ping": false,
     *             "diagnosis_mtr": false,
     *             "assertions": [
     *                 {
     *                     "operator": "lessThan",
     *                     "type": "response_time",
     *                     "target": 1000
     *                 }
     *             ],
     *             "time_out": 30000
     *         }
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cms:getSiteMonitors
     *       Arguments:
     *         ids:
     *           - ${defaultSiteMonitor.id}
     *         taskType: HTTP
     * outputs:
     *   alicloudCmsSiteMonitorExampleId: ${default.monitors[0].taskId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSiteMonitors.
     * @return A collection of values returned by getSiteMonitors.
     */
    public suspend fun getSiteMonitors(argument: GetSiteMonitorsPlainArgs): GetSiteMonitorsResult =
        getSiteMonitorsResultToKotlin(getSiteMonitorsPlain(argument.toJava()).await())

    /**
     * @see [getSiteMonitors].
     * @param ids A list of Site Monitor IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param taskId Task ID.
     * @param taskType Task Type.
     * @return A collection of values returned by getSiteMonitors.
     */
    public suspend fun getSiteMonitors(
        ids: List<String>? = null,
        outputFile: String? = null,
        taskId: String? = null,
        taskType: String? = null,
    ): GetSiteMonitorsResult {
        val argument = GetSiteMonitorsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            taskId = taskId,
            taskType = taskType,
        )
        return getSiteMonitorsResultToKotlin(getSiteMonitorsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSiteMonitors].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetSiteMonitorsPlainArgs].
     * @return A collection of values returned by getSiteMonitors.
     */
    public suspend fun getSiteMonitors(argument: suspend GetSiteMonitorsPlainArgsBuilder.() -> Unit): GetSiteMonitorsResult {
        val builder = GetSiteMonitorsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSiteMonitorsResultToKotlin(getSiteMonitorsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cms Sls Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.171.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cms.getSlsGroups({
     *     ids: ["example_id"],
     * });
     * export const cmsSlsGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.cms.getSlsGroups({
     *     nameRegex: "^my-SlsGroup",
     * });
     * export const cmsSlsGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cms.get_sls_groups(ids=["example_id"])
     * pulumi.export("cmsSlsGroupId1", ids.groups[0].id)
     * name_regex = alicloud.cms.get_sls_groups(name_regex="^my-SlsGroup")
     * pulumi.export("cmsSlsGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cms.GetSlsGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Cms.GetSlsGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-SlsGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cmsSlsGroupId1"] = ids&#46;Apply(getSlsGroupsResult => getSlsGroupsResult&#46;Groups[0]?.Id),
     *         ["cmsSlsGroupId2"] = nameRegex&#46;Apply(getSlsGroupsResult => getSlsGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cms.GetSlsGroups(ctx, &cms.GetSlsGroupsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsSlsGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := cms.GetSlsGroups(ctx, &cms.GetSlsGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-SlsGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cmsSlsGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cms.CmsFunctions;
     * import com.pulumi.alicloud.cms.inputs.GetSlsGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CmsFunctions.getSlsGroups(GetSlsGroupsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("cmsSlsGroupId1", ids.applyValue(getSlsGroupsResult -> getSlsGroupsResult.groups()[0].id()));
     *         final var nameRegex = CmsFunctions.getSlsGroups(GetSlsGroupsArgs.builder()
     *             .nameRegex("^my-SlsGroup")
     *             .build());
     *         ctx.export("cmsSlsGroupId2", nameRegex.applyValue(getSlsGroupsResult -> getSlsGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cms:getSlsGroups
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cms:getSlsGroups
     *       Arguments:
     *         nameRegex: ^my-SlsGroup
     * outputs:
     *   cmsSlsGroupId1: ${ids.groups[0].id}
     *   cmsSlsGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSlsGroups.
     * @return A collection of values returned by getSlsGroups.
     */
    public suspend fun getSlsGroups(argument: GetSlsGroupsPlainArgs): GetSlsGroupsResult =
        getSlsGroupsResultToKotlin(getSlsGroupsPlain(argument.toJava()).await())

    /**
     * @see [getSlsGroups].
     * @param ids A list of Sls Group IDs. Its element value is same as Sls Group Name.
     * @param keyword The keywords of the `sls_group_name` or `sls_group_description` of the Sls Group.
     * @param nameRegex A regex string to filter results by Sls Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getSlsGroups.
     */
    public suspend fun getSlsGroups(
        ids: List<String>? = null,
        keyword: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetSlsGroupsResult {
        val argument = GetSlsGroupsPlainArgs(
            ids = ids,
            keyword = keyword,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getSlsGroupsResultToKotlin(getSlsGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSlsGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cms&#46;kotlin&#46;inputs&#46;GetSlsGroupsPlainArgs].
     * @return A collection of values returned by getSlsGroups.
     */
    public suspend fun getSlsGroups(argument: suspend GetSlsGroupsPlainArgsBuilder.() -> Unit): GetSlsGroupsResult {
        val builder = GetSlsGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSlsGroupsResultToKotlin(getSlsGroupsPlain(builtArgument.toJava()).await())
    }
}
