@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.DynamicTagGroupMatchExpress
import com.pulumi.alicloud.cms.kotlin.outputs.DynamicTagGroupMatchExpress.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DynamicTagGroup].
 */
@PulumiTagMarker
public class DynamicTagGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DynamicTagGroupArgs = DynamicTagGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DynamicTagGroupArgsBuilder.() -> Unit) {
        val builder = DynamicTagGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DynamicTagGroup {
        val builtJavaResource = com.pulumi.alicloud.cms.DynamicTagGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DynamicTagGroup(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Dynamic Tag Group resource.
 * For information about Cloud Monitor Service Dynamic Tag Group and how to use it, see [What is Dynamic Tag Group](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createdynamictaggroup).
 * > **NOTE:** Available since v1.142.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cms.AlarmContactGroup("default", {alarmContactGroupName: name});
 * const defaultDynamicTagGroup = new alicloud.cms.DynamicTagGroup("default", {
 *     tagKey: name,
 *     contactGroupLists: [_default&#46;id],
 *     matchExpresses: [{
 *         tagValue: name,
 *         tagValueMatchFunction: "all",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
 * default_dynamic_tag_group = alicloud.cms.DynamicTagGroup("default",
 *     tag_key=name,
 *     contact_group_lists=[default&#46;id],
 *     match_expresses=[{
 *         "tag_value": name,
 *         "tag_value_match_function": "all",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *     });
 *     var defaultDynamicTagGroup = new AliCloud.Cms.DynamicTagGroup("default", new()
 *     {
 *         TagKey = name,
 *         ContactGroupLists = new[]
 *         {
 *             @default.Id,
 *         },
 *         MatchExpresses = new[]
 *         {
 *             new AliCloud.Cms.Inputs.DynamicTagGroupMatchExpressArgs
 *             {
 *                 TagValue = name,
 *                 TagValueMatchFunction = "all",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewDynamicTagGroup(ctx, "default", &cms.DynamicTagGroupArgs{
 * 			TagKey: pulumi.String(name),
 * 			ContactGroupLists: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 			MatchExpresses: cms.DynamicTagGroupMatchExpressArray{
 * 				&cms.DynamicTagGroupMatchExpressArgs{
 * 					TagValue:              pulumi.String(name),
 * 					TagValueMatchFunction: pulumi.String("all"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.cms.DynamicTagGroup;
 * import com.pulumi.alicloud.cms.DynamicTagGroupArgs;
 * import com.pulumi.alicloud.cms.inputs.DynamicTagGroupMatchExpressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new AlarmContactGroup("default", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .build());
 *         var defaultDynamicTagGroup = new DynamicTagGroup("defaultDynamicTagGroup", DynamicTagGroupArgs.builder()
 *             .tagKey(name)
 *             .contactGroupLists(default_.id())
 *             .matchExpresses(DynamicTagGroupMatchExpressArgs.builder()
 *                 .tagValue(name)
 *                 .tagValueMatchFunction("all")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cms:AlarmContactGroup
 *     properties:
 *       alarmContactGroupName: ${name}
 *   defaultDynamicTagGroup:
 *     type: alicloud:cms:DynamicTagGroup
 *     name: default
 *     properties:
 *       tagKey: ${name}
 *       contactGroupLists:
 *         - ${default.id}
 *       matchExpresses:
 *         - tagValue: ${name}
 *           tagValueMatchFunction: all
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Dynamic Tag Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/dynamicTagGroup:DynamicTagGroup example <id>
 * ```
 */
public class DynamicTagGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.DynamicTagGroup,
) : KotlinCustomResource(javaResource, DynamicTagGroupMapper) {
    /**
     * The alert contact groups. The alert notifications of the application group are sent to the alert contacts that belong to the specified alert contact groups.
     */
    public val contactGroupLists: Output<List<String>>
        get() = javaResource.contactGroupLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The relationship between the conditional expressions for the tag values of the cloud resources. Valid values: `and`, `or`.
     */
    public val matchExpressFilterRelation: Output<String>
        get() = javaResource.matchExpressFilterRelation().applyValue({ args0 -> args0 })

    /**
     * The conditional expressions used to create an application group based on the tag. See `match_express` below.
     */
    public val matchExpresses: Output<List<DynamicTagGroupMatchExpress>>
        get() = javaResource.matchExpresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The status of the Dynamic Tag Group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag keys of the cloud resources.
     */
    public val tagKey: Output<String>
        get() = javaResource.tagKey().applyValue({ args0 -> args0 })

    /**
     * The IDs of the alert templates.
     */
    public val templateIdLists: Output<List<String>>?
        get() = javaResource.templateIdLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })
}

public object DynamicTagGroupMapper : ResourceMapper<DynamicTagGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.DynamicTagGroup::class == javaResource::class

    override fun map(javaResource: Resource): DynamicTagGroup = DynamicTagGroup(
        javaResource as
            com.pulumi.alicloud.cms.DynamicTagGroup,
    )
}

/**
 * @see [DynamicTagGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DynamicTagGroup].
 */
public suspend fun dynamicTagGroup(
    name: String,
    block: suspend DynamicTagGroupResourceBuilder.() -> Unit,
): DynamicTagGroup {
    val builder = DynamicTagGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DynamicTagGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dynamicTagGroup(name: String): DynamicTagGroup {
    val builder = DynamicTagGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
