@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.DynamicTagGroupArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.DynamicTagGroupMatchExpressArgs
import com.pulumi.alicloud.cms.kotlin.inputs.DynamicTagGroupMatchExpressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Dynamic Tag Group resource.
 * For information about Cloud Monitor Service Dynamic Tag Group and how to use it, see [What is Dynamic Tag Group](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createdynamictaggroup).
 * > **NOTE:** Available since v1.142.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cms.AlarmContactGroup("default", {alarmContactGroupName: name});
 * const defaultDynamicTagGroup = new alicloud.cms.DynamicTagGroup("default", {
 *     tagKey: name,
 *     contactGroupLists: [_default&#46;id],
 *     matchExpresses: [{
 *         tagValue: name,
 *         tagValueMatchFunction: "all",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
 * default_dynamic_tag_group = alicloud.cms.DynamicTagGroup("default",
 *     tag_key=name,
 *     contact_group_lists=[default&#46;id],
 *     match_expresses=[{
 *         "tag_value": name,
 *         "tag_value_match_function": "all",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *     });
 *     var defaultDynamicTagGroup = new AliCloud.Cms.DynamicTagGroup("default", new()
 *     {
 *         TagKey = name,
 *         ContactGroupLists = new[]
 *         {
 *             @default.Id,
 *         },
 *         MatchExpresses = new[]
 *         {
 *             new AliCloud.Cms.Inputs.DynamicTagGroupMatchExpressArgs
 *             {
 *                 TagValue = name,
 *                 TagValueMatchFunction = "all",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewDynamicTagGroup(ctx, "default", &cms.DynamicTagGroupArgs{
 * 			TagKey: pulumi.String(name),
 * 			ContactGroupLists: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 			MatchExpresses: cms.DynamicTagGroupMatchExpressArray{
 * 				&cms.DynamicTagGroupMatchExpressArgs{
 * 					TagValue:              pulumi.String(name),
 * 					TagValueMatchFunction: pulumi.String("all"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.cms.DynamicTagGroup;
 * import com.pulumi.alicloud.cms.DynamicTagGroupArgs;
 * import com.pulumi.alicloud.cms.inputs.DynamicTagGroupMatchExpressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new AlarmContactGroup("default", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .build());
 *         var defaultDynamicTagGroup = new DynamicTagGroup("defaultDynamicTagGroup", DynamicTagGroupArgs.builder()
 *             .tagKey(name)
 *             .contactGroupLists(default_.id())
 *             .matchExpresses(DynamicTagGroupMatchExpressArgs.builder()
 *                 .tagValue(name)
 *                 .tagValueMatchFunction("all")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cms:AlarmContactGroup
 *     properties:
 *       alarmContactGroupName: ${name}
 *   defaultDynamicTagGroup:
 *     type: alicloud:cms:DynamicTagGroup
 *     name: default
 *     properties:
 *       tagKey: ${name}
 *       contactGroupLists:
 *         - ${default.id}
 *       matchExpresses:
 *         - tagValue: ${name}
 *           tagValueMatchFunction: all
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Dynamic Tag Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/dynamicTagGroup:DynamicTagGroup example <id>
 * ```
 * @property contactGroupLists The alert contact groups. The alert notifications of the application group are sent to the alert contacts that belong to the specified alert contact groups.
 * @property matchExpressFilterRelation The relationship between the conditional expressions for the tag values of the cloud resources. Valid values: `and`, `or`.
 * @property matchExpresses The conditional expressions used to create an application group based on the tag. See `match_express` below.
 * @property tagKey The tag keys of the cloud resources.
 * @property templateIdLists The IDs of the alert templates.
 */
public data class DynamicTagGroupArgs(
    public val contactGroupLists: Output<List<String>>? = null,
    public val matchExpressFilterRelation: Output<String>? = null,
    public val matchExpresses: Output<List<DynamicTagGroupMatchExpressArgs>>? = null,
    public val tagKey: Output<String>? = null,
    public val templateIdLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.DynamicTagGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.DynamicTagGroupArgs =
        com.pulumi.alicloud.cms.DynamicTagGroupArgs.builder()
            .contactGroupLists(contactGroupLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .matchExpressFilterRelation(matchExpressFilterRelation?.applyValue({ args0 -> args0 }))
            .matchExpresses(
                matchExpresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tagKey(tagKey?.applyValue({ args0 -> args0 }))
            .templateIdLists(templateIdLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DynamicTagGroupArgs].
 */
@PulumiTagMarker
public class DynamicTagGroupArgsBuilder internal constructor() {
    private var contactGroupLists: Output<List<String>>? = null

    private var matchExpressFilterRelation: Output<String>? = null

    private var matchExpresses: Output<List<DynamicTagGroupMatchExpressArgs>>? = null

    private var tagKey: Output<String>? = null

    private var templateIdLists: Output<List<String>>? = null

    /**
     * @param value The alert contact groups. The alert notifications of the application group are sent to the alert contacts that belong to the specified alert contact groups.
     */
    @JvmName("rkxvrbxqwcawafrt")
    public suspend fun contactGroupLists(`value`: Output<List<String>>) {
        this.contactGroupLists = value
    }

    @JvmName("slowevktqcxsayds")
    public suspend fun contactGroupLists(vararg values: Output<String>) {
        this.contactGroupLists = Output.all(values.asList())
    }

    /**
     * @param values The alert contact groups. The alert notifications of the application group are sent to the alert contacts that belong to the specified alert contact groups.
     */
    @JvmName("fbtbwfsvrrryqlwu")
    public suspend fun contactGroupLists(values: List<Output<String>>) {
        this.contactGroupLists = Output.all(values)
    }

    /**
     * @param value The relationship between the conditional expressions for the tag values of the cloud resources. Valid values: `and`, `or`.
     */
    @JvmName("ylfnkfhpmufgyahq")
    public suspend fun matchExpressFilterRelation(`value`: Output<String>) {
        this.matchExpressFilterRelation = value
    }

    /**
     * @param value The conditional expressions used to create an application group based on the tag. See `match_express` below.
     */
    @JvmName("uqifyayuuheistnu")
    public suspend fun matchExpresses(`value`: Output<List<DynamicTagGroupMatchExpressArgs>>) {
        this.matchExpresses = value
    }

    @JvmName("fwfwbkseiyysunny")
    public suspend fun matchExpresses(vararg values: Output<DynamicTagGroupMatchExpressArgs>) {
        this.matchExpresses = Output.all(values.asList())
    }

    /**
     * @param values The conditional expressions used to create an application group based on the tag. See `match_express` below.
     */
    @JvmName("alksrenyytflvhqn")
    public suspend fun matchExpresses(values: List<Output<DynamicTagGroupMatchExpressArgs>>) {
        this.matchExpresses = Output.all(values)
    }

    /**
     * @param value The tag keys of the cloud resources.
     */
    @JvmName("jgkdxgvjiapapvxn")
    public suspend fun tagKey(`value`: Output<String>) {
        this.tagKey = value
    }

    /**
     * @param value The IDs of the alert templates.
     */
    @JvmName("benfjrfhpvxrwmev")
    public suspend fun templateIdLists(`value`: Output<List<String>>) {
        this.templateIdLists = value
    }

    @JvmName("mibqbjmmqusyrpdu")
    public suspend fun templateIdLists(vararg values: Output<String>) {
        this.templateIdLists = Output.all(values.asList())
    }

    /**
     * @param values The IDs of the alert templates.
     */
    @JvmName("vqcfofagoequeost")
    public suspend fun templateIdLists(values: List<Output<String>>) {
        this.templateIdLists = Output.all(values)
    }

    /**
     * @param value The alert contact groups. The alert notifications of the application group are sent to the alert contacts that belong to the specified alert contact groups.
     */
    @JvmName("covyyhsbyhvnenys")
    public suspend fun contactGroupLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactGroupLists = mapped
    }

    /**
     * @param values The alert contact groups. The alert notifications of the application group are sent to the alert contacts that belong to the specified alert contact groups.
     */
    @JvmName("iycrcwojutfvmgpj")
    public suspend fun contactGroupLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactGroupLists = mapped
    }

    /**
     * @param value The relationship between the conditional expressions for the tag values of the cloud resources. Valid values: `and`, `or`.
     */
    @JvmName("wmmnajwwsvgvxeyq")
    public suspend fun matchExpressFilterRelation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchExpressFilterRelation = mapped
    }

    /**
     * @param value The conditional expressions used to create an application group based on the tag. See `match_express` below.
     */
    @JvmName("vsrnkjbkkfqvpuoc")
    public suspend fun matchExpresses(`value`: List<DynamicTagGroupMatchExpressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchExpresses = mapped
    }

    /**
     * @param argument The conditional expressions used to create an application group based on the tag. See `match_express` below.
     */
    @JvmName("ygieflchbrftubvp")
    public suspend fun matchExpresses(argument: List<suspend DynamicTagGroupMatchExpressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DynamicTagGroupMatchExpressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchExpresses = mapped
    }

    /**
     * @param argument The conditional expressions used to create an application group based on the tag. See `match_express` below.
     */
    @JvmName("jxmafdbecwcaxeuw")
    public suspend fun matchExpresses(vararg argument: suspend DynamicTagGroupMatchExpressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DynamicTagGroupMatchExpressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchExpresses = mapped
    }

    /**
     * @param argument The conditional expressions used to create an application group based on the tag. See `match_express` below.
     */
    @JvmName("mirnlslkhyjfygup")
    public suspend fun matchExpresses(argument: suspend DynamicTagGroupMatchExpressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DynamicTagGroupMatchExpressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.matchExpresses = mapped
    }

    /**
     * @param values The conditional expressions used to create an application group based on the tag. See `match_express` below.
     */
    @JvmName("hufhjwrckafxwoeq")
    public suspend fun matchExpresses(vararg values: DynamicTagGroupMatchExpressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchExpresses = mapped
    }

    /**
     * @param value The tag keys of the cloud resources.
     */
    @JvmName("bhplgobjkwmgrlgp")
    public suspend fun tagKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKey = mapped
    }

    /**
     * @param value The IDs of the alert templates.
     */
    @JvmName("sbiyjbdyrnymfaor")
    public suspend fun templateIdLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateIdLists = mapped
    }

    /**
     * @param values The IDs of the alert templates.
     */
    @JvmName("xpkjodewmcmphbaw")
    public suspend fun templateIdLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateIdLists = mapped
    }

    internal fun build(): DynamicTagGroupArgs = DynamicTagGroupArgs(
        contactGroupLists = contactGroupLists,
        matchExpressFilterRelation = matchExpressFilterRelation,
        matchExpresses = matchExpresses,
        tagKey = tagKey,
        templateIdLists = templateIdLists,
    )
}
