@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleContactParameter
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleEventPattern
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleFcParameter
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleMnsParameter
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleOpenApiParameter
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleSlsParameter
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleWebhookParameter
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleContactParameter.Companion.toKotlin as eventRuleContactParameterToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleEventPattern.Companion.toKotlin as eventRuleEventPatternToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleFcParameter.Companion.toKotlin as eventRuleFcParameterToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleMnsParameter.Companion.toKotlin as eventRuleMnsParameterToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleOpenApiParameter.Companion.toKotlin as eventRuleOpenApiParameterToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleSlsParameter.Companion.toKotlin as eventRuleSlsParameterToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.EventRuleWebhookParameter.Companion.toKotlin as eventRuleWebhookParameterToKotlin

/**
 * Builder for [EventRule].
 */
@PulumiTagMarker
public class EventRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventRuleArgs = EventRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventRuleArgsBuilder.() -> Unit) {
        val builder = EventRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventRule {
        val builtJavaResource = com.pulumi.alicloud.cms.EventRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventRule(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Event Rule resource.
 * For information about Cloud Monitor Service Event Rule and how to use it, see [What is Event Rule](https://www.alibabacloud.com/help/en/cloudmonitor/latest/puteventrule).
 * > **NOTE:** Available since v1.182.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.cms.MonitorGroup("default", {monitorGroupName: name});
 * const example = new alicloud.cms.EventRule("example", {
 *     ruleName: name,
 *     groupId: _default.id,
 *     silenceTime: 100,
 *     description: name,
 *     status: "ENABLED",
 *     eventPattern: {
 *         product: "ecs",
 *         sqlFilter: "example_value",
 *         nameLists: ["example_value"],
 *         levelLists: ["CRITICAL"],
 *         eventTypeLists: ["StatusNotification"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.cms.MonitorGroup("default", monitor_group_name=name)
 * example = alicloud.cms.EventRule("example",
 *     rule_name=name,
 *     group_id=default.id,
 *     silence_time=100,
 *     description=name,
 *     status="ENABLED",
 *     event_pattern={
 *         "product": "ecs",
 *         "sql_filter": "example_value",
 *         "name_lists": ["example_value"],
 *         "level_lists": ["CRITICAL"],
 *         "event_type_lists": ["StatusNotification"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Cms.MonitorGroup("default", new()
 *     {
 *         MonitorGroupName = name,
 *     });
 *     var example = new AliCloud.Cms.EventRule("example", new()
 *     {
 *         RuleName = name,
 *         GroupId = @default.Id,
 *         SilenceTime = 100,
 *         Description = name,
 *         Status = "ENABLED",
 *         EventPattern = new AliCloud.Cms.Inputs.EventRuleEventPatternArgs
 *         {
 *             Product = "ecs",
 *             SqlFilter = "example_value",
 *             NameLists = new[]
 *             {
 *                 "example_value",
 *             },
 *             LevelLists = new[]
 *             {
 *                 "CRITICAL",
 *             },
 *             EventTypeLists = new[]
 *             {
 *                 "StatusNotification",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewMonitorGroup(ctx, "default", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewEventRule(ctx, "example", &cms.EventRuleArgs{
 * 			RuleName:    pulumi.String(name),
 * 			GroupId:     _default.ID(),
 * 			SilenceTime: pulumi.Int(100),
 * 			Description: pulumi.String(name),
 * 			Status:      pulumi.String("ENABLED"),
 * 			EventPattern: &cms.EventRuleEventPatternArgs{
 * 				Product:   pulumi.String("ecs"),
 * 				SqlFilter: pulumi.String("example_value"),
 * 				NameLists: pulumi.StringArray{
 * 					pulumi.String("example_value"),
 * 				},
 * 				LevelLists: pulumi.StringArray{
 * 					pulumi.String("CRITICAL"),
 * 				},
 * 				EventTypeLists: pulumi.StringArray{
 * 					pulumi.String("StatusNotification"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import com.pulumi.alicloud.cms.EventRule;
 * import com.pulumi.alicloud.cms.EventRuleArgs;
 * import com.pulumi.alicloud.cms.inputs.EventRuleEventPatternArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new MonitorGroup("default", MonitorGroupArgs.builder()
 *             .monitorGroupName(name)
 *             .build());
 *         var example = new EventRule("example", EventRuleArgs.builder()
 *             .ruleName(name)
 *             .groupId(default_.id())
 *             .silenceTime(100)
 *             .description(name)
 *             .status("ENABLED")
 *             .eventPattern(EventRuleEventPatternArgs.builder()
 *                 .product("ecs")
 *                 .sqlFilter("example_value")
 *                 .nameLists("example_value")
 *                 .levelLists("CRITICAL")
 *                 .eventTypeLists("StatusNotification")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:cms:MonitorGroup
 *     properties:
 *       monitorGroupName: ${name}
 *   example:
 *     type: alicloud:cms:EventRule
 *     properties:
 *       ruleName: ${name}
 *       groupId: ${default.id}
 *       silenceTime: 100
 *       description: ${name}
 *       status: ENABLED
 *       eventPattern:
 *         product: ecs
 *         sqlFilter: example_value
 *         nameLists:
 *           - example_value
 *         levelLists:
 *           - CRITICAL
 *         eventTypeLists:
 *           - StatusNotification
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Event Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/eventRule:EventRule example <rule_name>
 * ```
 */
public class EventRule internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.EventRule,
) : KotlinCustomResource(javaResource, EventRuleMapper) {
    /**
     * The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
     */
    public val contactParameters: Output<List<EventRuleContactParameter>>?
        get() = javaResource.contactParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventRuleContactParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The description of the event-triggered alert rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Event mode, used to describe the trigger conditions for this event. See `event_pattern` below.
     */
    public val eventPattern: Output<EventRuleEventPattern>
        get() = javaResource.eventPattern().applyValue({ args0 ->
            args0.let({ args0 ->
                eventRuleEventPatternToKotlin(args0)
            })
        })

    /**
     * The information about the recipients in Function Compute. See `fc_parameters` below.
     */
    public val fcParameters: Output<List<EventRuleFcParameter>>?
        get() = javaResource.fcParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> eventRuleFcParameterToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ID of the application group to which the event-triggered alert rule belongs.
     */
    public val groupId: Output<String>?
        get() = javaResource.groupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The information about the recipients in Message Service (MNS). See `mns_parameters` below.
     */
    public val mnsParameters: Output<List<EventRuleMnsParameter>>?
        get() = javaResource.mnsParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventRuleMnsParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The parameters of API callback notification. See `open_api_parameters` below.
     */
    public val openApiParameters: Output<List<EventRuleOpenApiParameter>>?
        get() = javaResource.openApiParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventRuleOpenApiParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the event-triggered alert rule.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })

    /**
     * The silence time.
     */
    public val silenceTime: Output<Int>?
        get() = javaResource.silenceTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The information about the recipients in Simple Log Service. See `sls_parameters` below.
     */
    public val slsParameters: Output<List<EventRuleSlsParameter>>?
        get() = javaResource.slsParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventRuleSlsParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The status of the resource. Valid values: `ENABLED`, `DISABLED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
     */
    public val webhookParameters: Output<List<EventRuleWebhookParameter>>?
        get() = javaResource.webhookParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventRuleWebhookParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object EventRuleMapper : ResourceMapper<EventRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.EventRule::class == javaResource::class

    override fun map(javaResource: Resource): EventRule = EventRule(
        javaResource as
            com.pulumi.alicloud.cms.EventRule,
    )
}

/**
 * @see [EventRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventRule].
 */
public suspend fun eventRule(name: String, block: suspend EventRuleResourceBuilder.() -> Unit): EventRule {
    val builder = EventRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventRule(name: String): EventRule {
    val builder = EventRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
