@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.EventRuleArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleContactParameterArgs
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleContactParameterArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleEventPatternArgs
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleEventPatternArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleFcParameterArgs
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleFcParameterArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleMnsParameterArgs
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleMnsParameterArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleOpenApiParameterArgs
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleOpenApiParameterArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleSlsParameterArgs
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleSlsParameterArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleWebhookParameterArgs
import com.pulumi.alicloud.cms.kotlin.inputs.EventRuleWebhookParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Event Rule resource.
 * For information about Cloud Monitor Service Event Rule and how to use it, see [What is Event Rule](https://www.alibabacloud.com/help/en/cloudmonitor/latest/puteventrule).
 * > **NOTE:** Available since v1.182.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.cms.MonitorGroup("default", {monitorGroupName: name});
 * const example = new alicloud.cms.EventRule("example", {
 *     ruleName: name,
 *     groupId: _default.id,
 *     silenceTime: 100,
 *     description: name,
 *     status: "ENABLED",
 *     eventPattern: {
 *         product: "ecs",
 *         sqlFilter: "example_value",
 *         nameLists: ["example_value"],
 *         levelLists: ["CRITICAL"],
 *         eventTypeLists: ["StatusNotification"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.cms.MonitorGroup("default", monitor_group_name=name)
 * example = alicloud.cms.EventRule("example",
 *     rule_name=name,
 *     group_id=default.id,
 *     silence_time=100,
 *     description=name,
 *     status="ENABLED",
 *     event_pattern={
 *         "product": "ecs",
 *         "sql_filter": "example_value",
 *         "name_lists": ["example_value"],
 *         "level_lists": ["CRITICAL"],
 *         "event_type_lists": ["StatusNotification"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Cms.MonitorGroup("default", new()
 *     {
 *         MonitorGroupName = name,
 *     });
 *     var example = new AliCloud.Cms.EventRule("example", new()
 *     {
 *         RuleName = name,
 *         GroupId = @default.Id,
 *         SilenceTime = 100,
 *         Description = name,
 *         Status = "ENABLED",
 *         EventPattern = new AliCloud.Cms.Inputs.EventRuleEventPatternArgs
 *         {
 *             Product = "ecs",
 *             SqlFilter = "example_value",
 *             NameLists = new[]
 *             {
 *                 "example_value",
 *             },
 *             LevelLists = new[]
 *             {
 *                 "CRITICAL",
 *             },
 *             EventTypeLists = new[]
 *             {
 *                 "StatusNotification",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewMonitorGroup(ctx, "default", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewEventRule(ctx, "example", &cms.EventRuleArgs{
 * 			RuleName:    pulumi.String(name),
 * 			GroupId:     _default.ID(),
 * 			SilenceTime: pulumi.Int(100),
 * 			Description: pulumi.String(name),
 * 			Status:      pulumi.String("ENABLED"),
 * 			EventPattern: &cms.EventRuleEventPatternArgs{
 * 				Product:   pulumi.String("ecs"),
 * 				SqlFilter: pulumi.String("example_value"),
 * 				NameLists: pulumi.StringArray{
 * 					pulumi.String("example_value"),
 * 				},
 * 				LevelLists: pulumi.StringArray{
 * 					pulumi.String("CRITICAL"),
 * 				},
 * 				EventTypeLists: pulumi.StringArray{
 * 					pulumi.String("StatusNotification"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import com.pulumi.alicloud.cms.EventRule;
 * import com.pulumi.alicloud.cms.EventRuleArgs;
 * import com.pulumi.alicloud.cms.inputs.EventRuleEventPatternArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new MonitorGroup("default", MonitorGroupArgs.builder()
 *             .monitorGroupName(name)
 *             .build());
 *         var example = new EventRule("example", EventRuleArgs.builder()
 *             .ruleName(name)
 *             .groupId(default_.id())
 *             .silenceTime(100)
 *             .description(name)
 *             .status("ENABLED")
 *             .eventPattern(EventRuleEventPatternArgs.builder()
 *                 .product("ecs")
 *                 .sqlFilter("example_value")
 *                 .nameLists("example_value")
 *                 .levelLists("CRITICAL")
 *                 .eventTypeLists("StatusNotification")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:cms:MonitorGroup
 *     properties:
 *       monitorGroupName: ${name}
 *   example:
 *     type: alicloud:cms:EventRule
 *     properties:
 *       ruleName: ${name}
 *       groupId: ${default.id}
 *       silenceTime: 100
 *       description: ${name}
 *       status: ENABLED
 *       eventPattern:
 *         product: ecs
 *         sqlFilter: example_value
 *         nameLists:
 *           - example_value
 *         levelLists:
 *           - CRITICAL
 *         eventTypeLists:
 *           - StatusNotification
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Event Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/eventRule:EventRule example <rule_name>
 * ```
 * @property contactParameters The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
 * @property description The description of the event-triggered alert rule.
 * @property eventPattern Event mode, used to describe the trigger conditions for this event. See `event_pattern` below.
 * @property fcParameters The information about the recipients in Function Compute. See `fc_parameters` below.
 * @property groupId The ID of the application group to which the event-triggered alert rule belongs.
 * @property mnsParameters The information about the recipients in Message Service (MNS). See `mns_parameters` below.
 * @property openApiParameters The parameters of API callback notification. See `open_api_parameters` below.
 * @property ruleName The name of the event-triggered alert rule.
 * @property silenceTime The silence time.
 * @property slsParameters The information about the recipients in Simple Log Service. See `sls_parameters` below.
 * @property status The status of the resource. Valid values: `ENABLED`, `DISABLED`.
 * @property webhookParameters The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
 */
public data class EventRuleArgs(
    public val contactParameters: Output<List<EventRuleContactParameterArgs>>? = null,
    public val description: Output<String>? = null,
    public val eventPattern: Output<EventRuleEventPatternArgs>? = null,
    public val fcParameters: Output<List<EventRuleFcParameterArgs>>? = null,
    public val groupId: Output<String>? = null,
    public val mnsParameters: Output<List<EventRuleMnsParameterArgs>>? = null,
    public val openApiParameters: Output<List<EventRuleOpenApiParameterArgs>>? = null,
    public val ruleName: Output<String>? = null,
    public val silenceTime: Output<Int>? = null,
    public val slsParameters: Output<List<EventRuleSlsParameterArgs>>? = null,
    public val status: Output<String>? = null,
    public val webhookParameters: Output<List<EventRuleWebhookParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.EventRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.EventRuleArgs =
        com.pulumi.alicloud.cms.EventRuleArgs.builder()
            .contactParameters(
                contactParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .eventPattern(eventPattern?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fcParameters(
                fcParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .mnsParameters(
                mnsParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .openApiParameters(
                openApiParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .silenceTime(silenceTime?.applyValue({ args0 -> args0 }))
            .slsParameters(
                slsParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 }))
            .webhookParameters(
                webhookParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventRuleArgs].
 */
@PulumiTagMarker
public class EventRuleArgsBuilder internal constructor() {
    private var contactParameters: Output<List<EventRuleContactParameterArgs>>? = null

    private var description: Output<String>? = null

    private var eventPattern: Output<EventRuleEventPatternArgs>? = null

    private var fcParameters: Output<List<EventRuleFcParameterArgs>>? = null

    private var groupId: Output<String>? = null

    private var mnsParameters: Output<List<EventRuleMnsParameterArgs>>? = null

    private var openApiParameters: Output<List<EventRuleOpenApiParameterArgs>>? = null

    private var ruleName: Output<String>? = null

    private var silenceTime: Output<Int>? = null

    private var slsParameters: Output<List<EventRuleSlsParameterArgs>>? = null

    private var status: Output<String>? = null

    private var webhookParameters: Output<List<EventRuleWebhookParameterArgs>>? = null

    /**
     * @param value The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
     */
    @JvmName("jxsxbbneaoqnqonj")
    public suspend fun contactParameters(`value`: Output<List<EventRuleContactParameterArgs>>) {
        this.contactParameters = value
    }

    @JvmName("mdlycmjybexuffix")
    public suspend fun contactParameters(vararg values: Output<EventRuleContactParameterArgs>) {
        this.contactParameters = Output.all(values.asList())
    }

    /**
     * @param values The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
     */
    @JvmName("vopuejtctjcftcav")
    public suspend fun contactParameters(values: List<Output<EventRuleContactParameterArgs>>) {
        this.contactParameters = Output.all(values)
    }

    /**
     * @param value The description of the event-triggered alert rule.
     */
    @JvmName("hbkqjdwmrjktglpk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Event mode, used to describe the trigger conditions for this event. See `event_pattern` below.
     */
    @JvmName("ivpcmlsgaxdguwiu")
    public suspend fun eventPattern(`value`: Output<EventRuleEventPatternArgs>) {
        this.eventPattern = value
    }

    /**
     * @param value The information about the recipients in Function Compute. See `fc_parameters` below.
     */
    @JvmName("gsuupdqduhgvnloe")
    public suspend fun fcParameters(`value`: Output<List<EventRuleFcParameterArgs>>) {
        this.fcParameters = value
    }

    @JvmName("yrgfckjxfpjvbndg")
    public suspend fun fcParameters(vararg values: Output<EventRuleFcParameterArgs>) {
        this.fcParameters = Output.all(values.asList())
    }

    /**
     * @param values The information about the recipients in Function Compute. See `fc_parameters` below.
     */
    @JvmName("jbrovdlkhhecxiks")
    public suspend fun fcParameters(values: List<Output<EventRuleFcParameterArgs>>) {
        this.fcParameters = Output.all(values)
    }

    /**
     * @param value The ID of the application group to which the event-triggered alert rule belongs.
     */
    @JvmName("lhkujetqpxeqdwgb")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The information about the recipients in Message Service (MNS). See `mns_parameters` below.
     */
    @JvmName("uoqcidymgwdqsyrp")
    public suspend fun mnsParameters(`value`: Output<List<EventRuleMnsParameterArgs>>) {
        this.mnsParameters = value
    }

    @JvmName("uxkatrspwpxhaown")
    public suspend fun mnsParameters(vararg values: Output<EventRuleMnsParameterArgs>) {
        this.mnsParameters = Output.all(values.asList())
    }

    /**
     * @param values The information about the recipients in Message Service (MNS). See `mns_parameters` below.
     */
    @JvmName("lwowcqyletlcjsqf")
    public suspend fun mnsParameters(values: List<Output<EventRuleMnsParameterArgs>>) {
        this.mnsParameters = Output.all(values)
    }

    /**
     * @param value The parameters of API callback notification. See `open_api_parameters` below.
     */
    @JvmName("gvkocxonddanbfhx")
    public suspend fun openApiParameters(`value`: Output<List<EventRuleOpenApiParameterArgs>>) {
        this.openApiParameters = value
    }

    @JvmName("eruimnlmjwvakpco")
    public suspend fun openApiParameters(vararg values: Output<EventRuleOpenApiParameterArgs>) {
        this.openApiParameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters of API callback notification. See `open_api_parameters` below.
     */
    @JvmName("rxettjqjqqrirdrm")
    public suspend fun openApiParameters(values: List<Output<EventRuleOpenApiParameterArgs>>) {
        this.openApiParameters = Output.all(values)
    }

    /**
     * @param value The name of the event-triggered alert rule.
     */
    @JvmName("pmcpgjninnvbcveo")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The silence time.
     */
    @JvmName("clmrrcvseaantwjx")
    public suspend fun silenceTime(`value`: Output<Int>) {
        this.silenceTime = value
    }

    /**
     * @param value The information about the recipients in Simple Log Service. See `sls_parameters` below.
     */
    @JvmName("sfcxtbvbhpqpfgia")
    public suspend fun slsParameters(`value`: Output<List<EventRuleSlsParameterArgs>>) {
        this.slsParameters = value
    }

    @JvmName("sojigblfnvoxdbts")
    public suspend fun slsParameters(vararg values: Output<EventRuleSlsParameterArgs>) {
        this.slsParameters = Output.all(values.asList())
    }

    /**
     * @param values The information about the recipients in Simple Log Service. See `sls_parameters` below.
     */
    @JvmName("dvyloreaqdhphckc")
    public suspend fun slsParameters(values: List<Output<EventRuleSlsParameterArgs>>) {
        this.slsParameters = Output.all(values)
    }

    /**
     * @param value The status of the resource. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("tjitlucnaeoyicwj")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
     */
    @JvmName("tpevyoimaaleiqvl")
    public suspend fun webhookParameters(`value`: Output<List<EventRuleWebhookParameterArgs>>) {
        this.webhookParameters = value
    }

    @JvmName("wwrxeerdkabhdiuv")
    public suspend fun webhookParameters(vararg values: Output<EventRuleWebhookParameterArgs>) {
        this.webhookParameters = Output.all(values.asList())
    }

    /**
     * @param values The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
     */
    @JvmName("nvuvyoawbogwgphw")
    public suspend fun webhookParameters(values: List<Output<EventRuleWebhookParameterArgs>>) {
        this.webhookParameters = Output.all(values)
    }

    /**
     * @param value The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
     */
    @JvmName("qxbstduyjfbbctdb")
    public suspend fun contactParameters(`value`: List<EventRuleContactParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactParameters = mapped
    }

    /**
     * @param argument The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
     */
    @JvmName("acuerrnjktclifqk")
    public suspend fun contactParameters(argument: List<suspend EventRuleContactParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventRuleContactParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.contactParameters = mapped
    }

    /**
     * @param argument The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
     */
    @JvmName("obwugwibdrqlrpia")
    public suspend fun contactParameters(vararg argument: suspend EventRuleContactParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventRuleContactParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.contactParameters = mapped
    }

    /**
     * @param argument The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
     */
    @JvmName("bhnuokhfuoyrrvpc")
    public suspend fun contactParameters(argument: suspend EventRuleContactParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventRuleContactParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.contactParameters = mapped
    }

    /**
     * @param values The information about the alert contact groups that receive alert notifications. See `contact_parameters` below.
     */
    @JvmName("yqalobydxkdlycms")
    public suspend fun contactParameters(vararg values: EventRuleContactParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactParameters = mapped
    }

    /**
     * @param value The description of the event-triggered alert rule.
     */
    @JvmName("knoqphrsxxsrxegj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Event mode, used to describe the trigger conditions for this event. See `event_pattern` below.
     */
    @JvmName("oyckwnrrfmxubort")
    public suspend fun eventPattern(`value`: EventRuleEventPatternArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventPattern = mapped
    }

    /**
     * @param argument Event mode, used to describe the trigger conditions for this event. See `event_pattern` below.
     */
    @JvmName("tteudtgexxxlwhei")
    public suspend fun eventPattern(argument: suspend EventRuleEventPatternArgsBuilder.() -> Unit) {
        val toBeMapped = EventRuleEventPatternArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventPattern = mapped
    }

    /**
     * @param value The information about the recipients in Function Compute. See `fc_parameters` below.
     */
    @JvmName("yutkpolcflpgufvk")
    public suspend fun fcParameters(`value`: List<EventRuleFcParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fcParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Function Compute. See `fc_parameters` below.
     */
    @JvmName("nbvylsldpcdgwfqq")
    public suspend fun fcParameters(argument: List<suspend EventRuleFcParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventRuleFcParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fcParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Function Compute. See `fc_parameters` below.
     */
    @JvmName("bpunudlufqnluhnj")
    public suspend fun fcParameters(vararg argument: suspend EventRuleFcParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventRuleFcParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fcParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Function Compute. See `fc_parameters` below.
     */
    @JvmName("nmycgpkwncbjeyeh")
    public suspend fun fcParameters(argument: suspend EventRuleFcParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventRuleFcParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fcParameters = mapped
    }

    /**
     * @param values The information about the recipients in Function Compute. See `fc_parameters` below.
     */
    @JvmName("syucgbdquyrkpicn")
    public suspend fun fcParameters(vararg values: EventRuleFcParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fcParameters = mapped
    }

    /**
     * @param value The ID of the application group to which the event-triggered alert rule belongs.
     */
    @JvmName("uppxirrwsvyynqbw")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The information about the recipients in Message Service (MNS). See `mns_parameters` below.
     */
    @JvmName("qltrmcyjlofoksnk")
    public suspend fun mnsParameters(`value`: List<EventRuleMnsParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mnsParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Message Service (MNS). See `mns_parameters` below.
     */
    @JvmName("nvqtlqyfuhdwlvhm")
    public suspend fun mnsParameters(argument: List<suspend EventRuleMnsParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventRuleMnsParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mnsParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Message Service (MNS). See `mns_parameters` below.
     */
    @JvmName("rujmliplfucixqyg")
    public suspend fun mnsParameters(vararg argument: suspend EventRuleMnsParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventRuleMnsParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mnsParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Message Service (MNS). See `mns_parameters` below.
     */
    @JvmName("bvgoxblaraaykocg")
    public suspend fun mnsParameters(argument: suspend EventRuleMnsParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventRuleMnsParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mnsParameters = mapped
    }

    /**
     * @param values The information about the recipients in Message Service (MNS). See `mns_parameters` below.
     */
    @JvmName("tultqhyxymetqpvt")
    public suspend fun mnsParameters(vararg values: EventRuleMnsParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mnsParameters = mapped
    }

    /**
     * @param value The parameters of API callback notification. See `open_api_parameters` below.
     */
    @JvmName("ftkjrvqcivscmbhs")
    public suspend fun openApiParameters(`value`: List<EventRuleOpenApiParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openApiParameters = mapped
    }

    /**
     * @param argument The parameters of API callback notification. See `open_api_parameters` below.
     */
    @JvmName("jmqgqllhndutxbyx")
    public suspend fun openApiParameters(argument: List<suspend EventRuleOpenApiParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventRuleOpenApiParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.openApiParameters = mapped
    }

    /**
     * @param argument The parameters of API callback notification. See `open_api_parameters` below.
     */
    @JvmName("mbvwhwwasvrbnvka")
    public suspend fun openApiParameters(vararg argument: suspend EventRuleOpenApiParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventRuleOpenApiParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.openApiParameters = mapped
    }

    /**
     * @param argument The parameters of API callback notification. See `open_api_parameters` below.
     */
    @JvmName("kbmjabslmnrtsvvl")
    public suspend fun openApiParameters(argument: suspend EventRuleOpenApiParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventRuleOpenApiParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.openApiParameters = mapped
    }

    /**
     * @param values The parameters of API callback notification. See `open_api_parameters` below.
     */
    @JvmName("hpcgddjbamrptobw")
    public suspend fun openApiParameters(vararg values: EventRuleOpenApiParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.openApiParameters = mapped
    }

    /**
     * @param value The name of the event-triggered alert rule.
     */
    @JvmName("svdetohuwubusijc")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The silence time.
     */
    @JvmName("plufdfnlrecglwtm")
    public suspend fun silenceTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.silenceTime = mapped
    }

    /**
     * @param value The information about the recipients in Simple Log Service. See `sls_parameters` below.
     */
    @JvmName("flqwanwqyvuvnepd")
    public suspend fun slsParameters(`value`: List<EventRuleSlsParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Simple Log Service. See `sls_parameters` below.
     */
    @JvmName("twiimgfnqofebabn")
    public suspend fun slsParameters(argument: List<suspend EventRuleSlsParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventRuleSlsParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slsParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Simple Log Service. See `sls_parameters` below.
     */
    @JvmName("frqaccwchbvcfpif")
    public suspend fun slsParameters(vararg argument: suspend EventRuleSlsParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventRuleSlsParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slsParameters = mapped
    }

    /**
     * @param argument The information about the recipients in Simple Log Service. See `sls_parameters` below.
     */
    @JvmName("mhtsyhepnexmyeay")
    public suspend fun slsParameters(argument: suspend EventRuleSlsParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventRuleSlsParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.slsParameters = mapped
    }

    /**
     * @param values The information about the recipients in Simple Log Service. See `sls_parameters` below.
     */
    @JvmName("fisrfdnyijwokkos")
    public suspend fun slsParameters(vararg values: EventRuleSlsParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slsParameters = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("nihvfbkefyqbubgl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
     */
    @JvmName("xoltptbpfywyvfgv")
    public suspend fun webhookParameters(`value`: List<EventRuleWebhookParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookParameters = mapped
    }

    /**
     * @param argument The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
     */
    @JvmName("qpchrvfjjjbbqonk")
    public suspend fun webhookParameters(argument: List<suspend EventRuleWebhookParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventRuleWebhookParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhookParameters = mapped
    }

    /**
     * @param argument The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
     */
    @JvmName("dmapjamlxhrbnhdc")
    public suspend fun webhookParameters(vararg argument: suspend EventRuleWebhookParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventRuleWebhookParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhookParameters = mapped
    }

    /**
     * @param argument The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
     */
    @JvmName("njunfmqanjraxrcg")
    public suspend fun webhookParameters(argument: suspend EventRuleWebhookParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventRuleWebhookParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.webhookParameters = mapped
    }

    /**
     * @param values The information about the callback URLs that are used to receive alert notifications. See `webhook_parameters` below.
     */
    @JvmName("rsgqsjvtyerckrry")
    public suspend fun webhookParameters(vararg values: EventRuleWebhookParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhookParameters = mapped
    }

    internal fun build(): EventRuleArgs = EventRuleArgs(
        contactParameters = contactParameters,
        description = description,
        eventPattern = eventPattern,
        fcParameters = fcParameters,
        groupId = groupId,
        mnsParameters = mnsParameters,
        openApiParameters = openApiParameters,
        ruleName = ruleName,
        silenceTime = silenceTime,
        slsParameters = slsParameters,
        status = status,
        webhookParameters = webhookParameters,
    )
}
