@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.GroupMetricRuleEscalations
import com.pulumi.alicloud.cms.kotlin.outputs.GroupMetricRuleTarget
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cms.kotlin.outputs.GroupMetricRuleEscalations.Companion.toKotlin as groupMetricRuleEscalationsToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.GroupMetricRuleTarget.Companion.toKotlin as groupMetricRuleTargetToKotlin

/**
 * Builder for [GroupMetricRule].
 */
@PulumiTagMarker
public class GroupMetricRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupMetricRuleArgs = GroupMetricRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupMetricRuleArgsBuilder.() -> Unit) {
        val builder = GroupMetricRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupMetricRule {
        val builtJavaResource = com.pulumi.alicloud.cms.GroupMetricRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupMetricRule(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Group Metric Rule resource.
 * For information about Cloud Monitor Service Group Metric Rule and how to use it, see [What is Group Metric Rule](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putgroupmetricrule).
 * > **NOTE:** Available since v1.104.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.cms.AlarmContactGroup("default", {
 *     alarmContactGroupName: name,
 *     describe: name,
 * });
 * const defaultMonitorGroup = new alicloud.cms.MonitorGroup("default", {
 *     monitorGroupName: name,
 *     contactGroups: [_default&#46;id],
 * });
 * const _this = new alicloud.cms.GroupMetricRule("this", {
 *     groupId: defaultMonitorGroup.id,
 *     groupMetricRuleName: name,
 *     category: "ecs",
 *     metricName: "cpu_total",
 *     namespace: "acs_ecs_dashboard",
 *     ruleId: name,
 *     period: 60,
 *     interval: "3600",
 *     silenceTime: 85800,
 *     noEffectiveInterval: "00:00-05:30",
 *     webhook: "http://www.aliyun.com",
 *     escalations: {
 *         warn: {
 *             comparisonOperator: "GreaterThanOrEqualToThreshold",
 *             statistics: "Average",
 *             threshold: "90",
 *             times: 3,
 *         },
 *         info: {
 *             comparisonOperator: "LessThanLastWeek",
 *             statistics: "Average",
 *             threshold: "90",
 *             times: 5,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.cms.AlarmContactGroup("default",
 *     alarm_contact_group_name=name,
 *     describe=name)
 * default_monitor_group = alicloud.cms.MonitorGroup("default",
 *     monitor_group_name=name,
 *     contact_groups=[default&#46;id])
 * this = alicloud.cms.GroupMetricRule("this",
 *     group_id=default_monitor_group.id,
 *     group_metric_rule_name=name,
 *     category="ecs",
 *     metric_name="cpu_total",
 *     namespace="acs_ecs_dashboard",
 *     rule_id=name,
 *     period=60,
 *     interval="3600",
 *     silence_time=85800,
 *     no_effective_interval="00:00-05:30",
 *     webhook="http://www.aliyun.com",
 *     escalations={
 *         "warn": {
 *             "comparison_operator": "GreaterThanOrEqualToThreshold",
 *             "statistics": "Average",
 *             "threshold": "90",
 *             "times": 3,
 *         },
 *         "info": {
 *             "comparison_operator": "LessThanLastWeek",
 *             "statistics": "Average",
 *             "threshold": "90",
 *             "times": 5,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *         Describe = name,
 *     });
 *     var defaultMonitorGroup = new AliCloud.Cms.MonitorGroup("default", new()
 *     {
 *         MonitorGroupName = name,
 *         ContactGroups = new[]
 *         {
 *             @default.Id,
 *         },
 *     });
 *     var @this = new AliCloud.Cms.GroupMetricRule("this", new()
 *     {
 *         GroupId = defaultMonitorGroup.Id,
 *         GroupMetricRuleName = name,
 *         Category = "ecs",
 *         MetricName = "cpu_total",
 *         Namespace = "acs_ecs_dashboard",
 *         RuleId = name,
 *         Period = 60,
 *         Interval = "3600",
 *         SilenceTime = 85800,
 *         NoEffectiveInterval = "00:00-05:30",
 *         Webhook = "http://www.aliyun.com",
 *         Escalations = new AliCloud.Cms.Inputs.GroupMetricRuleEscalationsArgs
 *         {
 *             Warn = new AliCloud.Cms.Inputs.GroupMetricRuleEscalationsWarnArgs
 *             {
 *                 ComparisonOperator = "GreaterThanOrEqualToThreshold",
 *                 Statistics = "Average",
 *                 Threshold = "90",
 *                 Times = 3,
 *             },
 *             Info = new AliCloud.Cms.Inputs.GroupMetricRuleEscalationsInfoArgs
 *             {
 *                 ComparisonOperator = "LessThanLastWeek",
 *                 Statistics = "Average",
 *                 Threshold = "90",
 *                 Times = 5,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 			Describe:              pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultMonitorGroup, err := cms.NewMonitorGroup(ctx, "default", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String(name),
 * 			ContactGroups: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewGroupMetricRule(ctx, "this", &cms.GroupMetricRuleArgs{
 * 			GroupId:             defaultMonitorGroup.ID(),
 * 			GroupMetricRuleName: pulumi.String(name),
 * 			Category:            pulumi.String("ecs"),
 * 			MetricName:          pulumi.String("cpu_total"),
 * 			Namespace:           pulumi.String("acs_ecs_dashboard"),
 * 			RuleId:              pulumi.String(name),
 * 			Period:              pulumi.Int(60),
 * 			Interval:            pulumi.String("3600"),
 * 			SilenceTime:         pulumi.Int(85800),
 * 			NoEffectiveInterval: pulumi.String("00:00-05:30"),
 * 			Webhook:             pulumi.String("http://www.aliyun.com"),
 * 			Escalations: &cms.GroupMetricRuleEscalationsArgs{
 * 				Warn: &cms.GroupMetricRuleEscalationsWarnArgs{
 * 					ComparisonOperator: pulumi.String("GreaterThanOrEqualToThreshold"),
 * 					Statistics:         pulumi.String("Average"),
 * 					Threshold:          pulumi.String("90"),
 * 					Times:              pulumi.Int(3),
 * 				},
 * 				Info: &cms.GroupMetricRuleEscalationsInfoArgs{
 * 					ComparisonOperator: pulumi.String("LessThanLastWeek"),
 * 					Statistics:         pulumi.String("Average"),
 * 					Threshold:          pulumi.String("90"),
 * 					Times:              pulumi.Int(5),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import com.pulumi.alicloud.cms.GroupMetricRule;
 * import com.pulumi.alicloud.cms.GroupMetricRuleArgs;
 * import com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsArgs;
 * import com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsWarnArgs;
 * import com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new AlarmContactGroup("default", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .describe(name)
 *             .build());
 *         var defaultMonitorGroup = new MonitorGroup("defaultMonitorGroup", MonitorGroupArgs.builder()
 *             .monitorGroupName(name)
 *             .contactGroups(default_.id())
 *             .build());
 *         var this_ = new GroupMetricRule("this", GroupMetricRuleArgs.builder()
 *             .groupId(defaultMonitorGroup.id())
 *             .groupMetricRuleName(name)
 *             .category("ecs")
 *             .metricName("cpu_total")
 *             .namespace("acs_ecs_dashboard")
 *             .ruleId(name)
 *             .period("60")
 *             .interval("3600")
 *             .silenceTime(85800)
 *             .noEffectiveInterval("00:00-05:30")
 *             .webhook("http://www.aliyun.com")
 *             .escalations(GroupMetricRuleEscalationsArgs.builder()
 *                 .warn(GroupMetricRuleEscalationsWarnArgs.builder()
 *                     .comparisonOperator("GreaterThanOrEqualToThreshold")
 *                     .statistics("Average")
 *                     .threshold("90")
 *                     .times(3)
 *                     .build())
 *                 .info(GroupMetricRuleEscalationsInfoArgs.builder()
 *                     .comparisonOperator("LessThanLastWeek")
 *                     .statistics("Average")
 *                     .threshold("90")
 *                     .times(5)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:cms:AlarmContactGroup
 *     properties:
 *       alarmContactGroupName: ${name}
 *       describe: ${name}
 *   defaultMonitorGroup:
 *     type: alicloud:cms:MonitorGroup
 *     name: default
 *     properties:
 *       monitorGroupName: ${name}
 *       contactGroups:
 *         - ${default.id}
 *   this:
 *     type: alicloud:cms:GroupMetricRule
 *     properties:
 *       groupId: ${defaultMonitorGroup.id}
 *       groupMetricRuleName: ${name}
 *       category: ecs
 *       metricName: cpu_total
 *       namespace: acs_ecs_dashboard
 *       ruleId: ${name}
 *       period: '60'
 *       interval: '3600'
 *       silenceTime: 85800
 *       noEffectiveInterval: 00:00-05:30
 *       webhook: http://www.aliyun.com
 *       escalations:
 *         warn:
 *           comparisonOperator: GreaterThanOrEqualToThreshold
 *           statistics: Average
 *           threshold: '90'
 *           times: 3
 *         info:
 *           comparisonOperator: LessThanLastWeek
 *           statistics: Average
 *           threshold: '90'
 *           times: 5
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Group Metric Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/groupMetricRule:GroupMetricRule example <rule_id>
 * ```
 */
public class GroupMetricRule internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.GroupMetricRule,
) : KotlinCustomResource(javaResource, GroupMetricRuleMapper) {
    /**
     * The abbreviation of the service name.
     */
    public val category: Output<String>?
        get() = javaResource.category().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Alarm contact group.
     */
    public val contactGroups: Output<String>
        get() = javaResource.contactGroups().applyValue({ args0 -> args0 })

    /**
     * The dimensions that specify the resources to be associated with the alert rule.
     */
    public val dimensions: Output<String>
        get() = javaResource.dimensions().applyValue({ args0 -> args0 })

    /**
     * The time period during which the alert rule is effective.
     */
    public val effectiveInterval: Output<String>?
        get() = javaResource.effectiveInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subject of the alert notification email.
     */
    public val emailSubject: Output<String>
        get() = javaResource.emailSubject().applyValue({ args0 -> args0 })

    /**
     * Alarm level. See `escalations` below.
     */
    public val escalations: Output<GroupMetricRuleEscalations>
        get() = javaResource.escalations().applyValue({ args0 ->
            args0.let({ args0 ->
                groupMetricRuleEscalationsToKotlin(args0)
            })
        })

    /**
     * The ID of the application group.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The name of the alert rule.
     */
    public val groupMetricRuleName: Output<String>
        get() = javaResource.groupMetricRuleName().applyValue({ args0 -> args0 })

    /**
     * The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
     */
    public val interval: Output<String>?
        get() = javaResource.interval().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the metric.
     */
    public val metricName: Output<String>
        get() = javaResource.metricName().applyValue({ args0 -> args0 })

    /**
     * The namespace of the service.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * The time period during which the alert rule is ineffective.
     */
    public val noEffectiveInterval: Output<String>?
        get() = javaResource.noEffectiveInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The ID of the alert rule.
     */
    public val ruleId: Output<String>
        get() = javaResource.ruleId().applyValue({ args0 -> args0 })

    /**
     * The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
     */
    public val silenceTime: Output<Int>
        get() = javaResource.silenceTime().applyValue({ args0 -> args0 })

    /**
     * The status of Group Metric Rule.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The information about the resource for which alerts are triggered. See `targets` below.
     */
    public val targets: Output<List<GroupMetricRuleTarget>>
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    groupMetricRuleTargetToKotlin(args0)
                })
            })
        })

    /**
     * The callback URL.
     */
    public val webhook: Output<String>?
        get() = javaResource.webhook().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object GroupMetricRuleMapper : ResourceMapper<GroupMetricRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.GroupMetricRule::class == javaResource::class

    override fun map(javaResource: Resource): GroupMetricRule = GroupMetricRule(
        javaResource as
            com.pulumi.alicloud.cms.GroupMetricRule,
    )
}

/**
 * @see [GroupMetricRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupMetricRule].
 */
public suspend fun groupMetricRule(
    name: String,
    block: suspend GroupMetricRuleResourceBuilder.() -> Unit,
): GroupMetricRule {
    val builder = GroupMetricRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupMetricRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupMetricRule(name: String): GroupMetricRule {
    val builder = GroupMetricRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
