@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.GroupMetricRuleArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.GroupMetricRuleEscalationsArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GroupMetricRuleEscalationsArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.GroupMetricRuleTargetArgs
import com.pulumi.alicloud.cms.kotlin.inputs.GroupMetricRuleTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Group Metric Rule resource.
 * For information about Cloud Monitor Service Group Metric Rule and how to use it, see [What is Group Metric Rule](https://www.alibabacloud.com/help/en/cloudmonitor/latest/putgroupmetricrule).
 * > **NOTE:** Available since v1.104.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.cms.AlarmContactGroup("default", {
 *     alarmContactGroupName: name,
 *     describe: name,
 * });
 * const defaultMonitorGroup = new alicloud.cms.MonitorGroup("default", {
 *     monitorGroupName: name,
 *     contactGroups: [_default&#46;id],
 * });
 * const _this = new alicloud.cms.GroupMetricRule("this", {
 *     groupId: defaultMonitorGroup.id,
 *     groupMetricRuleName: name,
 *     category: "ecs",
 *     metricName: "cpu_total",
 *     namespace: "acs_ecs_dashboard",
 *     ruleId: name,
 *     period: 60,
 *     interval: "3600",
 *     silenceTime: 85800,
 *     noEffectiveInterval: "00:00-05:30",
 *     webhook: "http://www.aliyun.com",
 *     escalations: {
 *         warn: {
 *             comparisonOperator: "GreaterThanOrEqualToThreshold",
 *             statistics: "Average",
 *             threshold: "90",
 *             times: 3,
 *         },
 *         info: {
 *             comparisonOperator: "LessThanLastWeek",
 *             statistics: "Average",
 *             threshold: "90",
 *             times: 5,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.cms.AlarmContactGroup("default",
 *     alarm_contact_group_name=name,
 *     describe=name)
 * default_monitor_group = alicloud.cms.MonitorGroup("default",
 *     monitor_group_name=name,
 *     contact_groups=[default&#46;id])
 * this = alicloud.cms.GroupMetricRule("this",
 *     group_id=default_monitor_group.id,
 *     group_metric_rule_name=name,
 *     category="ecs",
 *     metric_name="cpu_total",
 *     namespace="acs_ecs_dashboard",
 *     rule_id=name,
 *     period=60,
 *     interval="3600",
 *     silence_time=85800,
 *     no_effective_interval="00:00-05:30",
 *     webhook="http://www.aliyun.com",
 *     escalations={
 *         "warn": {
 *             "comparison_operator": "GreaterThanOrEqualToThreshold",
 *             "statistics": "Average",
 *             "threshold": "90",
 *             "times": 3,
 *         },
 *         "info": {
 *             "comparison_operator": "LessThanLastWeek",
 *             "statistics": "Average",
 *             "threshold": "90",
 *             "times": 5,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *         Describe = name,
 *     });
 *     var defaultMonitorGroup = new AliCloud.Cms.MonitorGroup("default", new()
 *     {
 *         MonitorGroupName = name,
 *         ContactGroups = new[]
 *         {
 *             @default.Id,
 *         },
 *     });
 *     var @this = new AliCloud.Cms.GroupMetricRule("this", new()
 *     {
 *         GroupId = defaultMonitorGroup.Id,
 *         GroupMetricRuleName = name,
 *         Category = "ecs",
 *         MetricName = "cpu_total",
 *         Namespace = "acs_ecs_dashboard",
 *         RuleId = name,
 *         Period = 60,
 *         Interval = "3600",
 *         SilenceTime = 85800,
 *         NoEffectiveInterval = "00:00-05:30",
 *         Webhook = "http://www.aliyun.com",
 *         Escalations = new AliCloud.Cms.Inputs.GroupMetricRuleEscalationsArgs
 *         {
 *             Warn = new AliCloud.Cms.Inputs.GroupMetricRuleEscalationsWarnArgs
 *             {
 *                 ComparisonOperator = "GreaterThanOrEqualToThreshold",
 *                 Statistics = "Average",
 *                 Threshold = "90",
 *                 Times = 3,
 *             },
 *             Info = new AliCloud.Cms.Inputs.GroupMetricRuleEscalationsInfoArgs
 *             {
 *                 ComparisonOperator = "LessThanLastWeek",
 *                 Statistics = "Average",
 *                 Threshold = "90",
 *                 Times = 5,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 			Describe:              pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultMonitorGroup, err := cms.NewMonitorGroup(ctx, "default", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String(name),
 * 			ContactGroups: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewGroupMetricRule(ctx, "this", &cms.GroupMetricRuleArgs{
 * 			GroupId:             defaultMonitorGroup.ID(),
 * 			GroupMetricRuleName: pulumi.String(name),
 * 			Category:            pulumi.String("ecs"),
 * 			MetricName:          pulumi.String("cpu_total"),
 * 			Namespace:           pulumi.String("acs_ecs_dashboard"),
 * 			RuleId:              pulumi.String(name),
 * 			Period:              pulumi.Int(60),
 * 			Interval:            pulumi.String("3600"),
 * 			SilenceTime:         pulumi.Int(85800),
 * 			NoEffectiveInterval: pulumi.String("00:00-05:30"),
 * 			Webhook:             pulumi.String("http://www.aliyun.com"),
 * 			Escalations: &cms.GroupMetricRuleEscalationsArgs{
 * 				Warn: &cms.GroupMetricRuleEscalationsWarnArgs{
 * 					ComparisonOperator: pulumi.String("GreaterThanOrEqualToThreshold"),
 * 					Statistics:         pulumi.String("Average"),
 * 					Threshold:          pulumi.String("90"),
 * 					Times:              pulumi.Int(3),
 * 				},
 * 				Info: &cms.GroupMetricRuleEscalationsInfoArgs{
 * 					ComparisonOperator: pulumi.String("LessThanLastWeek"),
 * 					Statistics:         pulumi.String("Average"),
 * 					Threshold:          pulumi.String("90"),
 * 					Times:              pulumi.Int(5),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import com.pulumi.alicloud.cms.GroupMetricRule;
 * import com.pulumi.alicloud.cms.GroupMetricRuleArgs;
 * import com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsArgs;
 * import com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsWarnArgs;
 * import com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new AlarmContactGroup("default", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .describe(name)
 *             .build());
 *         var defaultMonitorGroup = new MonitorGroup("defaultMonitorGroup", MonitorGroupArgs.builder()
 *             .monitorGroupName(name)
 *             .contactGroups(default_.id())
 *             .build());
 *         var this_ = new GroupMetricRule("this", GroupMetricRuleArgs.builder()
 *             .groupId(defaultMonitorGroup.id())
 *             .groupMetricRuleName(name)
 *             .category("ecs")
 *             .metricName("cpu_total")
 *             .namespace("acs_ecs_dashboard")
 *             .ruleId(name)
 *             .period("60")
 *             .interval("3600")
 *             .silenceTime(85800)
 *             .noEffectiveInterval("00:00-05:30")
 *             .webhook("http://www.aliyun.com")
 *             .escalations(GroupMetricRuleEscalationsArgs.builder()
 *                 .warn(GroupMetricRuleEscalationsWarnArgs.builder()
 *                     .comparisonOperator("GreaterThanOrEqualToThreshold")
 *                     .statistics("Average")
 *                     .threshold("90")
 *                     .times(3)
 *                     .build())
 *                 .info(GroupMetricRuleEscalationsInfoArgs.builder()
 *                     .comparisonOperator("LessThanLastWeek")
 *                     .statistics("Average")
 *                     .threshold("90")
 *                     .times(5)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:cms:AlarmContactGroup
 *     properties:
 *       alarmContactGroupName: ${name}
 *       describe: ${name}
 *   defaultMonitorGroup:
 *     type: alicloud:cms:MonitorGroup
 *     name: default
 *     properties:
 *       monitorGroupName: ${name}
 *       contactGroups:
 *         - ${default.id}
 *   this:
 *     type: alicloud:cms:GroupMetricRule
 *     properties:
 *       groupId: ${defaultMonitorGroup.id}
 *       groupMetricRuleName: ${name}
 *       category: ecs
 *       metricName: cpu_total
 *       namespace: acs_ecs_dashboard
 *       ruleId: ${name}
 *       period: '60'
 *       interval: '3600'
 *       silenceTime: 85800
 *       noEffectiveInterval: 00:00-05:30
 *       webhook: http://www.aliyun.com
 *       escalations:
 *         warn:
 *           comparisonOperator: GreaterThanOrEqualToThreshold
 *           statistics: Average
 *           threshold: '90'
 *           times: 3
 *         info:
 *           comparisonOperator: LessThanLastWeek
 *           statistics: Average
 *           threshold: '90'
 *           times: 5
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Group Metric Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/groupMetricRule:GroupMetricRule example <rule_id>
 * ```
 * @property category The abbreviation of the service name.
 * @property contactGroups Alarm contact group.
 * @property dimensions The dimensions that specify the resources to be associated with the alert rule.
 * @property effectiveInterval The time period during which the alert rule is effective.
 * @property emailSubject The subject of the alert notification email.
 * @property escalations Alarm level. See `escalations` below.
 * @property groupId The ID of the application group.
 * @property groupMetricRuleName The name of the alert rule.
 * @property interval The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
 * @property metricName The name of the metric.
 * @property namespace The namespace of the service.
 * @property noEffectiveInterval The time period during which the alert rule is ineffective.
 * @property period The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
 * @property ruleId The ID of the alert rule.
 * @property silenceTime The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
 * @property targets The information about the resource for which alerts are triggered. See `targets` below.
 * @property webhook The callback URL.
 */
public data class GroupMetricRuleArgs(
    public val category: Output<String>? = null,
    public val contactGroups: Output<String>? = null,
    public val dimensions: Output<String>? = null,
    public val effectiveInterval: Output<String>? = null,
    public val emailSubject: Output<String>? = null,
    public val escalations: Output<GroupMetricRuleEscalationsArgs>? = null,
    public val groupId: Output<String>? = null,
    public val groupMetricRuleName: Output<String>? = null,
    public val interval: Output<String>? = null,
    public val metricName: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val noEffectiveInterval: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val ruleId: Output<String>? = null,
    public val silenceTime: Output<Int>? = null,
    public val targets: Output<List<GroupMetricRuleTargetArgs>>? = null,
    public val webhook: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.GroupMetricRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.GroupMetricRuleArgs =
        com.pulumi.alicloud.cms.GroupMetricRuleArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .contactGroups(contactGroups?.applyValue({ args0 -> args0 }))
            .dimensions(dimensions?.applyValue({ args0 -> args0 }))
            .effectiveInterval(effectiveInterval?.applyValue({ args0 -> args0 }))
            .emailSubject(emailSubject?.applyValue({ args0 -> args0 }))
            .escalations(escalations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .groupMetricRuleName(groupMetricRuleName?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .noEffectiveInterval(noEffectiveInterval?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .silenceTime(silenceTime?.applyValue({ args0 -> args0 }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .webhook(webhook?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMetricRuleArgs].
 */
@PulumiTagMarker
public class GroupMetricRuleArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var contactGroups: Output<String>? = null

    private var dimensions: Output<String>? = null

    private var effectiveInterval: Output<String>? = null

    private var emailSubject: Output<String>? = null

    private var escalations: Output<GroupMetricRuleEscalationsArgs>? = null

    private var groupId: Output<String>? = null

    private var groupMetricRuleName: Output<String>? = null

    private var interval: Output<String>? = null

    private var metricName: Output<String>? = null

    private var namespace: Output<String>? = null

    private var noEffectiveInterval: Output<String>? = null

    private var period: Output<Int>? = null

    private var ruleId: Output<String>? = null

    private var silenceTime: Output<Int>? = null

    private var targets: Output<List<GroupMetricRuleTargetArgs>>? = null

    private var webhook: Output<String>? = null

    /**
     * @param value The abbreviation of the service name.
     */
    @JvmName("ogkednxlnrkmkpjd")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Alarm contact group.
     */
    @JvmName("sopuvdtafxjqnhrj")
    public suspend fun contactGroups(`value`: Output<String>) {
        this.contactGroups = value
    }

    /**
     * @param value The dimensions that specify the resources to be associated with the alert rule.
     */
    @JvmName("qqvavklsktecfrfh")
    public suspend fun dimensions(`value`: Output<String>) {
        this.dimensions = value
    }

    /**
     * @param value The time period during which the alert rule is effective.
     */
    @JvmName("skdaufjgkmtracij")
    public suspend fun effectiveInterval(`value`: Output<String>) {
        this.effectiveInterval = value
    }

    /**
     * @param value The subject of the alert notification email.
     */
    @JvmName("irbwcjincbkbqhhh")
    public suspend fun emailSubject(`value`: Output<String>) {
        this.emailSubject = value
    }

    /**
     * @param value Alarm level. See `escalations` below.
     */
    @JvmName("wlhngxeghvnqrrcv")
    public suspend fun escalations(`value`: Output<GroupMetricRuleEscalationsArgs>) {
        this.escalations = value
    }

    /**
     * @param value The ID of the application group.
     */
    @JvmName("jhdtykupylbhupvq")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("jucovcxujnoxcnwl")
    public suspend fun groupMetricRuleName(`value`: Output<String>) {
        this.groupMetricRuleName = value
    }

    /**
     * @param value The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
     */
    @JvmName("kdrcuebnculqwekk")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value The name of the metric.
     */
    @JvmName("dtojbweptechiypv")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The namespace of the service.
     */
    @JvmName("wfnrkkesjxtntxjc")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The time period during which the alert rule is ineffective.
     */
    @JvmName("cylgtpvodyccosnn")
    public suspend fun noEffectiveInterval(`value`: Output<String>) {
        this.noEffectiveInterval = value
    }

    /**
     * @param value The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
     */
    @JvmName("ymtcdugcxjtvacag")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The ID of the alert rule.
     */
    @JvmName("wkgiyionnmosyokl")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
     */
    @JvmName("jpevvxvviodlhhch")
    public suspend fun silenceTime(`value`: Output<Int>) {
        this.silenceTime = value
    }

    /**
     * @param value The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("rqcrdnfjdywrflfb")
    public suspend fun targets(`value`: Output<List<GroupMetricRuleTargetArgs>>) {
        this.targets = value
    }

    @JvmName("aehklaxogekdypst")
    public suspend fun targets(vararg values: Output<GroupMetricRuleTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("rxhsqbehihegvnvs")
    public suspend fun targets(values: List<Output<GroupMetricRuleTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The callback URL.
     */
    @JvmName("xbroimebbvrdonht")
    public suspend fun webhook(`value`: Output<String>) {
        this.webhook = value
    }

    /**
     * @param value The abbreviation of the service name.
     */
    @JvmName("anoqrcuvbmcffwbd")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Alarm contact group.
     */
    @JvmName("vuqaudbkbpegkiyg")
    public suspend fun contactGroups(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param value The dimensions that specify the resources to be associated with the alert rule.
     */
    @JvmName("suviehpsaefavapb")
    public suspend fun dimensions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The time period during which the alert rule is effective.
     */
    @JvmName("guvagqouyfufdiwi")
    public suspend fun effectiveInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveInterval = mapped
    }

    /**
     * @param value The subject of the alert notification email.
     */
    @JvmName("axmirbbvbmqdclck")
    public suspend fun emailSubject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailSubject = mapped
    }

    /**
     * @param value Alarm level. See `escalations` below.
     */
    @JvmName("jwymsenhhogfqsfp")
    public suspend fun escalations(`value`: GroupMetricRuleEscalationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.escalations = mapped
    }

    /**
     * @param argument Alarm level. See `escalations` below.
     */
    @JvmName("wkctruwedxltmkxe")
    public suspend fun escalations(argument: suspend GroupMetricRuleEscalationsArgsBuilder.() -> Unit) {
        val toBeMapped = GroupMetricRuleEscalationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.escalations = mapped
    }

    /**
     * @param value The ID of the application group.
     */
    @JvmName("ayjvxdrwaoptyuxb")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("gdttbpdyvpnhfffr")
    public suspend fun groupMetricRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupMetricRuleName = mapped
    }

    /**
     * @param value The interval at which Cloud Monitor checks whether the alert rule is triggered. Unit: seconds.
     */
    @JvmName("dupilboifbrlvkip")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The name of the metric.
     */
    @JvmName("fijyfocijocwflwv")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The namespace of the service.
     */
    @JvmName("xibqfacuedhgbsve")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The time period during which the alert rule is ineffective.
     */
    @JvmName("tdbneavimwxdsnni")
    public suspend fun noEffectiveInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noEffectiveInterval = mapped
    }

    /**
     * @param value The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
     */
    @JvmName("norddssrynfjlrfk")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The ID of the alert rule.
     */
    @JvmName("edrdndkmeoicvdhe")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
     */
    @JvmName("mflpryqwxoegxmmb")
    public suspend fun silenceTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.silenceTime = mapped
    }

    /**
     * @param value The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("sdkiatprkaiofjdk")
    public suspend fun targets(`value`: List<GroupMetricRuleTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("nomfwwnllumpnbbi")
    public suspend fun targets(argument: List<suspend GroupMetricRuleTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupMetricRuleTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("gbxuhjnmiwjvelqa")
    public suspend fun targets(vararg argument: suspend GroupMetricRuleTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GroupMetricRuleTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("iobtwiykxywqmvil")
    public suspend fun targets(argument: suspend GroupMetricRuleTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupMetricRuleTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values The information about the resource for which alerts are triggered. See `targets` below.
     */
    @JvmName("dfoqoqfmhdsvffyt")
    public suspend fun targets(vararg values: GroupMetricRuleTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param value The callback URL.
     */
    @JvmName("bcytlwmwiyrknyqa")
    public suspend fun webhook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhook = mapped
    }

    internal fun build(): GroupMetricRuleArgs = GroupMetricRuleArgs(
        category = category,
        contactGroups = contactGroups,
        dimensions = dimensions,
        effectiveInterval = effectiveInterval,
        emailSubject = emailSubject,
        escalations = escalations,
        groupId = groupId,
        groupMetricRuleName = groupMetricRuleName,
        interval = interval,
        metricName = metricName,
        namespace = namespace,
        noEffectiveInterval = noEffectiveInterval,
        period = period,
        ruleId = ruleId,
        silenceTime = silenceTime,
        targets = targets,
        webhook = webhook,
    )
}
