@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.HybridMonitorSlsTaskAttachLabel
import com.pulumi.alicloud.cms.kotlin.outputs.HybridMonitorSlsTaskSlsProcessConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cms.kotlin.outputs.HybridMonitorSlsTaskAttachLabel.Companion.toKotlin as hybridMonitorSlsTaskAttachLabelToKotlin
import com.pulumi.alicloud.cms.kotlin.outputs.HybridMonitorSlsTaskSlsProcessConfig.Companion.toKotlin as hybridMonitorSlsTaskSlsProcessConfigToKotlin

/**
 * Builder for [HybridMonitorSlsTask].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HybridMonitorSlsTaskArgs = HybridMonitorSlsTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HybridMonitorSlsTaskArgsBuilder.() -> Unit) {
        val builder = HybridMonitorSlsTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HybridMonitorSlsTask {
        val builtJavaResource = com.pulumi.alicloud.cms.HybridMonitorSlsTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HybridMonitorSlsTask(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Hybrid Monitor Sls Task resource.
 * For information about Cloud Monitor Service Hybrid Monitor Sls Task and how to use it, see [What is Hybrid Monitor Sls Task](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createhybridmonitortask).
 * > **NOTE:** Available since v1.179.0.
 * ## Import
 * Cloud Monitor Service Hybrid Monitor Sls Task can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/hybridMonitorSlsTask:HybridMonitorSlsTask example <id>
 * ```
 */
public class HybridMonitorSlsTask internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.HybridMonitorSlsTask,
) : KotlinCustomResource(javaResource, HybridMonitorSlsTaskMapper) {
    /**
     * The label of the monitoring task. See `attach_labels` below.
     */
    public val attachLabels: Output<List<HybridMonitorSlsTaskAttachLabel>>?
        get() = javaResource.attachLabels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> hybridMonitorSlsTaskAttachLabelToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The interval at which metrics are collected. Valid values: `15`, `60`(default value). Unit: seconds.
     */
    public val collectInterval: Output<Int>
        get() = javaResource.collectInterval().applyValue({ args0 -> args0 })

    /**
     * The type of the collection target, enter the name of the Logstore group.
     */
    public val collectTargetType: Output<String>
        get() = javaResource.collectTargetType().applyValue({ args0 -> args0 })

    /**
     * The description of the metric import task.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the namespace.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * The configurations of the logs that are imported from Log Service. See `sls_process_config` below.
     */
    public val slsProcessConfig: Output<HybridMonitorSlsTaskSlsProcessConfig>
        get() = javaResource.slsProcessConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                hybridMonitorSlsTaskSlsProcessConfigToKotlin(args0)
            })
        })

    /**
     * The name of the metric import task, enter the name of the metric for logs imported from Log Service.
     */
    public val taskName: Output<String>
        get() = javaResource.taskName().applyValue({ args0 -> args0 })
}

public object HybridMonitorSlsTaskMapper : ResourceMapper<HybridMonitorSlsTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.HybridMonitorSlsTask::class == javaResource::class

    override fun map(javaResource: Resource): HybridMonitorSlsTask = HybridMonitorSlsTask(
        javaResource
            as com.pulumi.alicloud.cms.HybridMonitorSlsTask,
    )
}

/**
 * @see [HybridMonitorSlsTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HybridMonitorSlsTask].
 */
public suspend fun hybridMonitorSlsTask(
    name: String,
    block: suspend HybridMonitorSlsTaskResourceBuilder.() -> Unit,
): HybridMonitorSlsTask {
    val builder = HybridMonitorSlsTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HybridMonitorSlsTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hybridMonitorSlsTask(name: String): HybridMonitorSlsTask {
    val builder = HybridMonitorSlsTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
