@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.HybridMonitorSlsTaskArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.HybridMonitorSlsTaskAttachLabelArgs
import com.pulumi.alicloud.cms.kotlin.inputs.HybridMonitorSlsTaskAttachLabelArgsBuilder
import com.pulumi.alicloud.cms.kotlin.inputs.HybridMonitorSlsTaskSlsProcessConfigArgs
import com.pulumi.alicloud.cms.kotlin.inputs.HybridMonitorSlsTaskSlsProcessConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Hybrid Monitor Sls Task resource.
 * For information about Cloud Monitor Service Hybrid Monitor Sls Task and how to use it, see [What is Hybrid Monitor Sls Task](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createhybridmonitortask).
 * > **NOTE:** Available since v1.179.0.
 * ## Import
 * Cloud Monitor Service Hybrid Monitor Sls Task can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/hybridMonitorSlsTask:HybridMonitorSlsTask example <id>
 * ```
 * @property attachLabels The label of the monitoring task. See `attach_labels` below.
 * @property collectInterval The interval at which metrics are collected. Valid values: `15`, `60`(default value). Unit: seconds.
 * @property collectTargetType The type of the collection target, enter the name of the Logstore group.
 * @property description The description of the metric import task.
 * @property namespace The name of the namespace.
 * @property slsProcessConfig The configurations of the logs that are imported from Log Service. See `sls_process_config` below.
 * @property taskName The name of the metric import task, enter the name of the metric for logs imported from Log Service.
 */
public data class HybridMonitorSlsTaskArgs(
    public val attachLabels: Output<List<HybridMonitorSlsTaskAttachLabelArgs>>? = null,
    public val collectInterval: Output<Int>? = null,
    public val collectTargetType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val slsProcessConfig: Output<HybridMonitorSlsTaskSlsProcessConfigArgs>? = null,
    public val taskName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.HybridMonitorSlsTaskArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.HybridMonitorSlsTaskArgs =
        com.pulumi.alicloud.cms.HybridMonitorSlsTaskArgs.builder()
            .attachLabels(
                attachLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .collectInterval(collectInterval?.applyValue({ args0 -> args0 }))
            .collectTargetType(collectTargetType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .slsProcessConfig(slsProcessConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskName(taskName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridMonitorSlsTaskArgs].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskArgsBuilder internal constructor() {
    private var attachLabels: Output<List<HybridMonitorSlsTaskAttachLabelArgs>>? = null

    private var collectInterval: Output<Int>? = null

    private var collectTargetType: Output<String>? = null

    private var description: Output<String>? = null

    private var namespace: Output<String>? = null

    private var slsProcessConfig: Output<HybridMonitorSlsTaskSlsProcessConfigArgs>? = null

    private var taskName: Output<String>? = null

    /**
     * @param value The label of the monitoring task. See `attach_labels` below.
     */
    @JvmName("tvtkaptehtdpileb")
    public suspend fun attachLabels(`value`: Output<List<HybridMonitorSlsTaskAttachLabelArgs>>) {
        this.attachLabels = value
    }

    @JvmName("nubugkqoxrippjts")
    public suspend fun attachLabels(vararg values: Output<HybridMonitorSlsTaskAttachLabelArgs>) {
        this.attachLabels = Output.all(values.asList())
    }

    /**
     * @param values The label of the monitoring task. See `attach_labels` below.
     */
    @JvmName("dovlaksacutuochp")
    public suspend fun attachLabels(values: List<Output<HybridMonitorSlsTaskAttachLabelArgs>>) {
        this.attachLabels = Output.all(values)
    }

    /**
     * @param value The interval at which metrics are collected. Valid values: `15`, `60`(default value). Unit: seconds.
     */
    @JvmName("hhgxwqqtmtvhqdie")
    public suspend fun collectInterval(`value`: Output<Int>) {
        this.collectInterval = value
    }

    /**
     * @param value The type of the collection target, enter the name of the Logstore group.
     */
    @JvmName("jjwafixbyaglfjpk")
    public suspend fun collectTargetType(`value`: Output<String>) {
        this.collectTargetType = value
    }

    /**
     * @param value The description of the metric import task.
     */
    @JvmName("ypwcqmuwiihhgkmp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("tpwvdmwnsjcubicf")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The configurations of the logs that are imported from Log Service. See `sls_process_config` below.
     */
    @JvmName("vbgbwnrigxogryhr")
    public suspend fun slsProcessConfig(`value`: Output<HybridMonitorSlsTaskSlsProcessConfigArgs>) {
        this.slsProcessConfig = value
    }

    /**
     * @param value The name of the metric import task, enter the name of the metric for logs imported from Log Service.
     */
    @JvmName("sjloytsdkmicudhu")
    public suspend fun taskName(`value`: Output<String>) {
        this.taskName = value
    }

    /**
     * @param value The label of the monitoring task. See `attach_labels` below.
     */
    @JvmName("veqnawnurewljope")
    public suspend fun attachLabels(`value`: List<HybridMonitorSlsTaskAttachLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachLabels = mapped
    }

    /**
     * @param argument The label of the monitoring task. See `attach_labels` below.
     */
    @JvmName("stcnrvjcybgxgpem")
    public suspend fun attachLabels(argument: List<suspend HybridMonitorSlsTaskAttachLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskAttachLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attachLabels = mapped
    }

    /**
     * @param argument The label of the monitoring task. See `attach_labels` below.
     */
    @JvmName("bmiwmtjninslhime")
    public suspend fun attachLabels(vararg argument: suspend HybridMonitorSlsTaskAttachLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskAttachLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attachLabels = mapped
    }

    /**
     * @param argument The label of the monitoring task. See `attach_labels` below.
     */
    @JvmName("mnjmphbakldoufgc")
    public suspend fun attachLabels(argument: suspend HybridMonitorSlsTaskAttachLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HybridMonitorSlsTaskAttachLabelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.attachLabels = mapped
    }

    /**
     * @param values The label of the monitoring task. See `attach_labels` below.
     */
    @JvmName("dxprjexxmdmegelv")
    public suspend fun attachLabels(vararg values: HybridMonitorSlsTaskAttachLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attachLabels = mapped
    }

    /**
     * @param value The interval at which metrics are collected. Valid values: `15`, `60`(default value). Unit: seconds.
     */
    @JvmName("qfkwtmuhsdhmltvn")
    public suspend fun collectInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectInterval = mapped
    }

    /**
     * @param value The type of the collection target, enter the name of the Logstore group.
     */
    @JvmName("bjywgjkduvcvvjgk")
    public suspend fun collectTargetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectTargetType = mapped
    }

    /**
     * @param value The description of the metric import task.
     */
    @JvmName("pfkbffwegmibphoe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("lhwhftygnxkbgklk")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The configurations of the logs that are imported from Log Service. See `sls_process_config` below.
     */
    @JvmName("towrkrfjkrdcurpc")
    public suspend fun slsProcessConfig(`value`: HybridMonitorSlsTaskSlsProcessConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsProcessConfig = mapped
    }

    /**
     * @param argument The configurations of the logs that are imported from Log Service. See `sls_process_config` below.
     */
    @JvmName("swuqnvanmweywidi")
    public suspend fun slsProcessConfig(argument: suspend HybridMonitorSlsTaskSlsProcessConfigArgsBuilder.() -> Unit) {
        val toBeMapped = HybridMonitorSlsTaskSlsProcessConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.slsProcessConfig = mapped
    }

    /**
     * @param value The name of the metric import task, enter the name of the metric for logs imported from Log Service.
     */
    @JvmName("ruofxupxllittluk")
    public suspend fun taskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskName = mapped
    }

    internal fun build(): HybridMonitorSlsTaskArgs = HybridMonitorSlsTaskArgs(
        attachLabels = attachLabels,
        collectInterval = collectInterval,
        collectTargetType = collectTargetType,
        description = description,
        namespace = namespace,
        slsProcessConfig = slsProcessConfig,
        taskName = taskName,
    )
}
