@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.MetricRuleBlackListArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.MetricRuleBlackListMetricArgs
import com.pulumi.alicloud.cms.kotlin.inputs.MetricRuleBlackListMetricArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Metric Rule Black List resource.
 * For information about Cloud Monitor Service Metric Rule Black List and how to use it, see [What is Metric Rule Black List](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruleblacklist).
 * > **NOTE:** Available since v1.194.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "Instance",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     instanceName: name,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroups: [defaultSecurityGroup&#46;id],
 *     vswitchId: defaultSwitch.id,
 * });
 * const defaultMetricRuleBlackList = new alicloud.cms.MetricRuleBlackList("default", {
 *     instances: [pulumi&#46;interpolate`{"instancceId":"${defaultInstance&#46;id}"}`],
 *     metrics: [{
 *         metricName: "disk_utilization",
 *     }],
 *     category: "ecs",
 *     enableEndTime: "1799443209000",
 *     namespace: "acs_ecs_dashboard",
 *     enableStartTime: "1689243209000",
 *     metricRuleBlackListName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="Instance")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_instance = alicloud.ecs.Instance("default",
 *     availability_zone=default.zones[0].id,
 *     instance_name=name,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_groups=[default_security_group&#46;id],
 *     vswitch_id=default_switch.id)
 * default_metric_rule_black_list = alicloud.cms.MetricRuleBlackList("default",
 *     instances=[default_instance&#46;id&#46;apply(lambda id: f"{{\"instancceId\":\"{id}\"}}")],
 *     metrics=[{
 *         "metric_name": "disk_utilization",
 *     }],
 *     category="ecs",
 *     enable_end_time="1799443209000",
 *     namespace="acs_ecs_dashboard",
 *     enable_start_time="1689243209000",
 *     metric_rule_black_list_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         InstanceName = name,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroups = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var defaultMetricRuleBlackList = new AliCloud.Cms.MetricRuleBlackList("default", new()
 *     {
 *         Instances = new[]
 *         {
 *             defaultInstance.Id.Apply(id => $"{{\"instancceId\":\"{id}\"}}"),
 *         },
 *         Metrics = new[]
 *         {
 *             new AliCloud.Cms.Inputs.MetricRuleBlackListMetricArgs
 *             {
 *                 MetricName = "disk_utilization",
 *             },
 *         },
 *         Category = "ecs",
 *         EnableEndTime = "1799443209000",
 *         Namespace = "acs_ecs_dashboard",
 *         EnableStartTime = "1689243209000",
 *         MetricRuleBlackListName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(1),
 * 			MemorySize:       pulumi.Float64Ref(2),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * 			InstanceName:     pulumi.String(name),
 * 			ImageId:          pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:     pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroups: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 			VswitchId: defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewMetricRuleBlackList(ctx, "default", &cms.MetricRuleBlackListArgs{
 * 			Instances: pulumi.StringArray{
 * 				defaultInstance.ID().ApplyT(func(id string) (string, error) {
 * 					return fmt.Sprintf("{\"instancceId\":\"%v\"}", id), nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 			Metrics: cms.MetricRuleBlackListMetricArray{
 * 				&cms.MetricRuleBlackListMetricArgs{
 * 					MetricName: pulumi.String("disk_utilization"),
 * 				},
 * 			},
 * 			Category:                pulumi.String("ecs"),
 * 			EnableEndTime:           pulumi.String("1799443209000"),
 * 			Namespace:               pulumi.String("acs_ecs_dashboard"),
 * 			EnableStartTime:         pulumi.String("1689243209000"),
 * 			MetricRuleBlackListName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.cms.MetricRuleBlackList;
 * import com.pulumi.alicloud.cms.MetricRuleBlackListArgs;
 * import com.pulumi.alicloud.cms.inputs.MetricRuleBlackListMetricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceName(name)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroups(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         var defaultMetricRuleBlackList = new MetricRuleBlackList("defaultMetricRuleBlackList", MetricRuleBlackListArgs.builder()
 *             .instances(defaultInstance.id().applyValue(id -> String.format("{{\"instancceId\":\"%s\"}}", id)))
 *             .metrics(MetricRuleBlackListMetricArgs.builder()
 *                 .metricName("disk_utilization")
 *                 .build())
 *             .category("ecs")
 *             .enableEndTime(1799443209000)
 *             .namespace("acs_ecs_dashboard")
 *             .enableStartTime(1689243209000)
 *             .metricRuleBlackListName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:ecs:Instance
 *     name: default
 *     properties:
 *       availabilityZone: ${default.zones[0].id}
 *       instanceName: ${name}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroups:
 *         - ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *   defaultMetricRuleBlackList:
 *     type: alicloud:cms:MetricRuleBlackList
 *     name: default
 *     properties:
 *       instances:
 *         - '{"instancceId":"${defaultInstance.id}"}'
 *       metrics:
 *         - metricName: disk_utilization
 *       category: ecs
 *       enableEndTime: 1.799443209e+12
 *       namespace: acs_ecs_dashboard
 *       enableStartTime: 1.689243209e+12
 *       metricRuleBlackListName: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 1
 *         memorySize: 2
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Metric Rule Black List can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/metricRuleBlackList:MetricRuleBlackList example <id>
 * ```
 * @property category Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
 * @property effectiveTime The effective time range of the alert blacklist policy.
 * @property enableEndTime The start timestamp of the alert blacklist policy.Unit: milliseconds.
 * @property enableStartTime The end timestamp of the alert blacklist policy.Unit: milliseconds.
 * @property instances The list of instances of cloud services specified in the alert blacklist policy.
 * @property isEnable The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
 * @property metricRuleBlackListName The name of the alert blacklist policy.
 * @property metrics Monitoring metrics in the instance. See `metrics` below.
 * @property namespace The data namespace of the cloud service.
 * @property scopeType The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
 * @property scopeValues Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
 */
public data class MetricRuleBlackListArgs(
    public val category: Output<String>? = null,
    public val effectiveTime: Output<String>? = null,
    public val enableEndTime: Output<String>? = null,
    public val enableStartTime: Output<String>? = null,
    public val instances: Output<List<String>>? = null,
    public val isEnable: Output<Boolean>? = null,
    public val metricRuleBlackListName: Output<String>? = null,
    public val metrics: Output<List<MetricRuleBlackListMetricArgs>>? = null,
    public val namespace: Output<String>? = null,
    public val scopeType: Output<String>? = null,
    public val scopeValues: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.MetricRuleBlackListArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.MetricRuleBlackListArgs =
        com.pulumi.alicloud.cms.MetricRuleBlackListArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .enableEndTime(enableEndTime?.applyValue({ args0 -> args0 }))
            .enableStartTime(enableStartTime?.applyValue({ args0 -> args0 }))
            .instances(instances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isEnable(isEnable?.applyValue({ args0 -> args0 }))
            .metricRuleBlackListName(metricRuleBlackListName?.applyValue({ args0 -> args0 }))
            .metrics(
                metrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .scopeType(scopeType?.applyValue({ args0 -> args0 }))
            .scopeValues(scopeValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MetricRuleBlackListArgs].
 */
@PulumiTagMarker
public class MetricRuleBlackListArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var effectiveTime: Output<String>? = null

    private var enableEndTime: Output<String>? = null

    private var enableStartTime: Output<String>? = null

    private var instances: Output<List<String>>? = null

    private var isEnable: Output<Boolean>? = null

    private var metricRuleBlackListName: Output<String>? = null

    private var metrics: Output<List<MetricRuleBlackListMetricArgs>>? = null

    private var namespace: Output<String>? = null

    private var scopeType: Output<String>? = null

    private var scopeValues: Output<List<String>>? = null

    /**
     * @param value Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
     */
    @JvmName("vdunkjohluujvoav")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The effective time range of the alert blacklist policy.
     */
    @JvmName("ihreyddvpaowrtvh")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value The start timestamp of the alert blacklist policy.Unit: milliseconds.
     */
    @JvmName("fijetinfrphheuns")
    public suspend fun enableEndTime(`value`: Output<String>) {
        this.enableEndTime = value
    }

    /**
     * @param value The end timestamp of the alert blacklist policy.Unit: milliseconds.
     */
    @JvmName("hpomuhyregoenkyf")
    public suspend fun enableStartTime(`value`: Output<String>) {
        this.enableStartTime = value
    }

    /**
     * @param value The list of instances of cloud services specified in the alert blacklist policy.
     */
    @JvmName("hgsfheucmvvftmlc")
    public suspend fun instances(`value`: Output<List<String>>) {
        this.instances = value
    }

    @JvmName("apgymbxnjlcyjcvb")
    public suspend fun instances(vararg values: Output<String>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values The list of instances of cloud services specified in the alert blacklist policy.
     */
    @JvmName("eulhxnmbnfmnwrnx")
    public suspend fun instances(values: List<Output<String>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
     */
    @JvmName("xxqxykybonrbfcyt")
    public suspend fun isEnable(`value`: Output<Boolean>) {
        this.isEnable = value
    }

    /**
     * @param value The name of the alert blacklist policy.
     */
    @JvmName("knemhpkkijykpqte")
    public suspend fun metricRuleBlackListName(`value`: Output<String>) {
        this.metricRuleBlackListName = value
    }

    /**
     * @param value Monitoring metrics in the instance. See `metrics` below.
     */
    @JvmName("cwomaxywhlxywdsp")
    public suspend fun metrics(`value`: Output<List<MetricRuleBlackListMetricArgs>>) {
        this.metrics = value
    }

    @JvmName("pndcsxhunjbqdaww")
    public suspend fun metrics(vararg values: Output<MetricRuleBlackListMetricArgs>) {
        this.metrics = Output.all(values.asList())
    }

    /**
     * @param values Monitoring metrics in the instance. See `metrics` below.
     */
    @JvmName("ijkqcrrdrvecyvnd")
    public suspend fun metrics(values: List<Output<MetricRuleBlackListMetricArgs>>) {
        this.metrics = Output.all(values)
    }

    /**
     * @param value The data namespace of the cloud service.
     */
    @JvmName("hahmfrxaktkkcnrl")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
     */
    @JvmName("oluodvrovslwgjpj")
    public suspend fun scopeType(`value`: Output<String>) {
        this.scopeType = value
    }

    /**
     * @param value Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
     */
    @JvmName("nwwmwdvkneupwigq")
    public suspend fun scopeValues(`value`: Output<List<String>>) {
        this.scopeValues = value
    }

    @JvmName("okpnjfvbwdlbbtrm")
    public suspend fun scopeValues(vararg values: Output<String>) {
        this.scopeValues = Output.all(values.asList())
    }

    /**
     * @param values Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
     */
    @JvmName("usdnmdhvivimbdmx")
    public suspend fun scopeValues(values: List<Output<String>>) {
        this.scopeValues = Output.all(values)
    }

    /**
     * @param value Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
     */
    @JvmName("ijregxsayqmvoqaa")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The effective time range of the alert blacklist policy.
     */
    @JvmName("vimfyvtjufijgrek")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value The start timestamp of the alert blacklist policy.Unit: milliseconds.
     */
    @JvmName("idwgybcqlnfbydlg")
    public suspend fun enableEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEndTime = mapped
    }

    /**
     * @param value The end timestamp of the alert blacklist policy.Unit: milliseconds.
     */
    @JvmName("ulvcsebmwxfydjec")
    public suspend fun enableStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStartTime = mapped
    }

    /**
     * @param value The list of instances of cloud services specified in the alert blacklist policy.
     */
    @JvmName("xjvhbeewprhremvy")
    public suspend fun instances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param values The list of instances of cloud services specified in the alert blacklist policy.
     */
    @JvmName("vhkfqwhvwxeqgssj")
    public suspend fun instances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
     */
    @JvmName("xllxdpjerxbovkfr")
    public suspend fun isEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnable = mapped
    }

    /**
     * @param value The name of the alert blacklist policy.
     */
    @JvmName("mjgruxwuwchulpys")
    public suspend fun metricRuleBlackListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricRuleBlackListName = mapped
    }

    /**
     * @param value Monitoring metrics in the instance. See `metrics` below.
     */
    @JvmName("uibquiwshherehiq")
    public suspend fun metrics(`value`: List<MetricRuleBlackListMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument Monitoring metrics in the instance. See `metrics` below.
     */
    @JvmName("kluhgjxritoubeuq")
    public suspend fun metrics(argument: List<suspend MetricRuleBlackListMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricRuleBlackListMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Monitoring metrics in the instance. See `metrics` below.
     */
    @JvmName("ekqqaeumndsgahkt")
    public suspend fun metrics(vararg argument: suspend MetricRuleBlackListMetricArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricRuleBlackListMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Monitoring metrics in the instance. See `metrics` below.
     */
    @JvmName("svuqikylswaakjyi")
    public suspend fun metrics(argument: suspend MetricRuleBlackListMetricArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MetricRuleBlackListMetricArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param values Monitoring metrics in the instance. See `metrics` below.
     */
    @JvmName("ribguelptgjogjno")
    public suspend fun metrics(vararg values: MetricRuleBlackListMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value The data namespace of the cloud service.
     */
    @JvmName("wpqhidltsyfowspm")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
     */
    @JvmName("fbcjeubknbeutomm")
    public suspend fun scopeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeType = mapped
    }

    /**
     * @param value Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
     */
    @JvmName("kkntybcancwlwjtr")
    public suspend fun scopeValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeValues = mapped
    }

    /**
     * @param values Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
     */
    @JvmName("tgsmjmwgtjkbopfw")
    public suspend fun scopeValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopeValues = mapped
    }

    internal fun build(): MetricRuleBlackListArgs = MetricRuleBlackListArgs(
        category = category,
        effectiveTime = effectiveTime,
        enableEndTime = enableEndTime,
        enableStartTime = enableStartTime,
        instances = instances,
        isEnable = isEnable,
        metricRuleBlackListName = metricRuleBlackListName,
        metrics = metrics,
        namespace = namespace,
        scopeType = scopeType,
        scopeValues = scopeValues,
    )
}
