@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.MetricRuleTemplateAlertTemplate
import com.pulumi.alicloud.cms.kotlin.outputs.MetricRuleTemplateAlertTemplate.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MetricRuleTemplate].
 */
@PulumiTagMarker
public class MetricRuleTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetricRuleTemplateArgs = MetricRuleTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetricRuleTemplateArgsBuilder.() -> Unit) {
        val builder = MetricRuleTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MetricRuleTemplate {
        val builtJavaResource = com.pulumi.alicloud.cms.MetricRuleTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MetricRuleTemplate(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Metric Rule Template resource.
 * For information about Cloud Monitor Service Metric Rule Template and how to use it, see [What is Metric Rule Template](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createmetricruletemplate).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.cms.MetricRuleTemplate("example", {
 *     metricRuleTemplateName: name,
 *     alertTemplates: [{
 *         category: "ecs",
 *         metricName: "cpu_total",
 *         namespace: "acs_ecs_dashboard",
 *         ruleName: "tf_example",
 *         escalations: {
 *             critical: {
 *                 comparisonOperator: "GreaterThanThreshold",
 *                 statistics: "Average",
 *                 threshold: "90",
 *                 times: "3",
 *             },
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.cms.MetricRuleTemplate("example",
 *     metric_rule_template_name=name,
 *     alert_templates=[{
 *         "category": "ecs",
 *         "metric_name": "cpu_total",
 *         "namespace": "acs_ecs_dashboard",
 *         "rule_name": "tf_example",
 *         "escalations": {
 *             "critical": {
 *                 "comparison_operator": "GreaterThanThreshold",
 *                 "statistics": "Average",
 *                 "threshold": "90",
 *                 "times": "3",
 *             },
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.Cms.MetricRuleTemplate("example", new()
 *     {
 *         MetricRuleTemplateName = name,
 *         AlertTemplates = new[]
 *         {
 *             new AliCloud.Cms.Inputs.MetricRuleTemplateAlertTemplateArgs
 *             {
 *                 Category = "ecs",
 *                 MetricName = "cpu_total",
 *                 Namespace = "acs_ecs_dashboard",
 *                 RuleName = "tf_example",
 *                 Escalations = new AliCloud.Cms.Inputs.MetricRuleTemplateAlertTemplateEscalationsArgs
 *                 {
 *                     Critical = new AliCloud.Cms.Inputs.MetricRuleTemplateAlertTemplateEscalationsCriticalArgs
 *                     {
 *                         ComparisonOperator = "GreaterThanThreshold",
 *                         Statistics = "Average",
 *                         Threshold = "90",
 *                         Times = "3",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewMetricRuleTemplate(ctx, "example", &cms.MetricRuleTemplateArgs{
 * 			MetricRuleTemplateName: pulumi.String(name),
 * 			AlertTemplates: cms.MetricRuleTemplateAlertTemplateArray{
 * 				&cms.MetricRuleTemplateAlertTemplateArgs{
 * 					Category:   pulumi.String("ecs"),
 * 					MetricName: pulumi.String("cpu_total"),
 * 					Namespace:  pulumi.String("acs_ecs_dashboard"),
 * 					RuleName:   pulumi.String("tf_example"),
 * 					Escalations: &cms.MetricRuleTemplateAlertTemplateEscalationsArgs{
 * 						Critical: &cms.MetricRuleTemplateAlertTemplateEscalationsCriticalArgs{
 * 							ComparisonOperator: pulumi.String("GreaterThanThreshold"),
 * 							Statistics:         pulumi.String("Average"),
 * 							Threshold:          pulumi.String("90"),
 * 							Times:              pulumi.String("3"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.MetricRuleTemplate;
 * import com.pulumi.alicloud.cms.MetricRuleTemplateArgs;
 * import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateArgs;
 * import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsArgs;
 * import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsCriticalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new MetricRuleTemplate("example", MetricRuleTemplateArgs.builder()
 *             .metricRuleTemplateName(name)
 *             .alertTemplates(MetricRuleTemplateAlertTemplateArgs.builder()
 *                 .category("ecs")
 *                 .metricName("cpu_total")
 *                 .namespace("acs_ecs_dashboard")
 *                 .ruleName("tf_example")
 *                 .escalations(MetricRuleTemplateAlertTemplateEscalationsArgs.builder()
 *                     .critical(MetricRuleTemplateAlertTemplateEscalationsCriticalArgs.builder()
 *                         .comparisonOperator("GreaterThanThreshold")
 *                         .statistics("Average")
 *                         .threshold("90")
 *                         .times("3")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:cms:MetricRuleTemplate
 *     properties:
 *       metricRuleTemplateName: ${name}
 *       alertTemplates:
 *         - category: ecs
 *           metricName: cpu_total
 *           namespace: acs_ecs_dashboard
 *           ruleName: tf_example
 *           escalations:
 *             critical:
 *               comparisonOperator: GreaterThanThreshold
 *               statistics: Average
 *               threshold: '90'
 *               times: '3'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Metric Rule Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/metricRuleTemplate:MetricRuleTemplate example <id>
 * ```
 */
public class MetricRuleTemplate internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.MetricRuleTemplate,
) : KotlinCustomResource(javaResource, MetricRuleTemplateMapper) {
    /**
     * The details of alert rules that are generated based on the alert template. See `alert_templates` below.
     */
    public val alertTemplates: Output<List<MetricRuleTemplateAlertTemplate>>?
        get() = javaResource.alertTemplates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The mode in which the alert template is applied. Valid values:
     * - `GROUP_INSTANCE_FIRST`: The metrics in the application group take precedence.
     * - `ALARM_TEMPLATE_FIRST `: The metrics specified in the alert template take precedence.
     */
    public val applyMode: Output<String>?
        get() = javaResource.applyMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The description of the alert template.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The end of the time period during which the alert rule is effective. Valid values: `00` to `23`. The value `00` indicates 00:59 and the value `23` indicates 23:59.
     */
    public val enableEndTime: Output<String>?
        get() = javaResource.enableEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The beginning of the time period during which the alert rule is effective. Valid values: `00` to `23`. The value `00` indicates 00:00 and the value `23` indicates 23:00.
     */
    public val enableStartTime: Output<String>?
        get() = javaResource.enableStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the application group.
     */
    public val groupId: Output<String>?
        get() = javaResource.groupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the alert template.
     */
    public val metricRuleTemplateName: Output<String>
        get() = javaResource.metricRuleTemplateName().applyValue({ args0 -> args0 })

    /**
     * The alert notification method. Valid values:
     */
    public val notifyLevel: Output<String>?
        get() = javaResource.notifyLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the alert template.
     */
    public val restVersion: Output<String>
        get() = javaResource.restVersion().applyValue({ args0 -> args0 })

    /**
     * The mute period during which notifications are not repeatedly sent for an alert. Unit: seconds. Default value: `86400`. Valid values: `0` to `86400`.
     */
    public val silenceTime: Output<Int>?
        get() = javaResource.silenceTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
     */
    public val webhook: Output<String>?
        get() = javaResource.webhook().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object MetricRuleTemplateMapper : ResourceMapper<MetricRuleTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.MetricRuleTemplate::class == javaResource::class

    override fun map(javaResource: Resource): MetricRuleTemplate = MetricRuleTemplate(
        javaResource as
            com.pulumi.alicloud.cms.MetricRuleTemplate,
    )
}

/**
 * @see [MetricRuleTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetricRuleTemplate].
 */
public suspend fun metricRuleTemplate(
    name: String,
    block: suspend MetricRuleTemplateResourceBuilder.() -> Unit,
): MetricRuleTemplate {
    val builder = MetricRuleTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetricRuleTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metricRuleTemplate(name: String): MetricRuleTemplate {
    val builder = MetricRuleTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
