@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.MetricRuleTemplateArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.MetricRuleTemplateAlertTemplateArgs
import com.pulumi.alicloud.cms.kotlin.inputs.MetricRuleTemplateAlertTemplateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Metric Rule Template resource.
 * For information about Cloud Monitor Service Metric Rule Template and how to use it, see [What is Metric Rule Template](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createmetricruletemplate).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.cms.MetricRuleTemplate("example", {
 *     metricRuleTemplateName: name,
 *     alertTemplates: [{
 *         category: "ecs",
 *         metricName: "cpu_total",
 *         namespace: "acs_ecs_dashboard",
 *         ruleName: "tf_example",
 *         escalations: {
 *             critical: {
 *                 comparisonOperator: "GreaterThanThreshold",
 *                 statistics: "Average",
 *                 threshold: "90",
 *                 times: "3",
 *             },
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.cms.MetricRuleTemplate("example",
 *     metric_rule_template_name=name,
 *     alert_templates=[{
 *         "category": "ecs",
 *         "metric_name": "cpu_total",
 *         "namespace": "acs_ecs_dashboard",
 *         "rule_name": "tf_example",
 *         "escalations": {
 *             "critical": {
 *                 "comparison_operator": "GreaterThanThreshold",
 *                 "statistics": "Average",
 *                 "threshold": "90",
 *                 "times": "3",
 *             },
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.Cms.MetricRuleTemplate("example", new()
 *     {
 *         MetricRuleTemplateName = name,
 *         AlertTemplates = new[]
 *         {
 *             new AliCloud.Cms.Inputs.MetricRuleTemplateAlertTemplateArgs
 *             {
 *                 Category = "ecs",
 *                 MetricName = "cpu_total",
 *                 Namespace = "acs_ecs_dashboard",
 *                 RuleName = "tf_example",
 *                 Escalations = new AliCloud.Cms.Inputs.MetricRuleTemplateAlertTemplateEscalationsArgs
 *                 {
 *                     Critical = new AliCloud.Cms.Inputs.MetricRuleTemplateAlertTemplateEscalationsCriticalArgs
 *                     {
 *                         ComparisonOperator = "GreaterThanThreshold",
 *                         Statistics = "Average",
 *                         Threshold = "90",
 *                         Times = "3",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cms.NewMetricRuleTemplate(ctx, "example", &cms.MetricRuleTemplateArgs{
 * 			MetricRuleTemplateName: pulumi.String(name),
 * 			AlertTemplates: cms.MetricRuleTemplateAlertTemplateArray{
 * 				&cms.MetricRuleTemplateAlertTemplateArgs{
 * 					Category:   pulumi.String("ecs"),
 * 					MetricName: pulumi.String("cpu_total"),
 * 					Namespace:  pulumi.String("acs_ecs_dashboard"),
 * 					RuleName:   pulumi.String("tf_example"),
 * 					Escalations: &cms.MetricRuleTemplateAlertTemplateEscalationsArgs{
 * 						Critical: &cms.MetricRuleTemplateAlertTemplateEscalationsCriticalArgs{
 * 							ComparisonOperator: pulumi.String("GreaterThanThreshold"),
 * 							Statistics:         pulumi.String("Average"),
 * 							Threshold:          pulumi.String("90"),
 * 							Times:              pulumi.String("3"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.MetricRuleTemplate;
 * import com.pulumi.alicloud.cms.MetricRuleTemplateArgs;
 * import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateArgs;
 * import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsArgs;
 * import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsCriticalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new MetricRuleTemplate("example", MetricRuleTemplateArgs.builder()
 *             .metricRuleTemplateName(name)
 *             .alertTemplates(MetricRuleTemplateAlertTemplateArgs.builder()
 *                 .category("ecs")
 *                 .metricName("cpu_total")
 *                 .namespace("acs_ecs_dashboard")
 *                 .ruleName("tf_example")
 *                 .escalations(MetricRuleTemplateAlertTemplateEscalationsArgs.builder()
 *                     .critical(MetricRuleTemplateAlertTemplateEscalationsCriticalArgs.builder()
 *                         .comparisonOperator("GreaterThanThreshold")
 *                         .statistics("Average")
 *                         .threshold("90")
 *                         .times("3")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:cms:MetricRuleTemplate
 *     properties:
 *       metricRuleTemplateName: ${name}
 *       alertTemplates:
 *         - category: ecs
 *           metricName: cpu_total
 *           namespace: acs_ecs_dashboard
 *           ruleName: tf_example
 *           escalations:
 *             critical:
 *               comparisonOperator: GreaterThanThreshold
 *               statistics: Average
 *               threshold: '90'
 *               times: '3'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Metric Rule Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/metricRuleTemplate:MetricRuleTemplate example <id>
 * ```
 * @property alertTemplates The details of alert rules that are generated based on the alert template. See `alert_templates` below.
 * @property applyMode The mode in which the alert template is applied. Valid values:
 * - `GROUP_INSTANCE_FIRST`: The metrics in the application group take precedence.
 * - `ALARM_TEMPLATE_FIRST `: The metrics specified in the alert template take precedence.
 * @property description The description of the alert template.
 * @property enableEndTime The end of the time period during which the alert rule is effective. Valid values: `00` to `23`. The value `00` indicates 00:59 and the value `23` indicates 23:59.
 * @property enableStartTime The beginning of the time period during which the alert rule is effective. Valid values: `00` to `23`. The value `00` indicates 00:00 and the value `23` indicates 23:00.
 * @property groupId The ID of the application group.
 * @property metricRuleTemplateName The name of the alert template.
 * @property notifyLevel The alert notification method. Valid values:
 * @property silenceTime The mute period during which notifications are not repeatedly sent for an alert. Unit: seconds. Default value: `86400`. Valid values: `0` to `86400`.
 * @property webhook The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
 */
public data class MetricRuleTemplateArgs(
    public val alertTemplates: Output<List<MetricRuleTemplateAlertTemplateArgs>>? = null,
    public val applyMode: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enableEndTime: Output<String>? = null,
    public val enableStartTime: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val metricRuleTemplateName: Output<String>? = null,
    public val notifyLevel: Output<String>? = null,
    public val silenceTime: Output<Int>? = null,
    public val webhook: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.MetricRuleTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.MetricRuleTemplateArgs =
        com.pulumi.alicloud.cms.MetricRuleTemplateArgs.builder()
            .alertTemplates(
                alertTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .applyMode(applyMode?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableEndTime(enableEndTime?.applyValue({ args0 -> args0 }))
            .enableStartTime(enableStartTime?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .metricRuleTemplateName(metricRuleTemplateName?.applyValue({ args0 -> args0 }))
            .notifyLevel(notifyLevel?.applyValue({ args0 -> args0 }))
            .silenceTime(silenceTime?.applyValue({ args0 -> args0 }))
            .webhook(webhook?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricRuleTemplateArgs].
 */
@PulumiTagMarker
public class MetricRuleTemplateArgsBuilder internal constructor() {
    private var alertTemplates: Output<List<MetricRuleTemplateAlertTemplateArgs>>? = null

    private var applyMode: Output<String>? = null

    private var description: Output<String>? = null

    private var enableEndTime: Output<String>? = null

    private var enableStartTime: Output<String>? = null

    private var groupId: Output<String>? = null

    private var metricRuleTemplateName: Output<String>? = null

    private var notifyLevel: Output<String>? = null

    private var silenceTime: Output<Int>? = null

    private var webhook: Output<String>? = null

    /**
     * @param value The details of alert rules that are generated based on the alert template. See `alert_templates` below.
     */
    @JvmName("ypvleicltjcsmwtv")
    public suspend fun alertTemplates(`value`: Output<List<MetricRuleTemplateAlertTemplateArgs>>) {
        this.alertTemplates = value
    }

    @JvmName("bydbgbgxkriloscd")
    public suspend fun alertTemplates(vararg values: Output<MetricRuleTemplateAlertTemplateArgs>) {
        this.alertTemplates = Output.all(values.asList())
    }

    /**
     * @param values The details of alert rules that are generated based on the alert template. See `alert_templates` below.
     */
    @JvmName("tddfkdkhpdbasopc")
    public suspend fun alertTemplates(values: List<Output<MetricRuleTemplateAlertTemplateArgs>>) {
        this.alertTemplates = Output.all(values)
    }

    /**
     * @param value The mode in which the alert template is applied. Valid values:
     * - `GROUP_INSTANCE_FIRST`: The metrics in the application group take precedence.
     * - `ALARM_TEMPLATE_FIRST `: The metrics specified in the alert template take precedence.
     */
    @JvmName("kvtfrvfsgcjccfsd")
    public suspend fun applyMode(`value`: Output<String>) {
        this.applyMode = value
    }

    /**
     * @param value The description of the alert template.
     */
    @JvmName("asyxhahmmwymhwhh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The end of the time period during which the alert rule is effective. Valid values: `00` to `23`. The value `00` indicates 00:59 and the value `23` indicates 23:59.
     */
    @JvmName("rhdfvbqimoglqepr")
    public suspend fun enableEndTime(`value`: Output<String>) {
        this.enableEndTime = value
    }

    /**
     * @param value The beginning of the time period during which the alert rule is effective. Valid values: `00` to `23`. The value `00` indicates 00:00 and the value `23` indicates 23:00.
     */
    @JvmName("vdangjngaqcxisxw")
    public suspend fun enableStartTime(`value`: Output<String>) {
        this.enableStartTime = value
    }

    /**
     * @param value The ID of the application group.
     */
    @JvmName("osgakysjjukoxata")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the alert template.
     */
    @JvmName("oapywcddvntugtyn")
    public suspend fun metricRuleTemplateName(`value`: Output<String>) {
        this.metricRuleTemplateName = value
    }

    /**
     * @param value The alert notification method. Valid values:
     */
    @JvmName("qksvijsssyiusodw")
    public suspend fun notifyLevel(`value`: Output<String>) {
        this.notifyLevel = value
    }

    /**
     * @param value The mute period during which notifications are not repeatedly sent for an alert. Unit: seconds. Default value: `86400`. Valid values: `0` to `86400`.
     */
    @JvmName("gmvffecpumfqhtvj")
    public suspend fun silenceTime(`value`: Output<Int>) {
        this.silenceTime = value
    }

    /**
     * @param value The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
     */
    @JvmName("fqkuhdirjnqrojvg")
    public suspend fun webhook(`value`: Output<String>) {
        this.webhook = value
    }

    /**
     * @param value The details of alert rules that are generated based on the alert template. See `alert_templates` below.
     */
    @JvmName("wxldiqkgfccctjwu")
    public suspend fun alertTemplates(`value`: List<MetricRuleTemplateAlertTemplateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertTemplates = mapped
    }

    /**
     * @param argument The details of alert rules that are generated based on the alert template. See `alert_templates` below.
     */
    @JvmName("vemyjngolqrduwif")
    public suspend fun alertTemplates(argument: List<suspend MetricRuleTemplateAlertTemplateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricRuleTemplateAlertTemplateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.alertTemplates = mapped
    }

    /**
     * @param argument The details of alert rules that are generated based on the alert template. See `alert_templates` below.
     */
    @JvmName("mfpaddhluxhdvvxo")
    public suspend fun alertTemplates(vararg argument: suspend MetricRuleTemplateAlertTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricRuleTemplateAlertTemplateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.alertTemplates = mapped
    }

    /**
     * @param argument The details of alert rules that are generated based on the alert template. See `alert_templates` below.
     */
    @JvmName("donwaniwewtmakxm")
    public suspend fun alertTemplates(argument: suspend MetricRuleTemplateAlertTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MetricRuleTemplateAlertTemplateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.alertTemplates = mapped
    }

    /**
     * @param values The details of alert rules that are generated based on the alert template. See `alert_templates` below.
     */
    @JvmName("hnakhygnaaingbah")
    public suspend fun alertTemplates(vararg values: MetricRuleTemplateAlertTemplateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertTemplates = mapped
    }

    /**
     * @param value The mode in which the alert template is applied. Valid values:
     * - `GROUP_INSTANCE_FIRST`: The metrics in the application group take precedence.
     * - `ALARM_TEMPLATE_FIRST `: The metrics specified in the alert template take precedence.
     */
    @JvmName("ltessryvgjwynjcq")
    public suspend fun applyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyMode = mapped
    }

    /**
     * @param value The description of the alert template.
     */
    @JvmName("rvemspmshhrgtfbg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The end of the time period during which the alert rule is effective. Valid values: `00` to `23`. The value `00` indicates 00:59 and the value `23` indicates 23:59.
     */
    @JvmName("lxbtnalrtyiokptp")
    public suspend fun enableEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEndTime = mapped
    }

    /**
     * @param value The beginning of the time period during which the alert rule is effective. Valid values: `00` to `23`. The value `00` indicates 00:00 and the value `23` indicates 23:00.
     */
    @JvmName("bhptpuwyqmrstyfs")
    public suspend fun enableStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStartTime = mapped
    }

    /**
     * @param value The ID of the application group.
     */
    @JvmName("qibjitvvhtuhecgt")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the alert template.
     */
    @JvmName("aerrhceiouxpcyrv")
    public suspend fun metricRuleTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricRuleTemplateName = mapped
    }

    /**
     * @param value The alert notification method. Valid values:
     */
    @JvmName("qnlesfidjintetmh")
    public suspend fun notifyLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyLevel = mapped
    }

    /**
     * @param value The mute period during which notifications are not repeatedly sent for an alert. Unit: seconds. Default value: `86400`. Valid values: `0` to `86400`.
     */
    @JvmName("jtghygnqmjdnwhos")
    public suspend fun silenceTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.silenceTime = mapped
    }

    /**
     * @param value The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
     */
    @JvmName("wjnchmlsjgylesqv")
    public suspend fun webhook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhook = mapped
    }

    internal fun build(): MetricRuleTemplateArgs = MetricRuleTemplateArgs(
        alertTemplates = alertTemplates,
        applyMode = applyMode,
        description = description,
        enableEndTime = enableEndTime,
        enableStartTime = enableStartTime,
        groupId = groupId,
        metricRuleTemplateName = metricRuleTemplateName,
        notifyLevel = notifyLevel,
        silenceTime = silenceTime,
        webhook = webhook,
    )
}
