@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [MonitorGroup].
 */
@PulumiTagMarker
public class MonitorGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitorGroupArgs = MonitorGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitorGroupArgsBuilder.() -> Unit) {
        val builder = MonitorGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MonitorGroup {
        val builtJavaResource = com.pulumi.alicloud.cms.MonitorGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MonitorGroup(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Monitor Group resource.
 * For information about Cloud Monitor Service Monitor Group and how to use it, see [What is Monitor Group](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createmonitorgroup).
 * > **NOTE:** Available since v1.113.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cms.MonitorGroup("example", {monitorGroupName: "tf-example-accmonitorgroup"});
 * const default2 = new alicloud.cms.MonitorGroup("default2", {
 *     contactGroups: ["your_contact_groups"],
 *     resourceGroupId: "your_resource_group_id",
 *     resourceGroupName: "resource_group_name",
 *     tags: {
 *         Created: "TF",
 *         For: "Acceptance-example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cms.MonitorGroup("example", monitor_group_name="tf-example-accmonitorgroup")
 * default2 = alicloud.cms.MonitorGroup("default2",
 *     contact_groups=["your_contact_groups"],
 *     resource_group_id="your_resource_group_id",
 *     resource_group_name="resource_group_name",
 *     tags={
 *         "Created": "TF",
 *         "For": "Acceptance-example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cms.MonitorGroup("example", new()
 *     {
 *         MonitorGroupName = "tf-example-accmonitorgroup",
 *     });
 *     var default2 = new AliCloud.Cms.MonitorGroup("default2", new()
 *     {
 *         ContactGroups = new[]
 *         {
 *             "your_contact_groups",
 *         },
 *         ResourceGroupId = "your_resource_group_id",
 *         ResourceGroupName = "resource_group_name",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "Acceptance-example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cms.NewMonitorGroup(ctx, "example", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String("tf-example-accmonitorgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewMonitorGroup(ctx, "default2", &cms.MonitorGroupArgs{
 * 			ContactGroups: pulumi.StringArray{
 * 				pulumi.String("your_contact_groups"),
 * 			},
 * 			ResourceGroupId:   pulumi.String("your_resource_group_id"),
 * 			ResourceGroupName: pulumi.String("resource_group_name"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("Acceptance-example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MonitorGroup("example", MonitorGroupArgs.builder()
 *             .monitorGroupName("tf-example-accmonitorgroup")
 *             .build());
 *         var default2 = new MonitorGroup("default2", MonitorGroupArgs.builder()
 *             .contactGroups("your_contact_groups")
 *             .resourceGroupId("your_resource_group_id")
 *             .resourceGroupName("resource_group_name")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "Acceptance-example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cms:MonitorGroup
 *     properties:
 *       monitorGroupName: tf-example-accmonitorgroup
 *   default2:
 *     type: alicloud:cms:MonitorGroup
 *     properties:
 *       contactGroups:
 *         - your_contact_groups
 *       resourceGroupId: your_resource_group_id
 *       resourceGroupName: resource_group_name
 *       tags:
 *         Created: TF
 *         For: Acceptance-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Monitor Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/monitorGroup:MonitorGroup example <id>
 * ```
 */
public class MonitorGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.MonitorGroup,
) : KotlinCustomResource(javaResource, MonitorGroupMapper) {
    /**
     * The alert group to which alert notifications will be sent.
     */
    public val contactGroups: Output<List<String>>?
        get() = javaResource.contactGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the application group.
     */
    public val monitorGroupName: Output<String>
        get() = javaResource.monitorGroupName().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource group.
     */
    public val resourceGroupName: Output<String>?
        get() = javaResource.resourceGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object MonitorGroupMapper : ResourceMapper<MonitorGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.MonitorGroup::class == javaResource::class

    override fun map(javaResource: Resource): MonitorGroup = MonitorGroup(
        javaResource as
            com.pulumi.alicloud.cms.MonitorGroup,
    )
}

/**
 * @see [MonitorGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MonitorGroup].
 */
public suspend fun monitorGroup(
    name: String,
    block: suspend MonitorGroupResourceBuilder.() -> Unit,
): MonitorGroup {
    val builder = MonitorGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MonitorGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitorGroup(name: String): MonitorGroup {
    val builder = MonitorGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
