@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.MonitorGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Monitor Group resource.
 * For information about Cloud Monitor Service Monitor Group and how to use it, see [What is Monitor Group](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createmonitorgroup).
 * > **NOTE:** Available since v1.113.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cms.MonitorGroup("example", {monitorGroupName: "tf-example-accmonitorgroup"});
 * const default2 = new alicloud.cms.MonitorGroup("default2", {
 *     contactGroups: ["your_contact_groups"],
 *     resourceGroupId: "your_resource_group_id",
 *     resourceGroupName: "resource_group_name",
 *     tags: {
 *         Created: "TF",
 *         For: "Acceptance-example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cms.MonitorGroup("example", monitor_group_name="tf-example-accmonitorgroup")
 * default2 = alicloud.cms.MonitorGroup("default2",
 *     contact_groups=["your_contact_groups"],
 *     resource_group_id="your_resource_group_id",
 *     resource_group_name="resource_group_name",
 *     tags={
 *         "Created": "TF",
 *         "For": "Acceptance-example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cms.MonitorGroup("example", new()
 *     {
 *         MonitorGroupName = "tf-example-accmonitorgroup",
 *     });
 *     var default2 = new AliCloud.Cms.MonitorGroup("default2", new()
 *     {
 *         ContactGroups = new[]
 *         {
 *             "your_contact_groups",
 *         },
 *         ResourceGroupId = "your_resource_group_id",
 *         ResourceGroupName = "resource_group_name",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "Acceptance-example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cms.NewMonitorGroup(ctx, "example", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String("tf-example-accmonitorgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewMonitorGroup(ctx, "default2", &cms.MonitorGroupArgs{
 * 			ContactGroups: pulumi.StringArray{
 * 				pulumi.String("your_contact_groups"),
 * 			},
 * 			ResourceGroupId:   pulumi.String("your_resource_group_id"),
 * 			ResourceGroupName: pulumi.String("resource_group_name"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("Acceptance-example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MonitorGroup("example", MonitorGroupArgs.builder()
 *             .monitorGroupName("tf-example-accmonitorgroup")
 *             .build());
 *         var default2 = new MonitorGroup("default2", MonitorGroupArgs.builder()
 *             .contactGroups("your_contact_groups")
 *             .resourceGroupId("your_resource_group_id")
 *             .resourceGroupName("resource_group_name")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "Acceptance-example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cms:MonitorGroup
 *     properties:
 *       monitorGroupName: tf-example-accmonitorgroup
 *   default2:
 *     type: alicloud:cms:MonitorGroup
 *     properties:
 *       contactGroups:
 *         - your_contact_groups
 *       resourceGroupId: your_resource_group_id
 *       resourceGroupName: resource_group_name
 *       tags:
 *         Created: TF
 *         For: Acceptance-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Monitor Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/monitorGroup:MonitorGroup example <id>
 * ```
 * @property contactGroups The alert group to which alert notifications will be sent.
 * @property monitorGroupName The name of the application group.
 * @property resourceGroupId The ID of the resource group.
 * @property resourceGroupName The name of the resource group.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class MonitorGroupArgs(
    public val contactGroups: Output<List<String>>? = null,
    public val monitorGroupName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.MonitorGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.MonitorGroupArgs =
        com.pulumi.alicloud.cms.MonitorGroupArgs.builder()
            .contactGroups(contactGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .monitorGroupName(monitorGroupName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MonitorGroupArgs].
 */
@PulumiTagMarker
public class MonitorGroupArgsBuilder internal constructor() {
    private var contactGroups: Output<List<String>>? = null

    private var monitorGroupName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The alert group to which alert notifications will be sent.
     */
    @JvmName("rgothyuebgafqbji")
    public suspend fun contactGroups(`value`: Output<List<String>>) {
        this.contactGroups = value
    }

    @JvmName("ftufxakduhmhbvhq")
    public suspend fun contactGroups(vararg values: Output<String>) {
        this.contactGroups = Output.all(values.asList())
    }

    /**
     * @param values The alert group to which alert notifications will be sent.
     */
    @JvmName("pmmxvblyuyqsrnle")
    public suspend fun contactGroups(values: List<Output<String>>) {
        this.contactGroups = Output.all(values)
    }

    /**
     * @param value The name of the application group.
     */
    @JvmName("iginltblqklkdfqi")
    public suspend fun monitorGroupName(`value`: Output<String>) {
        this.monitorGroupName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("ylhelftkqsrewtqx")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hfabmdrdxxtmximq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ghalullrkswcxkuu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The alert group to which alert notifications will be sent.
     */
    @JvmName("eqrejxhfclgqdcqb")
    public suspend fun contactGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param values The alert group to which alert notifications will be sent.
     */
    @JvmName("krrlkujqjwvqtikp")
    public suspend fun contactGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param value The name of the application group.
     */
    @JvmName("xaobwbxumimqodrv")
    public suspend fun monitorGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorGroupName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("boiiwpyxckevqnjy")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nvdycfmpfvnaiboy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("mtgcpleefvxxorhu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("spnkckjpioxxfaml")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MonitorGroupArgs = MonitorGroupArgs(
        contactGroups = contactGroups,
        monitorGroupName = monitorGroupName,
        resourceGroupId = resourceGroupId,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
