@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.MonitorGroupInstancesInstance
import com.pulumi.alicloud.cms.kotlin.outputs.MonitorGroupInstancesInstance.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MonitorGroupInstances].
 */
@PulumiTagMarker
public class MonitorGroupInstancesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitorGroupInstancesArgs = MonitorGroupInstancesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitorGroupInstancesArgsBuilder.() -> Unit) {
        val builder = MonitorGroupInstancesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MonitorGroupInstances {
        val builtJavaResource = com.pulumi.alicloud.cms.MonitorGroupInstances(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MonitorGroupInstances(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Monitor Group Instances resource.
 * For information about Cloud Monitor Service Monitor Group Instances and how to use it, see [What is Monitor Group Instances](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createmonitorgroupinstances).
 * > **NOTE:** Available since v1.115.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const defaultMonitorGroup = new alicloud.cms.MonitorGroup("default", {monitorGroupName: name});
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.cms.MonitorGroupInstances("example", {
 *     groupId: defaultMonitorGroup.id,
 *     instances: [{
 *         instanceId: defaultNetwork.id,
 *         instanceName: name,
 *         regionId: _default.then(_default => _default.regions?.[0]?.id),
 *         category: "vpc",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/16")
 * default_monitor_group = alicloud.cms.MonitorGroup("default", monitor_group_name=name)
 * default = alicloud.get_regions(current=True)
 * example = alicloud.cms.MonitorGroupInstances("example",
 *     group_id=default_monitor_group.id,
 *     instances=[{
 *         "instance_id": default_network.id,
 *         "instance_name": name,
 *         "region_id": default.regions[0].id,
 *         "category": "vpc",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var defaultMonitorGroup = new AliCloud.Cms.MonitorGroup("default", new()
 *     {
 *         MonitorGroupName = name,
 *     });
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Cms.MonitorGroupInstances("example", new()
 *     {
 *         GroupId = defaultMonitorGroup.Id,
 *         Instances = new[]
 *         {
 *             new AliCloud.Cms.Inputs.MonitorGroupInstancesInstanceArgs
 *             {
 *                 InstanceId = defaultNetwork.Id,
 *                 InstanceName = name,
 *                 RegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *                 Category = "vpc",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultMonitorGroup, err := cms.NewMonitorGroup(ctx, "default", &cms.MonitorGroupArgs{
 * 			MonitorGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cms.NewMonitorGroupInstances(ctx, "example", &cms.MonitorGroupInstancesArgs{
 * 			GroupId: defaultMonitorGroup.ID(),
 * 			Instances: cms.MonitorGroupInstancesInstanceArray{
 * 				&cms.MonitorGroupInstancesInstanceArgs{
 * 					InstanceId:   defaultNetwork.ID(),
 * 					InstanceName: pulumi.String(name),
 * 					RegionId:     pulumi.String(_default.Regions[0].Id),
 * 					Category:     pulumi.String("vpc"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cms.MonitorGroup;
 * import com.pulumi.alicloud.cms.MonitorGroupArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.cms.MonitorGroupInstances;
 * import com.pulumi.alicloud.cms.MonitorGroupInstancesArgs;
 * import com.pulumi.alicloud.cms.inputs.MonitorGroupInstancesInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         var defaultMonitorGroup = new MonitorGroup("defaultMonitorGroup", MonitorGroupArgs.builder()
 *             .monitorGroupName(name)
 *             .build());
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new MonitorGroupInstances("example", MonitorGroupInstancesArgs.builder()
 *             .groupId(defaultMonitorGroup.id())
 *             .instances(MonitorGroupInstancesInstanceArgs.builder()
 *                 .instanceId(defaultNetwork.id())
 *                 .instanceName(name)
 *                 .regionId(default_.regions()[0].id())
 *                 .category("vpc")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/16
 *   defaultMonitorGroup:
 *     type: alicloud:cms:MonitorGroup
 *     name: default
 *     properties:
 *       monitorGroupName: ${name}
 *   example:
 *     type: alicloud:cms:MonitorGroupInstances
 *     properties:
 *       groupId: ${defaultMonitorGroup.id}
 *       instances:
 *         - instanceId: ${defaultNetwork.id}
 *           instanceName: ${name}
 *           regionId: ${default.regions[0].id}
 *           category: vpc
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Monitor Group Instances can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/monitorGroupInstances:MonitorGroupInstances example <group_id>
 * ```
 */
public class MonitorGroupInstances internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.MonitorGroupInstances,
) : KotlinCustomResource(javaResource, MonitorGroupInstancesMapper) {
    /**
     * The id of Cms Group.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * Instance information added to the Cms Group. See `instances` below.
     */
    public val instances: Output<List<MonitorGroupInstancesInstance>>
        get() = javaResource.instances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object MonitorGroupInstancesMapper : ResourceMapper<MonitorGroupInstances> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.MonitorGroupInstances::class == javaResource::class

    override fun map(javaResource: Resource): MonitorGroupInstances =
        MonitorGroupInstances(javaResource as com.pulumi.alicloud.cms.MonitorGroupInstances)
}

/**
 * @see [MonitorGroupInstances].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MonitorGroupInstances].
 */
public suspend fun monitorGroupInstances(
    name: String,
    block: suspend MonitorGroupInstancesResourceBuilder.() -> Unit,
): MonitorGroupInstances {
    val builder = MonitorGroupInstancesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MonitorGroupInstances].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitorGroupInstances(name: String): MonitorGroupInstances {
    val builder = MonitorGroupInstancesResourceBuilder()
    builder.name(name)
    return builder.build()
}
