@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.NamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Namespace resource.
 * For information about Cloud Monitor Service Namespace and how to use it, see [What is Namespace](https://www.alibabacloud.com/help/en/cloudmonitor/latest/createhybridmonitornamespace).
 * > **NOTE:** Available since v1.171.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cms.Namespace("example", {
 *     namespace: "tf-example",
 *     specification: "cms.s1.large",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cms.Namespace("example",
 *     namespace="tf-example",
 *     specification="cms.s1.large")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cms.Namespace("example", new()
 *     {
 *         NamespaceName = "tf-example",
 *         Specification = "cms.s1.large",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cms.NewNamespace(ctx, "example", &cms.NamespaceArgs{
 * 			Namespace:     pulumi.String("tf-example"),
 * 			Specification: pulumi.String("cms.s1.large"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.Namespace;
 * import com.pulumi.alicloud.cms.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespace("tf-example")
 *             .specification("cms.s1.large")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cms:Namespace
 *     properties:
 *       namespace: tf-example
 *       specification: cms.s1.large
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Namespace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/namespace:Namespace example <id>
 * ```
 * @property description The description of the namespace.
 * @property namespace The name of the namespace. The name can contain lowercase letters, digits, and hyphens (-).
 * @property specification The data retention period. Default value: `cms.s1.3xlarge`. Valid values:
 * - `cms.s1.large`: Data storage duration is 15 days.
 * - `cms.s1.xlarge`: Data storage duration is 32 days.
 * - `cms.s1.2xlarge`: Data storage duration 63 days.
 * - `cms.s1.3xlarge`: Data storage duration 93 days.
 * - `cms.s1.6xlarge`: Data storage duration 185 days.
 * - `cms.s1.12xlarge`: Data storage duration 376 days.
 */
public data class NamespaceArgs(
    public val description: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val specification: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.NamespaceArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.NamespaceArgs =
        com.pulumi.alicloud.cms.NamespaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var namespace: Output<String>? = null

    private var specification: Output<String>? = null

    /**
     * @param value The description of the namespace.
     */
    @JvmName("eeiyqjbrojbewcim")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the namespace. The name can contain lowercase letters, digits, and hyphens (-).
     */
    @JvmName("qnryiftfoagiltqa")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The data retention period. Default value: `cms.s1.3xlarge`. Valid values:
     * - `cms.s1.large`: Data storage duration is 15 days.
     * - `cms.s1.xlarge`: Data storage duration is 32 days.
     * - `cms.s1.2xlarge`: Data storage duration 63 days.
     * - `cms.s1.3xlarge`: Data storage duration 93 days.
     * - `cms.s1.6xlarge`: Data storage duration 185 days.
     * - `cms.s1.12xlarge`: Data storage duration 376 days.
     */
    @JvmName("kbbrhaoeorqmgies")
    public suspend fun specification(`value`: Output<String>) {
        this.specification = value
    }

    /**
     * @param value The description of the namespace.
     */
    @JvmName("hahheormemmcbjsh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the namespace. The name can contain lowercase letters, digits, and hyphens (-).
     */
    @JvmName("uvllkmjwvcvmrdqo")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The data retention period. Default value: `cms.s1.3xlarge`. Valid values:
     * - `cms.s1.large`: Data storage duration is 15 days.
     * - `cms.s1.xlarge`: Data storage duration is 32 days.
     * - `cms.s1.2xlarge`: Data storage duration 63 days.
     * - `cms.s1.3xlarge`: Data storage duration 93 days.
     * - `cms.s1.6xlarge`: Data storage duration 185 days.
     * - `cms.s1.12xlarge`: Data storage duration 376 days.
     */
    @JvmName("etjgymwedfauypqa")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        description = description,
        namespace = namespace,
        specification = specification,
    )
}
