@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.SiteMonitorIspCity
import com.pulumi.alicloud.cms.kotlin.outputs.SiteMonitorIspCity.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SiteMonitor].
 */
@PulumiTagMarker
public class SiteMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SiteMonitorArgs = SiteMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SiteMonitorArgsBuilder.() -> Unit) {
        val builder = SiteMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SiteMonitor {
        val builtJavaResource = com.pulumi.alicloud.cms.SiteMonitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SiteMonitor(builtJavaResource)
    }
}

/**
 * This resource provides a site monitor resource and it can be used to monitor public endpoints and websites.
 * Details at https://www.alibabacloud.com/help/doc-detail/67907.htm
 * > **NOTE:** Available since v1.72.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const basic = new alicloud.cms.SiteMonitor("basic", {
 *     address: "http://www.alibabacloud.com",
 *     taskName: "tf-example",
 *     taskType: "HTTP",
 *     interval: 5,
 *     ispCities: [{
 *         city: "546",
 *         isp: "465",
 *     }],
 *     optionsJson: `{
 *     "http_method": "get",
 *     "waitTime_after_completion": null,
 *     "ipv6_task": false,
 *     "diagnosis_ping": false,
 *     "diagnosis_mtr": false,
 *     "assertions": [
 *         {
 *             "operator": "lessThan",
 *             "type": "response_time",
 *             "target": 1000
 *         }
 *     ],
 *     "time_out": 30000
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * basic = alicloud.cms.SiteMonitor("basic",
 *     address="http://www.alibabacloud.com",
 *     task_name="tf-example",
 *     task_type="HTTP",
 *     interval=5,
 *     isp_cities=[{
 *         "city": "546",
 *         "isp": "465",
 *     }],
 *     options_json="""{
 *     "http_method": "get",
 *     "waitTime_after_completion": null,
 *     "ipv6_task": false,
 *     "diagnosis_ping": false,
 *     "diagnosis_mtr": false,
 *     "assertions": [
 *         {
 *             "operator": "lessThan",
 *             "type": "response_time",
 *             "target": 1000
 *         }
 *     ],
 *     "time_out": 30000
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var basic = new AliCloud.Cms.SiteMonitor("basic", new()
 *     {
 *         Address = "http://www.alibabacloud.com",
 *         TaskName = "tf-example",
 *         TaskType = "HTTP",
 *         Interval = 5,
 *         IspCities = new[]
 *         {
 *             new AliCloud.Cms.Inputs.SiteMonitorIspCityArgs
 *             {
 *                 City = "546",
 *                 Isp = "465",
 *             },
 *         },
 *         OptionsJson = @"{
 *     ""http_method"": ""get"",
 *     ""waitTime_after_completion"": null,
 *     ""ipv6_task"": false,
 *     ""diagnosis_ping"": false,
 *     ""diagnosis_mtr"": false,
 *     ""assertions"": [
 *         {
 *             ""operator"": ""lessThan"",
 *             ""type"": ""response_time"",
 *             ""target"": 1000
 *         }
 *     ],
 *     ""time_out"": 30000
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cms.NewSiteMonitor(ctx, "basic", &cms.SiteMonitorArgs{
 * 			Address:  pulumi.String("http://www.alibabacloud.com"),
 * 			TaskName: pulumi.String("tf-example"),
 * 			TaskType: pulumi.String("HTTP"),
 * 			Interval: pulumi.Int(5),
 * 			IspCities: cms.SiteMonitorIspCityArray{
 * 				&cms.SiteMonitorIspCityArgs{
 * 					City: pulumi.String("546"),
 * 					Isp:  pulumi.String("465"),
 * 				},
 * 			},
 * 			OptionsJson: pulumi.String(`{
 *     "http_method": "get",
 *     "waitTime_after_completion": null,
 *     "ipv6_task": false,
 *     "diagnosis_ping": false,
 *     "diagnosis_mtr": false,
 *     "assertions": [
 *         {
 *             "operator": "lessThan",
 *             "type": "response_time",
 *             "target": 1000
 *         }
 *     ],
 *     "time_out": 30000
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.SiteMonitor;
 * import com.pulumi.alicloud.cms.SiteMonitorArgs;
 * import com.pulumi.alicloud.cms.inputs.SiteMonitorIspCityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var basic = new SiteMonitor("basic", SiteMonitorArgs.builder()
 *             .address("http://www.alibabacloud.com")
 *             .taskName("tf-example")
 *             .taskType("HTTP")
 *             .interval(5)
 *             .ispCities(SiteMonitorIspCityArgs.builder()
 *                 .city("546")
 *                 .isp("465")
 *                 .build())
 *             .optionsJson("""
 * {
 *     "http_method": "get",
 *     "waitTime_after_completion": null,
 *     "ipv6_task": false,
 *     "diagnosis_ping": false,
 *     "diagnosis_mtr": false,
 *     "assertions": [
 *         {
 *             "operator": "lessThan",
 *             "type": "response_time",
 *             "target": 1000
 *         }
 *     ],
 *     "time_out": 30000
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   basic:
 *     type: alicloud:cms:SiteMonitor
 *     properties:
 *       address: http://www.alibabacloud.com
 *       taskName: tf-example
 *       taskType: HTTP
 *       interval: 5
 *       ispCities:
 *         - city: '546'
 *           isp: '465'
 *       optionsJson: |
 *         {
 *             "http_method": "get",
 *             "waitTime_after_completion": null,
 *             "ipv6_task": false,
 *             "diagnosis_ping": false,
 *             "diagnosis_mtr": false,
 *             "assertions": [
 *                 {
 *                     "operator": "lessThan",
 *                     "type": "response_time",
 *                     "target": 1000
 *                 }
 *             ],
 *             "time_out": 30000
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Site Monitor can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/siteMonitor:SiteMonitor example <id>
 * ```
 */
public class SiteMonitor internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.SiteMonitor,
) : KotlinCustomResource(javaResource, SiteMonitorMapper) {
    /**
     * The URL or IP address monitored by the site monitoring task.
     */
    public val address: Output<String>
        get() = javaResource.address().applyValue({ args0 -> args0 })

    /**
     * The IDs of existing alert rules to be associated with the site monitoring task.
     */
    public val alertIds: Output<List<String>>?
        get() = javaResource.alertIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The time when the site monitoring task was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
     */
    public val interval: Output<Int>?
        get() = javaResource.interval().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
     */
    public val ispCities: Output<List<SiteMonitorIspCity>>?
        get() = javaResource.ispCities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
     */
    public val optionsJson: Output<String>?
        get() = javaResource.optionsJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
     */
    public val taskName: Output<String>
        get() = javaResource.taskName().applyValue({ args0 -> args0 })

    /**
     * The status of the site monitoring task.
     */
    public val taskState: Output<String>
        get() = javaResource.taskState().applyValue({ args0 -> args0 })

    /**
     * The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
     */
    public val taskType: Output<String>
        get() = javaResource.taskType().applyValue({ args0 -> args0 })

    /**
     * The time when the site monitoring task was updated.
     */
    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })
}

public object SiteMonitorMapper : ResourceMapper<SiteMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.SiteMonitor::class == javaResource::class

    override fun map(javaResource: Resource): SiteMonitor = SiteMonitor(
        javaResource as
            com.pulumi.alicloud.cms.SiteMonitor,
    )
}

/**
 * @see [SiteMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SiteMonitor].
 */
public suspend fun siteMonitor(name: String, block: suspend SiteMonitorResourceBuilder.() -> Unit): SiteMonitor {
    val builder = SiteMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SiteMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun siteMonitor(name: String): SiteMonitor {
    val builder = SiteMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
