@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.SiteMonitorArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.SiteMonitorIspCityArgs
import com.pulumi.alicloud.cms.kotlin.inputs.SiteMonitorIspCityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This resource provides a site monitor resource and it can be used to monitor public endpoints and websites.
 * Details at https://www.alibabacloud.com/help/doc-detail/67907.htm
 * > **NOTE:** Available since v1.72.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const basic = new alicloud.cms.SiteMonitor("basic", {
 *     address: "http://www.alibabacloud.com",
 *     taskName: "tf-example",
 *     taskType: "HTTP",
 *     interval: 5,
 *     ispCities: [{
 *         city: "546",
 *         isp: "465",
 *     }],
 *     optionsJson: `{
 *     "http_method": "get",
 *     "waitTime_after_completion": null,
 *     "ipv6_task": false,
 *     "diagnosis_ping": false,
 *     "diagnosis_mtr": false,
 *     "assertions": [
 *         {
 *             "operator": "lessThan",
 *             "type": "response_time",
 *             "target": 1000
 *         }
 *     ],
 *     "time_out": 30000
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * basic = alicloud.cms.SiteMonitor("basic",
 *     address="http://www.alibabacloud.com",
 *     task_name="tf-example",
 *     task_type="HTTP",
 *     interval=5,
 *     isp_cities=[{
 *         "city": "546",
 *         "isp": "465",
 *     }],
 *     options_json="""{
 *     "http_method": "get",
 *     "waitTime_after_completion": null,
 *     "ipv6_task": false,
 *     "diagnosis_ping": false,
 *     "diagnosis_mtr": false,
 *     "assertions": [
 *         {
 *             "operator": "lessThan",
 *             "type": "response_time",
 *             "target": 1000
 *         }
 *     ],
 *     "time_out": 30000
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var basic = new AliCloud.Cms.SiteMonitor("basic", new()
 *     {
 *         Address = "http://www.alibabacloud.com",
 *         TaskName = "tf-example",
 *         TaskType = "HTTP",
 *         Interval = 5,
 *         IspCities = new[]
 *         {
 *             new AliCloud.Cms.Inputs.SiteMonitorIspCityArgs
 *             {
 *                 City = "546",
 *                 Isp = "465",
 *             },
 *         },
 *         OptionsJson = @"{
 *     ""http_method"": ""get"",
 *     ""waitTime_after_completion"": null,
 *     ""ipv6_task"": false,
 *     ""diagnosis_ping"": false,
 *     ""diagnosis_mtr"": false,
 *     ""assertions"": [
 *         {
 *             ""operator"": ""lessThan"",
 *             ""type"": ""response_time"",
 *             ""target"": 1000
 *         }
 *     ],
 *     ""time_out"": 30000
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cms.NewSiteMonitor(ctx, "basic", &cms.SiteMonitorArgs{
 * 			Address:  pulumi.String("http://www.alibabacloud.com"),
 * 			TaskName: pulumi.String("tf-example"),
 * 			TaskType: pulumi.String("HTTP"),
 * 			Interval: pulumi.Int(5),
 * 			IspCities: cms.SiteMonitorIspCityArray{
 * 				&cms.SiteMonitorIspCityArgs{
 * 					City: pulumi.String("546"),
 * 					Isp:  pulumi.String("465"),
 * 				},
 * 			},
 * 			OptionsJson: pulumi.String(`{
 *     "http_method": "get",
 *     "waitTime_after_completion": null,
 *     "ipv6_task": false,
 *     "diagnosis_ping": false,
 *     "diagnosis_mtr": false,
 *     "assertions": [
 *         {
 *             "operator": "lessThan",
 *             "type": "response_time",
 *             "target": 1000
 *         }
 *     ],
 *     "time_out": 30000
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cms.SiteMonitor;
 * import com.pulumi.alicloud.cms.SiteMonitorArgs;
 * import com.pulumi.alicloud.cms.inputs.SiteMonitorIspCityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var basic = new SiteMonitor("basic", SiteMonitorArgs.builder()
 *             .address("http://www.alibabacloud.com")
 *             .taskName("tf-example")
 *             .taskType("HTTP")
 *             .interval(5)
 *             .ispCities(SiteMonitorIspCityArgs.builder()
 *                 .city("546")
 *                 .isp("465")
 *                 .build())
 *             .optionsJson("""
 * {
 *     "http_method": "get",
 *     "waitTime_after_completion": null,
 *     "ipv6_task": false,
 *     "diagnosis_ping": false,
 *     "diagnosis_mtr": false,
 *     "assertions": [
 *         {
 *             "operator": "lessThan",
 *             "type": "response_time",
 *             "target": 1000
 *         }
 *     ],
 *     "time_out": 30000
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   basic:
 *     type: alicloud:cms:SiteMonitor
 *     properties:
 *       address: http://www.alibabacloud.com
 *       taskName: tf-example
 *       taskType: HTTP
 *       interval: 5
 *       ispCities:
 *         - city: '546'
 *           isp: '465'
 *       optionsJson: |
 *         {
 *             "http_method": "get",
 *             "waitTime_after_completion": null,
 *             "ipv6_task": false,
 *             "diagnosis_ping": false,
 *             "diagnosis_mtr": false,
 *             "assertions": [
 *                 {
 *                     "operator": "lessThan",
 *                     "type": "response_time",
 *                     "target": 1000
 *                 }
 *             ],
 *             "time_out": 30000
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Monitor Service Site Monitor can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/siteMonitor:SiteMonitor example <id>
 * ```
 * @property address The URL or IP address monitored by the site monitoring task.
 * @property alertIds The IDs of existing alert rules to be associated with the site monitoring task.
 * @property interval The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
 * @property ispCities The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
 * @property optionsJson The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
 * @property taskName The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
 * @property taskType The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
 */
public data class SiteMonitorArgs(
    public val address: Output<String>? = null,
    public val alertIds: Output<List<String>>? = null,
    public val interval: Output<Int>? = null,
    public val ispCities: Output<List<SiteMonitorIspCityArgs>>? = null,
    public val optionsJson: Output<String>? = null,
    public val taskName: Output<String>? = null,
    public val taskType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.SiteMonitorArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.SiteMonitorArgs =
        com.pulumi.alicloud.cms.SiteMonitorArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .alertIds(alertIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .ispCities(
                ispCities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .optionsJson(optionsJson?.applyValue({ args0 -> args0 }))
            .taskName(taskName?.applyValue({ args0 -> args0 }))
            .taskType(taskType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteMonitorArgs].
 */
@PulumiTagMarker
public class SiteMonitorArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var alertIds: Output<List<String>>? = null

    private var interval: Output<Int>? = null

    private var ispCities: Output<List<SiteMonitorIspCityArgs>>? = null

    private var optionsJson: Output<String>? = null

    private var taskName: Output<String>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value The URL or IP address monitored by the site monitoring task.
     */
    @JvmName("heflrkerylfrfayp")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The IDs of existing alert rules to be associated with the site monitoring task.
     */
    @JvmName("xpolyybsmmaxydla")
    public suspend fun alertIds(`value`: Output<List<String>>) {
        this.alertIds = value
    }

    @JvmName("ljsgxseqqkkaunux")
    public suspend fun alertIds(vararg values: Output<String>) {
        this.alertIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of existing alert rules to be associated with the site monitoring task.
     */
    @JvmName("ncmhldrjlrctbvwi")
    public suspend fun alertIds(values: List<Output<String>>) {
        this.alertIds = Output.all(values)
    }

    /**
     * @param value The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
     */
    @JvmName("ptaotarmdtxynvpn")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
     */
    @JvmName("egmpuqpryupjwkjb")
    public suspend fun ispCities(`value`: Output<List<SiteMonitorIspCityArgs>>) {
        this.ispCities = value
    }

    @JvmName("ephbkxhencxynoan")
    public suspend fun ispCities(vararg values: Output<SiteMonitorIspCityArgs>) {
        this.ispCities = Output.all(values.asList())
    }

    /**
     * @param values The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
     */
    @JvmName("aodsjsvadqsyiqqj")
    public suspend fun ispCities(values: List<Output<SiteMonitorIspCityArgs>>) {
        this.ispCities = Output.all(values)
    }

    /**
     * @param value The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
     */
    @JvmName("kvruglnliyvnccwq")
    public suspend fun optionsJson(`value`: Output<String>) {
        this.optionsJson = value
    }

    /**
     * @param value The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
     */
    @JvmName("aepyqtdnkteyavkt")
    public suspend fun taskName(`value`: Output<String>) {
        this.taskName = value
    }

    /**
     * @param value The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
     */
    @JvmName("xlcpojykokqfmfbx")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value The URL or IP address monitored by the site monitoring task.
     */
    @JvmName("xoahxhpkipxhhyyp")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The IDs of existing alert rules to be associated with the site monitoring task.
     */
    @JvmName("abxhsfujutwxwjcc")
    public suspend fun alertIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertIds = mapped
    }

    /**
     * @param values The IDs of existing alert rules to be associated with the site monitoring task.
     */
    @JvmName("lxleamqrsdnkhpbb")
    public suspend fun alertIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertIds = mapped
    }

    /**
     * @param value The monitoring interval of the site monitoring task. Unit: minutes. Valid values: `1`, `5`, `15`, `30` and `60`. Default value: `1`. **NOTE:** From version 1.207.0, `interval` can be set to `30`, `60`.
     */
    @JvmName("qwhdheovbvbgfxbi")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
     */
    @JvmName("ysyvsiwbrhnssiuk")
    public suspend fun ispCities(`value`: List<SiteMonitorIspCityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ispCities = mapped
    }

    /**
     * @param argument The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
     */
    @JvmName("wnhruibojdwyjssy")
    public suspend fun ispCities(argument: List<suspend SiteMonitorIspCityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SiteMonitorIspCityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ispCities = mapped
    }

    /**
     * @param argument The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
     */
    @JvmName("dfaeebqisbgnhkih")
    public suspend fun ispCities(vararg argument: suspend SiteMonitorIspCityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SiteMonitorIspCityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ispCities = mapped
    }

    /**
     * @param argument The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
     */
    @JvmName("xagltjenlotneahw")
    public suspend fun ispCities(argument: suspend SiteMonitorIspCityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SiteMonitorIspCityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ispCities = mapped
    }

    /**
     * @param values The detection points in a JSON array. For example, `[{"city":"546","isp":"465"},{"city":"572","isp":"465"},{"city":"738","isp":"465"}]` indicates the detection points in Beijing, Hangzhou, and Qingdao respectively&#46; You can call the [DescribeSiteMonitorISPCityList](https://www.alibabacloud.com/help/en/doc-detail/115045.htm) operation to query detection point information. If this parameter is not specified, three detection points will be chosen randomly for monitoring. See `isp_cities` below.
     */
    @JvmName("keyslsgmydmtfvfw")
    public suspend fun ispCities(vararg values: SiteMonitorIspCityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ispCities = mapped
    }

    /**
     * @param value The extended options of the protocol of the site monitoring task. The options vary according to the protocol. See [extended options](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-createsitemonitor#api-detail-35).
     */
    @JvmName("jgypeyhjxhvliqly")
    public suspend fun optionsJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionsJson = mapped
    }

    /**
     * @param value The name of the site monitoring task. The name must be 4 to 100 characters in length. The name can contain the following types of characters: letters, digits, and underscores.
     */
    @JvmName("nulwxsweextkfeic")
    public suspend fun taskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskName = mapped
    }

    /**
     * @param value The protocol of the site monitoring task. Currently, site monitoring supports the following protocols: HTTP, PING, TCP, UDP, DNS, SMTP, POP3, and FTP.
     */
    @JvmName("pbprlelsllbmholf")
    public suspend fun taskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): SiteMonitorArgs = SiteMonitorArgs(
        address = address,
        alertIds = alertIds,
        interval = interval,
        ispCities = ispCities,
        optionsJson = optionsJson,
        taskName = taskName,
        taskType = taskType,
    )
}
