@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.kotlin.outputs.SlsGroupSlsGroupConfig
import com.pulumi.alicloud.cms.kotlin.outputs.SlsGroupSlsGroupConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SlsGroup].
 */
@PulumiTagMarker
public class SlsGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SlsGroupArgs = SlsGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SlsGroupArgsBuilder.() -> Unit) {
        val builder = SlsGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SlsGroup {
        val builtJavaResource = com.pulumi.alicloud.cms.SlsGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SlsGroup(builtJavaResource)
    }
}

/**
 * Provides a Cloud Monitor Service Sls Group resource.
 * For information about Cloud Monitor Service Sls Group and how to use it, see [What is Sls Group](https://www.alibabacloud.com/help/doc-detail/28608.htm).
 * > **NOTE:** Available since v1.171.0.
 * ## Import
 * Cloud Monitor Service Sls Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/slsGroup:SlsGroup example <sls_group_name>
 * ```
 */
public class SlsGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.cms.SlsGroup,
) : KotlinCustomResource(javaResource, SlsGroupMapper) {
    /**
     * The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
     */
    public val slsGroupConfigs: Output<List<SlsGroupSlsGroupConfig>>
        get() = javaResource.slsGroupConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The Description of the Sls Group.
     */
    public val slsGroupDescription: Output<String>?
        get() = javaResource.slsGroupDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource. The name must be `2` to `32` characters in length, and can contain letters, digits and underscores (_). It must start with a letter.
     */
    public val slsGroupName: Output<String>
        get() = javaResource.slsGroupName().applyValue({ args0 -> args0 })
}

public object SlsGroupMapper : ResourceMapper<SlsGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cms.SlsGroup::class == javaResource::class

    override fun map(javaResource: Resource): SlsGroup = SlsGroup(
        javaResource as
            com.pulumi.alicloud.cms.SlsGroup,
    )
}

/**
 * @see [SlsGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SlsGroup].
 */
public suspend fun slsGroup(name: String, block: suspend SlsGroupResourceBuilder.() -> Unit): SlsGroup {
    val builder = SlsGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SlsGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun slsGroup(name: String): SlsGroup {
    val builder = SlsGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
