@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin

import com.pulumi.alicloud.cms.SlsGroupArgs.builder
import com.pulumi.alicloud.cms.kotlin.inputs.SlsGroupSlsGroupConfigArgs
import com.pulumi.alicloud.cms.kotlin.inputs.SlsGroupSlsGroupConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Monitor Service Sls Group resource.
 * For information about Cloud Monitor Service Sls Group and how to use it, see [What is Sls Group](https://www.alibabacloud.com/help/doc-detail/28608.htm).
 * > **NOTE:** Available since v1.171.0.
 * ## Import
 * Cloud Monitor Service Sls Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cms/slsGroup:SlsGroup example <sls_group_name>
 * ```
 * @property slsGroupConfigs The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
 * @property slsGroupDescription The Description of the Sls Group.
 * @property slsGroupName The name of the resource. The name must be `2` to `32` characters in length, and can contain letters, digits and underscores (_). It must start with a letter.
 */
public data class SlsGroupArgs(
    public val slsGroupConfigs: Output<List<SlsGroupSlsGroupConfigArgs>>? = null,
    public val slsGroupDescription: Output<String>? = null,
    public val slsGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.SlsGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.SlsGroupArgs =
        com.pulumi.alicloud.cms.SlsGroupArgs.builder()
            .slsGroupConfigs(
                slsGroupConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .slsGroupDescription(slsGroupDescription?.applyValue({ args0 -> args0 }))
            .slsGroupName(slsGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SlsGroupArgs].
 */
@PulumiTagMarker
public class SlsGroupArgsBuilder internal constructor() {
    private var slsGroupConfigs: Output<List<SlsGroupSlsGroupConfigArgs>>? = null

    private var slsGroupDescription: Output<String>? = null

    private var slsGroupName: Output<String>? = null

    /**
     * @param value The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
     */
    @JvmName("kljqdxqrayqhfhlk")
    public suspend fun slsGroupConfigs(`value`: Output<List<SlsGroupSlsGroupConfigArgs>>) {
        this.slsGroupConfigs = value
    }

    @JvmName("qgoppeuhjqhbkakg")
    public suspend fun slsGroupConfigs(vararg values: Output<SlsGroupSlsGroupConfigArgs>) {
        this.slsGroupConfigs = Output.all(values.asList())
    }

    /**
     * @param values The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
     */
    @JvmName("telavoihjafjwguw")
    public suspend fun slsGroupConfigs(values: List<Output<SlsGroupSlsGroupConfigArgs>>) {
        this.slsGroupConfigs = Output.all(values)
    }

    /**
     * @param value The Description of the Sls Group.
     */
    @JvmName("llmatpykiycsrolo")
    public suspend fun slsGroupDescription(`value`: Output<String>) {
        this.slsGroupDescription = value
    }

    /**
     * @param value The name of the resource. The name must be `2` to `32` characters in length, and can contain letters, digits and underscores (_). It must start with a letter.
     */
    @JvmName("vyvnmcpdipxxduat")
    public suspend fun slsGroupName(`value`: Output<String>) {
        this.slsGroupName = value
    }

    /**
     * @param value The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
     */
    @JvmName("xdnypckeanosjgbj")
    public suspend fun slsGroupConfigs(`value`: List<SlsGroupSlsGroupConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsGroupConfigs = mapped
    }

    /**
     * @param argument The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
     */
    @JvmName("gmbbrbfpccjurmrf")
    public suspend fun slsGroupConfigs(argument: List<suspend SlsGroupSlsGroupConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SlsGroupSlsGroupConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slsGroupConfigs = mapped
    }

    /**
     * @param argument The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
     */
    @JvmName("fhycamqfaavwjngl")
    public suspend fun slsGroupConfigs(vararg argument: suspend SlsGroupSlsGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SlsGroupSlsGroupConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slsGroupConfigs = mapped
    }

    /**
     * @param argument The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
     */
    @JvmName("ogbienccndpiblqq")
    public suspend fun slsGroupConfigs(argument: suspend SlsGroupSlsGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SlsGroupSlsGroupConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.slsGroupConfigs = mapped
    }

    /**
     * @param values The Config of the Sls Group. You can specify up to 25 Config. See `sls_group_config` below.
     */
    @JvmName("ieqoyinbeoawdrgt")
    public suspend fun slsGroupConfigs(vararg values: SlsGroupSlsGroupConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slsGroupConfigs = mapped
    }

    /**
     * @param value The Description of the Sls Group.
     */
    @JvmName("jwujbroxgwvbrbbd")
    public suspend fun slsGroupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsGroupDescription = mapped
    }

    /**
     * @param value The name of the resource. The name must be `2` to `32` characters in length, and can contain letters, digits and underscores (_). It must start with a letter.
     */
    @JvmName("akuirsmfhqkgjivh")
    public suspend fun slsGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsGroupName = mapped
    }

    internal fun build(): SlsGroupArgs = SlsGroupArgs(
        slsGroupConfigs = slsGroupConfigs,
        slsGroupDescription = slsGroupDescription,
        slsGroupName = slsGroupName,
    )
}
