@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.AlarmCompositeExpressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property expressionListJoin The relationship between the trigger conditions for multiple metrics. Valid values: `&&`, `||`.
 * @property expressionLists The trigger conditions that are created in standard mode. See `expression_list` below.
 * @property expressionRaw The trigger conditions that are created by using expressions.
 * @property level The level of the alert. Valid values: `CRITICAL`, `WARN`, `INFO`.
 * @property times The number of consecutive triggers.
 */
public data class AlarmCompositeExpressionArgs(
    public val expressionListJoin: Output<String>? = null,
    public val expressionLists: Output<List<AlarmCompositeExpressionExpressionListArgs>>? = null,
    public val expressionRaw: Output<String>? = null,
    public val level: Output<String>? = null,
    public val times: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.AlarmCompositeExpressionArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.AlarmCompositeExpressionArgs =
        com.pulumi.alicloud.cms.inputs.AlarmCompositeExpressionArgs.builder()
            .expressionListJoin(expressionListJoin?.applyValue({ args0 -> args0 }))
            .expressionLists(
                expressionLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .expressionRaw(expressionRaw?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .times(times?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmCompositeExpressionArgs].
 */
@PulumiTagMarker
public class AlarmCompositeExpressionArgsBuilder internal constructor() {
    private var expressionListJoin: Output<String>? = null

    private var expressionLists: Output<List<AlarmCompositeExpressionExpressionListArgs>>? = null

    private var expressionRaw: Output<String>? = null

    private var level: Output<String>? = null

    private var times: Output<Int>? = null

    /**
     * @param value The relationship between the trigger conditions for multiple metrics. Valid values: `&&`, `||`.
     */
    @JvmName("anxjuqfxtjvuxxnh")
    public suspend fun expressionListJoin(`value`: Output<String>) {
        this.expressionListJoin = value
    }

    /**
     * @param value The trigger conditions that are created in standard mode. See `expression_list` below.
     */
    @JvmName("lyugeuftkbtkweie")
    public suspend fun expressionLists(`value`: Output<List<AlarmCompositeExpressionExpressionListArgs>>) {
        this.expressionLists = value
    }

    @JvmName("mjqtxjvacybnrtbi")
    public suspend fun expressionLists(vararg values: Output<AlarmCompositeExpressionExpressionListArgs>) {
        this.expressionLists = Output.all(values.asList())
    }

    /**
     * @param values The trigger conditions that are created in standard mode. See `expression_list` below.
     */
    @JvmName("xrktswptcxptsqtw")
    public suspend fun expressionLists(values: List<Output<AlarmCompositeExpressionExpressionListArgs>>) {
        this.expressionLists = Output.all(values)
    }

    /**
     * @param value The trigger conditions that are created by using expressions.
     */
    @JvmName("rtqbkyipvnshewcj")
    public suspend fun expressionRaw(`value`: Output<String>) {
        this.expressionRaw = value
    }

    /**
     * @param value The level of the alert. Valid values: `CRITICAL`, `WARN`, `INFO`.
     */
    @JvmName("mcxvxevksnfcfcqn")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The number of consecutive triggers.
     */
    @JvmName("ibwcbolsoywubwpt")
    public suspend fun times(`value`: Output<Int>) {
        this.times = value
    }

    /**
     * @param value The relationship between the trigger conditions for multiple metrics. Valid values: `&&`, `||`.
     */
    @JvmName("qqgsuhdyhhuphect")
    public suspend fun expressionListJoin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressionListJoin = mapped
    }

    /**
     * @param value The trigger conditions that are created in standard mode. See `expression_list` below.
     */
    @JvmName("hluhtrjpugvtsmot")
    public suspend fun expressionLists(`value`: List<AlarmCompositeExpressionExpressionListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressionLists = mapped
    }

    /**
     * @param argument The trigger conditions that are created in standard mode. See `expression_list` below.
     */
    @JvmName("ledtomqxbclcxwux")
    public suspend fun expressionLists(argument: List<suspend AlarmCompositeExpressionExpressionListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlarmCompositeExpressionExpressionListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expressionLists = mapped
    }

    /**
     * @param argument The trigger conditions that are created in standard mode. See `expression_list` below.
     */
    @JvmName("kawgwfimlycslvtn")
    public suspend fun expressionLists(vararg argument: suspend AlarmCompositeExpressionExpressionListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlarmCompositeExpressionExpressionListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expressionLists = mapped
    }

    /**
     * @param argument The trigger conditions that are created in standard mode. See `expression_list` below.
     */
    @JvmName("nakmdbqrgtvmgvao")
    public suspend fun expressionLists(argument: suspend AlarmCompositeExpressionExpressionListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AlarmCompositeExpressionExpressionListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.expressionLists = mapped
    }

    /**
     * @param values The trigger conditions that are created in standard mode. See `expression_list` below.
     */
    @JvmName("ujagwqyftbrearvu")
    public suspend fun expressionLists(vararg values: AlarmCompositeExpressionExpressionListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressionLists = mapped
    }

    /**
     * @param value The trigger conditions that are created by using expressions.
     */
    @JvmName("fxtshvqsxglunatr")
    public suspend fun expressionRaw(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressionRaw = mapped
    }

    /**
     * @param value The level of the alert. Valid values: `CRITICAL`, `WARN`, `INFO`.
     */
    @JvmName("xbkwcradaayfatub")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The number of consecutive triggers.
     */
    @JvmName("bpqayvtgaxdnejng")
    public suspend fun times(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.times = mapped
    }

    internal fun build(): AlarmCompositeExpressionArgs = AlarmCompositeExpressionArgs(
        expressionListJoin = expressionListJoin,
        expressionLists = expressionLists,
        expressionRaw = expressionRaw,
        level = level,
        times = times,
    )
}
