@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.AlarmCompositeExpressionExpressionListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator
 * @property metricName The metric that is used to monitor the cloud service.
 * @property period The statistical period of the metric. Unit: seconds. Default value: `300`.
 * @property statistics Field `statistics` has been removed from provider version 1.216.0. New field `escalations_critical.statistics` instead.
 * @property threshold Field `threshold` has been removed from provider version 1.216.0. New field `escalations_critical.threshold` instead.
 */
public data class AlarmCompositeExpressionExpressionListArgs(
    public val comparisonOperator: Output<String>? = null,
    public val metricName: Output<String>? = null,
    public val period: Output<String>? = null,
    public val statistics: Output<String>? = null,
    public val threshold: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.AlarmCompositeExpressionExpressionListArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.AlarmCompositeExpressionExpressionListArgs =
        com.pulumi.alicloud.cms.inputs.AlarmCompositeExpressionExpressionListArgs.builder()
            .comparisonOperator(comparisonOperator?.applyValue({ args0 -> args0 }))
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .statistics(statistics?.applyValue({ args0 -> args0 }))
            .threshold(threshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmCompositeExpressionExpressionListArgs].
 */
@PulumiTagMarker
public class AlarmCompositeExpressionExpressionListArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var metricName: Output<String>? = null

    private var period: Output<String>? = null

    private var statistics: Output<String>? = null

    private var threshold: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("gxlptlrfjuypxyyc")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value The metric that is used to monitor the cloud service.
     */
    @JvmName("biycljsfssokrkfs")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The statistical period of the metric. Unit: seconds. Default value: `300`.
     */
    @JvmName("ebxtnokkjpofybdq")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value Field `statistics` has been removed from provider version 1.216.0. New field `escalations_critical.statistics` instead.
     */
    @JvmName("lrttqiymjygstuao")
    public suspend fun statistics(`value`: Output<String>) {
        this.statistics = value
    }

    /**
     * @param value Field `threshold` has been removed from provider version 1.216.0. New field `escalations_critical.threshold` instead.
     */
    @JvmName("atpgwxlpuplswdyi")
    public suspend fun threshold(`value`: Output<String>) {
        this.threshold = value
    }

    /**
     * @param value
     */
    @JvmName("gpccdbbngblaehwy")
    public suspend fun comparisonOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value The metric that is used to monitor the cloud service.
     */
    @JvmName("qvgdjflfuqooafex")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The statistical period of the metric. Unit: seconds. Default value: `300`.
     */
    @JvmName("crfhqprympwkmtiu")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Field `statistics` has been removed from provider version 1.216.0. New field `escalations_critical.statistics` instead.
     */
    @JvmName("xxbraljhbrdiukpf")
    public suspend fun statistics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    /**
     * @param value Field `threshold` has been removed from provider version 1.216.0. New field `escalations_critical.threshold` instead.
     */
    @JvmName("ukswvyliatukrqxl")
    public suspend fun threshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    internal fun build(): AlarmCompositeExpressionExpressionListArgs =
        AlarmCompositeExpressionExpressionListArgs(
            comparisonOperator = comparisonOperator,
            metricName = metricName,
            period = period,
            statistics = statistics,
            threshold = threshold,
        )
}
