@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.AlarmEscalationsInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator Info level alarm comparison operator. Default value: `>`. Valid values: `>`, `>=`, `<`, `<=`, `!=`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`. **NOTE:** From version 1.225.0, `comparison_operator` cannot be set to `==`.
 * @property statistics Info level alarm statistics method. It must be consistent with that defined for metrics. For more information, see [How to use it](https://cms.console.aliyun.com/metric-meta/acs_ecs_dashboard/ecs).
 * @property threshold Info level alarm threshold value, which must be a numeric value currently.
 * @property times Info level alarm retry times. Default value: `3`.
 */
public data class AlarmEscalationsInfoArgs(
    public val comparisonOperator: Output<String>? = null,
    public val statistics: Output<String>? = null,
    public val threshold: Output<String>? = null,
    public val times: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.AlarmEscalationsInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.AlarmEscalationsInfoArgs =
        com.pulumi.alicloud.cms.inputs.AlarmEscalationsInfoArgs.builder()
            .comparisonOperator(comparisonOperator?.applyValue({ args0 -> args0 }))
            .statistics(statistics?.applyValue({ args0 -> args0 }))
            .threshold(threshold?.applyValue({ args0 -> args0 }))
            .times(times?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmEscalationsInfoArgs].
 */
@PulumiTagMarker
public class AlarmEscalationsInfoArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var statistics: Output<String>? = null

    private var threshold: Output<String>? = null

    private var times: Output<Int>? = null

    /**
     * @param value Info level alarm comparison operator. Default value: `>`. Valid values: `>`, `>=`, `<`, `<=`, `!=`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`. **NOTE:** From version 1.225.0, `comparison_operator` cannot be set to `==`.
     */
    @JvmName("vcukyopmtchcasdq")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value Info level alarm statistics method. It must be consistent with that defined for metrics. For more information, see [How to use it](https://cms.console.aliyun.com/metric-meta/acs_ecs_dashboard/ecs).
     */
    @JvmName("grisstrbelihpbew")
    public suspend fun statistics(`value`: Output<String>) {
        this.statistics = value
    }

    /**
     * @param value Info level alarm threshold value, which must be a numeric value currently.
     */
    @JvmName("kiwpcmsoyntllxtp")
    public suspend fun threshold(`value`: Output<String>) {
        this.threshold = value
    }

    /**
     * @param value Info level alarm retry times. Default value: `3`.
     */
    @JvmName("ifdeotxckejtxvds")
    public suspend fun times(`value`: Output<Int>) {
        this.times = value
    }

    /**
     * @param value Info level alarm comparison operator. Default value: `>`. Valid values: `>`, `>=`, `<`, `<=`, `!=`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`. **NOTE:** From version 1.225.0, `comparison_operator` cannot be set to `==`.
     */
    @JvmName("kofphnaurucnppmk")
    public suspend fun comparisonOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value Info level alarm statistics method. It must be consistent with that defined for metrics. For more information, see [How to use it](https://cms.console.aliyun.com/metric-meta/acs_ecs_dashboard/ecs).
     */
    @JvmName("tvehvtblhwoqaare")
    public suspend fun statistics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    /**
     * @param value Info level alarm threshold value, which must be a numeric value currently.
     */
    @JvmName("toxcihigcbojlofp")
    public suspend fun threshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value Info level alarm retry times. Default value: `3`.
     */
    @JvmName("acolqhbxyewsaagp")
    public suspend fun times(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.times = mapped
    }

    internal fun build(): AlarmEscalationsInfoArgs = AlarmEscalationsInfoArgs(
        comparisonOperator = comparisonOperator,
        statistics = statistics,
        threshold = threshold,
        times = times,
    )
}
