@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.AlarmPrometheusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property annotations The annotations of the Prometheus alert rule. When a Prometheus alert is triggered, the system renders the annotated keys and values to help you understand the metrics and alert rule.
 * @property level The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
 * @property promQl The PromQL query statement. **Note:** The data obtained by using the PromQL query statement is the monitoring data. You must include the alert threshold in this statement.
 * @property times The number of consecutive triggers. If the number of times that the metric values meet the trigger conditions reaches the value of this parameter, CloudMonitor sends alert notifications.
 */
public data class AlarmPrometheusArgs(
    public val annotations: Output<Map<String, String>>? = null,
    public val level: Output<String>? = null,
    public val promQl: Output<String>? = null,
    public val times: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.AlarmPrometheusArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.AlarmPrometheusArgs =
        com.pulumi.alicloud.cms.inputs.AlarmPrometheusArgs.builder()
            .annotations(
                annotations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .level(level?.applyValue({ args0 -> args0 }))
            .promQl(promQl?.applyValue({ args0 -> args0 }))
            .times(times?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmPrometheusArgs].
 */
@PulumiTagMarker
public class AlarmPrometheusArgsBuilder internal constructor() {
    private var annotations: Output<Map<String, String>>? = null

    private var level: Output<String>? = null

    private var promQl: Output<String>? = null

    private var times: Output<Int>? = null

    /**
     * @param value The annotations of the Prometheus alert rule. When a Prometheus alert is triggered, the system renders the annotated keys and values to help you understand the metrics and alert rule.
     */
    @JvmName("ihugvlbyubmjpmlu")
    public suspend fun annotations(`value`: Output<Map<String, String>>) {
        this.annotations = value
    }

    /**
     * @param value The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
     */
    @JvmName("dwpdildafvxuxjdg")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The PromQL query statement. **Note:** The data obtained by using the PromQL query statement is the monitoring data. You must include the alert threshold in this statement.
     */
    @JvmName("fuelthabpnyxdiar")
    public suspend fun promQl(`value`: Output<String>) {
        this.promQl = value
    }

    /**
     * @param value The number of consecutive triggers. If the number of times that the metric values meet the trigger conditions reaches the value of this parameter, CloudMonitor sends alert notifications.
     */
    @JvmName("cnytelnjjxlvgwov")
    public suspend fun times(`value`: Output<Int>) {
        this.times = value
    }

    /**
     * @param value The annotations of the Prometheus alert rule. When a Prometheus alert is triggered, the system renders the annotated keys and values to help you understand the metrics and alert rule.
     */
    @JvmName("agxvigblvhwlaybc")
    public suspend fun annotations(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values The annotations of the Prometheus alert rule. When a Prometheus alert is triggered, the system renders the annotated keys and values to help you understand the metrics and alert rule.
     */
    @JvmName("gkcoqohhcnfnvyej")
    public fun annotations(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
     */
    @JvmName("nhrvayfndjubdpnd")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The PromQL query statement. **Note:** The data obtained by using the PromQL query statement is the monitoring data. You must include the alert threshold in this statement.
     */
    @JvmName("xyksxkwisrtrnnpp")
    public suspend fun promQl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promQl = mapped
    }

    /**
     * @param value The number of consecutive triggers. If the number of times that the metric values meet the trigger conditions reaches the value of this parameter, CloudMonitor sends alert notifications.
     */
    @JvmName("ytfuhehstjephvkh")
    public suspend fun times(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.times = mapped
    }

    internal fun build(): AlarmPrometheusArgs = AlarmPrometheusArgs(
        annotations = annotations,
        level = level,
        promQl = promQl,
        times = times,
    )
}
