@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.AlarmTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN uniquely identifies the resource that the alert targets.
 * > **NOTE:** The targets attribute is used to specify where notifications or actions should be directed when an alarm condition is met. This attribute corresponds to what is referred to as the "Push Channel" in the Alibaba Cloud console.
 * > **NOTE:** Currently, the Alibaba Cloud Resource Name (ARN) of the resource. To use, please [submit an application](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruletargets).
 * @property jsonParams Specifies additional parameters for the alert callback in JSON format. This can include configuration settings specific to the alert action.
 * @property level The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
 * @property targetId The ID of the resource for which alerts are triggered. This is typically used to specify individual resources that should respond to the alert.
 */
public data class AlarmTargetArgs(
    public val arn: Output<String>? = null,
    public val jsonParams: Output<String>? = null,
    public val level: Output<String>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.AlarmTargetArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.AlarmTargetArgs =
        com.pulumi.alicloud.cms.inputs.AlarmTargetArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .jsonParams(jsonParams?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmTargetArgs].
 */
@PulumiTagMarker
public class AlarmTargetArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var jsonParams: Output<String>? = null

    private var level: Output<String>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value ARN uniquely identifies the resource that the alert targets.
     * > **NOTE:** The targets attribute is used to specify where notifications or actions should be directed when an alarm condition is met. This attribute corresponds to what is referred to as the "Push Channel" in the Alibaba Cloud console.
     * > **NOTE:** Currently, the Alibaba Cloud Resource Name (ARN) of the resource. To use, please [submit an application](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruletargets).
     */
    @JvmName("kptbkqiqsjiiqauh")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Specifies additional parameters for the alert callback in JSON format. This can include configuration settings specific to the alert action.
     */
    @JvmName("egraaoxjwxliejqe")
    public suspend fun jsonParams(`value`: Output<String>) {
        this.jsonParams = value
    }

    /**
     * @param value The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
     */
    @JvmName("eolgkomgmalctwco")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The ID of the resource for which alerts are triggered. This is typically used to specify individual resources that should respond to the alert.
     */
    @JvmName("alaqddblgprhjupj")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value ARN uniquely identifies the resource that the alert targets.
     * > **NOTE:** The targets attribute is used to specify where notifications or actions should be directed when an alarm condition is met. This attribute corresponds to what is referred to as the "Push Channel" in the Alibaba Cloud console.
     * > **NOTE:** Currently, the Alibaba Cloud Resource Name (ARN) of the resource. To use, please [submit an application](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruletargets).
     */
    @JvmName("evluhgcvbkuratgv")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Specifies additional parameters for the alert callback in JSON format. This can include configuration settings specific to the alert action.
     */
    @JvmName("wbhmwbttmhhwwtng")
    public suspend fun jsonParams(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonParams = mapped
    }

    /**
     * @param value The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
     */
    @JvmName("icklayxgvxpmuxko")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The ID of the resource for which alerts are triggered. This is typically used to specify individual resources that should respond to the alert.
     */
    @JvmName("hqikjkqykhsldjca")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): AlarmTargetArgs = AlarmTargetArgs(
        arn = arn,
        jsonParams = jsonParams,
        level = level,
        targetId = targetId,
    )
}
