@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.DynamicTagGroupMatchExpressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property tagValue The tag values of the cloud resources.
 * @property tagValueMatchFunction The method that is used to match the tag values of the cloud resources. Valid values: `all`, `startWith`, `endWith`, `contains`, `notContains`, `equals`.
 */
public data class DynamicTagGroupMatchExpressArgs(
    public val tagValue: Output<String>,
    public val tagValueMatchFunction: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.DynamicTagGroupMatchExpressArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.DynamicTagGroupMatchExpressArgs =
        com.pulumi.alicloud.cms.inputs.DynamicTagGroupMatchExpressArgs.builder()
            .tagValue(tagValue.applyValue({ args0 -> args0 }))
            .tagValueMatchFunction(tagValueMatchFunction.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DynamicTagGroupMatchExpressArgs].
 */
@PulumiTagMarker
public class DynamicTagGroupMatchExpressArgsBuilder internal constructor() {
    private var tagValue: Output<String>? = null

    private var tagValueMatchFunction: Output<String>? = null

    /**
     * @param value The tag values of the cloud resources.
     */
    @JvmName("ulcmafrmsdwupxne")
    public suspend fun tagValue(`value`: Output<String>) {
        this.tagValue = value
    }

    /**
     * @param value The method that is used to match the tag values of the cloud resources. Valid values: `all`, `startWith`, `endWith`, `contains`, `notContains`, `equals`.
     */
    @JvmName("dlfyyfdhmvvfebvl")
    public suspend fun tagValueMatchFunction(`value`: Output<String>) {
        this.tagValueMatchFunction = value
    }

    /**
     * @param value The tag values of the cloud resources.
     */
    @JvmName("awjyrtevlprvrkec")
    public suspend fun tagValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagValue = mapped
    }

    /**
     * @param value The method that is used to match the tag values of the cloud resources. Valid values: `all`, `startWith`, `endWith`, `contains`, `notContains`, `equals`.
     */
    @JvmName("trptnpetyuxlpwqo")
    public suspend fun tagValueMatchFunction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagValueMatchFunction = mapped
    }

    internal fun build(): DynamicTagGroupMatchExpressArgs = DynamicTagGroupMatchExpressArgs(
        tagValue = tagValue ?: throw PulumiNullFieldException("tagValue"),
        tagValueMatchFunction = tagValueMatchFunction ?: throw
            PulumiNullFieldException("tagValueMatchFunction"),
    )
}
