@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.EventRuleContactParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contactGroupName The name of the alert contact group.
 * @property contactParametersId The ID of the recipient that receives alert notifications.
 * @property level The alert level and the corresponding notification methods.
 */
public data class EventRuleContactParameterArgs(
    public val contactGroupName: Output<String>? = null,
    public val contactParametersId: Output<String>? = null,
    public val level: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.EventRuleContactParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.EventRuleContactParameterArgs =
        com.pulumi.alicloud.cms.inputs.EventRuleContactParameterArgs.builder()
            .contactGroupName(contactGroupName?.applyValue({ args0 -> args0 }))
            .contactParametersId(contactParametersId?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventRuleContactParameterArgs].
 */
@PulumiTagMarker
public class EventRuleContactParameterArgsBuilder internal constructor() {
    private var contactGroupName: Output<String>? = null

    private var contactParametersId: Output<String>? = null

    private var level: Output<String>? = null

    /**
     * @param value The name of the alert contact group.
     */
    @JvmName("muddqnxorxoeurrd")
    public suspend fun contactGroupName(`value`: Output<String>) {
        this.contactGroupName = value
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("iarinsbwuhqajxsj")
    public suspend fun contactParametersId(`value`: Output<String>) {
        this.contactParametersId = value
    }

    /**
     * @param value The alert level and the corresponding notification methods.
     */
    @JvmName("srkehkiekmhadsfy")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The name of the alert contact group.
     */
    @JvmName("wtikpbyjeffpgyqs")
    public suspend fun contactGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactGroupName = mapped
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("veclaxqeqodnlhap")
    public suspend fun contactParametersId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactParametersId = mapped
    }

    /**
     * @param value The alert level and the corresponding notification methods.
     */
    @JvmName("glthxcepkhnfldar")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    internal fun build(): EventRuleContactParameterArgs = EventRuleContactParameterArgs(
        contactGroupName = contactGroupName,
        contactParametersId = contactParametersId,
        level = level,
    )
}
