@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.EventRuleEventPatternArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property eventTypeLists The type of the event-triggered alert rule. Valid values:
 * - `StatusNotification`: fault notifications.
 * - `Exception`: exceptions.
 * - `Maintenance`: O&M.
 * - `*`: all types.
 * @property levelLists The level of the event-triggered alert rule. Valid values:
 * - `CRITICAL`: critical.
 * - `WARN`: warning.
 * - `INFO`: information.
 * - `*`: all types.
 * @property nameLists The name of the event-triggered alert rule.
 * @property product The type of the cloud service.
 * @property sqlFilter The SQL condition that is used to filter events. If the content of an event meets the specified SQL condition, an alert is automatically triggered.
 */
public data class EventRuleEventPatternArgs(
    public val eventTypeLists: Output<List<String>>? = null,
    public val levelLists: Output<List<String>>? = null,
    public val nameLists: Output<List<String>>? = null,
    public val product: Output<String>,
    public val sqlFilter: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.EventRuleEventPatternArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.EventRuleEventPatternArgs =
        com.pulumi.alicloud.cms.inputs.EventRuleEventPatternArgs.builder()
            .eventTypeLists(eventTypeLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .levelLists(levelLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameLists(nameLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .product(product.applyValue({ args0 -> args0 }))
            .sqlFilter(sqlFilter?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventRuleEventPatternArgs].
 */
@PulumiTagMarker
public class EventRuleEventPatternArgsBuilder internal constructor() {
    private var eventTypeLists: Output<List<String>>? = null

    private var levelLists: Output<List<String>>? = null

    private var nameLists: Output<List<String>>? = null

    private var product: Output<String>? = null

    private var sqlFilter: Output<String>? = null

    /**
     * @param value The type of the event-triggered alert rule. Valid values:
     * - `StatusNotification`: fault notifications.
     * - `Exception`: exceptions.
     * - `Maintenance`: O&M.
     * - `*`: all types.
     */
    @JvmName("xsnaeblicdmoknmc")
    public suspend fun eventTypeLists(`value`: Output<List<String>>) {
        this.eventTypeLists = value
    }

    @JvmName("shvbbofajiqvxvlu")
    public suspend fun eventTypeLists(vararg values: Output<String>) {
        this.eventTypeLists = Output.all(values.asList())
    }

    /**
     * @param values The type of the event-triggered alert rule. Valid values:
     * - `StatusNotification`: fault notifications.
     * - `Exception`: exceptions.
     * - `Maintenance`: O&M.
     * - `*`: all types.
     */
    @JvmName("tudfknpnagjayumc")
    public suspend fun eventTypeLists(values: List<Output<String>>) {
        this.eventTypeLists = Output.all(values)
    }

    /**
     * @param value The level of the event-triggered alert rule. Valid values:
     * - `CRITICAL`: critical.
     * - `WARN`: warning.
     * - `INFO`: information.
     * - `*`: all types.
     */
    @JvmName("hpxkgiwffuvpqlcy")
    public suspend fun levelLists(`value`: Output<List<String>>) {
        this.levelLists = value
    }

    @JvmName("gajfdnbsaropvygo")
    public suspend fun levelLists(vararg values: Output<String>) {
        this.levelLists = Output.all(values.asList())
    }

    /**
     * @param values The level of the event-triggered alert rule. Valid values:
     * - `CRITICAL`: critical.
     * - `WARN`: warning.
     * - `INFO`: information.
     * - `*`: all types.
     */
    @JvmName("rjqrphujcgawelpg")
    public suspend fun levelLists(values: List<Output<String>>) {
        this.levelLists = Output.all(values)
    }

    /**
     * @param value The name of the event-triggered alert rule.
     */
    @JvmName("mxnxxedejhjlfaua")
    public suspend fun nameLists(`value`: Output<List<String>>) {
        this.nameLists = value
    }

    @JvmName("aldsnqdmqglwamjh")
    public suspend fun nameLists(vararg values: Output<String>) {
        this.nameLists = Output.all(values.asList())
    }

    /**
     * @param values The name of the event-triggered alert rule.
     */
    @JvmName("nlqomhkjjamyeeji")
    public suspend fun nameLists(values: List<Output<String>>) {
        this.nameLists = Output.all(values)
    }

    /**
     * @param value The type of the cloud service.
     */
    @JvmName("vxmskqbdnitlhxni")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value The SQL condition that is used to filter events. If the content of an event meets the specified SQL condition, an alert is automatically triggered.
     */
    @JvmName("awmkdhlqwdqgmgcs")
    public suspend fun sqlFilter(`value`: Output<String>) {
        this.sqlFilter = value
    }

    /**
     * @param value The type of the event-triggered alert rule. Valid values:
     * - `StatusNotification`: fault notifications.
     * - `Exception`: exceptions.
     * - `Maintenance`: O&M.
     * - `*`: all types.
     */
    @JvmName("qcxejccnkwkfibig")
    public suspend fun eventTypeLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTypeLists = mapped
    }

    /**
     * @param values The type of the event-triggered alert rule. Valid values:
     * - `StatusNotification`: fault notifications.
     * - `Exception`: exceptions.
     * - `Maintenance`: O&M.
     * - `*`: all types.
     */
    @JvmName("ywdknaoygbxdbgef")
    public suspend fun eventTypeLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventTypeLists = mapped
    }

    /**
     * @param value The level of the event-triggered alert rule. Valid values:
     * - `CRITICAL`: critical.
     * - `WARN`: warning.
     * - `INFO`: information.
     * - `*`: all types.
     */
    @JvmName("tbvdfeygsjxgqatu")
    public suspend fun levelLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.levelLists = mapped
    }

    /**
     * @param values The level of the event-triggered alert rule. Valid values:
     * - `CRITICAL`: critical.
     * - `WARN`: warning.
     * - `INFO`: information.
     * - `*`: all types.
     */
    @JvmName("ekthrptuvpkcwgwi")
    public suspend fun levelLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.levelLists = mapped
    }

    /**
     * @param value The name of the event-triggered alert rule.
     */
    @JvmName("dmfvlhvjeuwnoxio")
    public suspend fun nameLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameLists = mapped
    }

    /**
     * @param values The name of the event-triggered alert rule.
     */
    @JvmName("ydwhypudiucewceh")
    public suspend fun nameLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameLists = mapped
    }

    /**
     * @param value The type of the cloud service.
     */
    @JvmName("pgjlghghxhmnorjv")
    public suspend fun product(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value The SQL condition that is used to filter events. If the content of an event meets the specified SQL condition, an alert is automatically triggered.
     */
    @JvmName("jbrknetbsnanihsx")
    public suspend fun sqlFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlFilter = mapped
    }

    internal fun build(): EventRuleEventPatternArgs = EventRuleEventPatternArgs(
        eventTypeLists = eventTypeLists,
        levelLists = levelLists,
        nameLists = nameLists,
        product = product ?: throw PulumiNullFieldException("product"),
        sqlFilter = sqlFilter,
    )
}
