@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.EventRuleFcParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn (Available since v1.211.1) The ARN of the API operation.
 * @property fcParametersId The ID of the recipient that receives alert notifications.
 * @property functionName The name of the function.
 * @property region The region where Function Compute is deployed.
 * @property serviceName The name of the Function Compute service.
 */
public data class EventRuleFcParameterArgs(
    public val arn: Output<String>? = null,
    public val fcParametersId: Output<String>? = null,
    public val functionName: Output<String>? = null,
    public val region: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.EventRuleFcParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.EventRuleFcParameterArgs =
        com.pulumi.alicloud.cms.inputs.EventRuleFcParameterArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .fcParametersId(fcParametersId?.applyValue({ args0 -> args0 }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventRuleFcParameterArgs].
 */
@PulumiTagMarker
public class EventRuleFcParameterArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var fcParametersId: Output<String>? = null

    private var functionName: Output<String>? = null

    private var region: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value (Available since v1.211.1) The ARN of the API operation.
     */
    @JvmName("ofxstwwydiqobjdb")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("xwdyeadgbaumeoqh")
    public suspend fun fcParametersId(`value`: Output<String>) {
        this.fcParametersId = value
    }

    /**
     * @param value The name of the function.
     */
    @JvmName("segwccvnkbrsstdu")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value The region where Function Compute is deployed.
     */
    @JvmName("qyarmhbogwgjxtqt")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The name of the Function Compute service.
     */
    @JvmName("oonjrxdrulyysbme")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value (Available since v1.211.1) The ARN of the API operation.
     */
    @JvmName("dqwxrhsulpedsmcq")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("xmguyvxtjpicsupr")
    public suspend fun fcParametersId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fcParametersId = mapped
    }

    /**
     * @param value The name of the function.
     */
    @JvmName("cisjanahtaudntqo")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value The region where Function Compute is deployed.
     */
    @JvmName("winrdlbeaelrethp")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The name of the Function Compute service.
     */
    @JvmName("qexqdbqiydnmvodk")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): EventRuleFcParameterArgs = EventRuleFcParameterArgs(
        arn = arn,
        fcParametersId = fcParametersId,
        functionName = functionName,
        region = region,
        serviceName = serviceName,
    )
}
