@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.EventRuleMnsParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn (Available since v1.211.1) The ARN of the API operation.
 * @property mnsParametersId The ID of the recipient that receives alert notifications.
 * @property queue The name of the MNS queue.
 * @property region The region where Message Service (MNS) is deployed.
 * @property topic The MNS topic.
 */
public data class EventRuleMnsParameterArgs(
    public val arn: Output<String>? = null,
    public val mnsParametersId: Output<String>? = null,
    public val queue: Output<String>? = null,
    public val region: Output<String>? = null,
    public val topic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.EventRuleMnsParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.EventRuleMnsParameterArgs =
        com.pulumi.alicloud.cms.inputs.EventRuleMnsParameterArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .mnsParametersId(mnsParametersId?.applyValue({ args0 -> args0 }))
            .queue(queue?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .topic(topic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventRuleMnsParameterArgs].
 */
@PulumiTagMarker
public class EventRuleMnsParameterArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var mnsParametersId: Output<String>? = null

    private var queue: Output<String>? = null

    private var region: Output<String>? = null

    private var topic: Output<String>? = null

    /**
     * @param value (Available since v1.211.1) The ARN of the API operation.
     */
    @JvmName("oyobrmijdlhgqypi")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("uvdbkqspopaveccp")
    public suspend fun mnsParametersId(`value`: Output<String>) {
        this.mnsParametersId = value
    }

    /**
     * @param value The name of the MNS queue.
     */
    @JvmName("ayujouhmulkmpgnq")
    public suspend fun queue(`value`: Output<String>) {
        this.queue = value
    }

    /**
     * @param value The region where Message Service (MNS) is deployed.
     */
    @JvmName("pbjgwmxovnpbnhud")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The MNS topic.
     */
    @JvmName("ikncvmdfxrpvvuxr")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value (Available since v1.211.1) The ARN of the API operation.
     */
    @JvmName("wytwlgonniafjpos")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("imhenxyxvservpip")
    public suspend fun mnsParametersId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mnsParametersId = mapped
    }

    /**
     * @param value The name of the MNS queue.
     */
    @JvmName("nishkavksfdwvepo")
    public suspend fun queue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queue = mapped
    }

    /**
     * @param value The region where Message Service (MNS) is deployed.
     */
    @JvmName("chytycgvdftabsth")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The MNS topic.
     */
    @JvmName("ybxgjnfspirpurmi")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): EventRuleMnsParameterArgs = EventRuleMnsParameterArgs(
        arn = arn,
        mnsParametersId = mnsParametersId,
        queue = queue,
        region = region,
        topic = topic,
    )
}
