@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.EventRuleOpenApiParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action The API name.
 * @property arn (Available since v1.211.1) The ARN of the API operation.
 * @property openApiParametersId The ID of the recipient that receives alert notifications sent by an API callback.
 * @property product The ID of the cloud service to which the API operation belongs.
 * @property region The region where the resource resides.
 * @property role The name of the role.
 * @property version The version of the API.
 */
public data class EventRuleOpenApiParameterArgs(
    public val action: Output<String>? = null,
    public val arn: Output<String>? = null,
    public val openApiParametersId: Output<String>? = null,
    public val product: Output<String>? = null,
    public val region: Output<String>? = null,
    public val role: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.EventRuleOpenApiParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.EventRuleOpenApiParameterArgs =
        com.pulumi.alicloud.cms.inputs.EventRuleOpenApiParameterArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .arn(arn?.applyValue({ args0 -> args0 }))
            .openApiParametersId(openApiParametersId?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventRuleOpenApiParameterArgs].
 */
@PulumiTagMarker
public class EventRuleOpenApiParameterArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var arn: Output<String>? = null

    private var openApiParametersId: Output<String>? = null

    private var product: Output<String>? = null

    private var region: Output<String>? = null

    private var role: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The API name.
     */
    @JvmName("psmoxwhuofxlormt")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value (Available since v1.211.1) The ARN of the API operation.
     */
    @JvmName("qtggxudjowhdfxvu")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The ID of the recipient that receives alert notifications sent by an API callback.
     */
    @JvmName("olwflieolfrinqta")
    public suspend fun openApiParametersId(`value`: Output<String>) {
        this.openApiParametersId = value
    }

    /**
     * @param value The ID of the cloud service to which the API operation belongs.
     */
    @JvmName("olxgnppotdvsqvjr")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value The region where the resource resides.
     */
    @JvmName("dgxxxdtedwiofpli")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The name of the role.
     */
    @JvmName("atwonqesaafpbcwn")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The version of the API.
     */
    @JvmName("pxlsvtlgddhrychu")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The API name.
     */
    @JvmName("dwqyoajxjiukxuey")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value (Available since v1.211.1) The ARN of the API operation.
     */
    @JvmName("hhpwqfyejqhcxggp")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The ID of the recipient that receives alert notifications sent by an API callback.
     */
    @JvmName("swokuqcvmkskxftm")
    public suspend fun openApiParametersId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openApiParametersId = mapped
    }

    /**
     * @param value The ID of the cloud service to which the API operation belongs.
     */
    @JvmName("pbnxrfdjyyeaovpj")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value The region where the resource resides.
     */
    @JvmName("kxjgvrpcosflfihk")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The name of the role.
     */
    @JvmName("vlwevskgyaufwpfp")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The version of the API.
     */
    @JvmName("vaduratufqkjjchh")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): EventRuleOpenApiParameterArgs = EventRuleOpenApiParameterArgs(
        action = action,
        arn = arn,
        openApiParametersId = openApiParametersId,
        product = product,
        region = region,
        role = role,
        version = version,
    )
}
