@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.EventRuleSlsParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn (Available since v1.211.1) The ARN of the API operation.
 * @property logStore The name of the Simple Log Service Logstore.
 * @property project The name of the Simple Log Service project.
 * @property region The region where Simple Log Service is deployed.
 * @property slsParametersId The ID of the recipient that receives alert notifications.
 */
public data class EventRuleSlsParameterArgs(
    public val arn: Output<String>? = null,
    public val logStore: Output<String>? = null,
    public val project: Output<String>? = null,
    public val region: Output<String>? = null,
    public val slsParametersId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.EventRuleSlsParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.EventRuleSlsParameterArgs =
        com.pulumi.alicloud.cms.inputs.EventRuleSlsParameterArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .logStore(logStore?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .slsParametersId(slsParametersId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventRuleSlsParameterArgs].
 */
@PulumiTagMarker
public class EventRuleSlsParameterArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var logStore: Output<String>? = null

    private var project: Output<String>? = null

    private var region: Output<String>? = null

    private var slsParametersId: Output<String>? = null

    /**
     * @param value (Available since v1.211.1) The ARN of the API operation.
     */
    @JvmName("dclgwnsyagkacjlo")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The name of the Simple Log Service Logstore.
     */
    @JvmName("jkgqxxasvortgdta")
    public suspend fun logStore(`value`: Output<String>) {
        this.logStore = value
    }

    /**
     * @param value The name of the Simple Log Service project.
     */
    @JvmName("firldwstiknjvfev")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The region where Simple Log Service is deployed.
     */
    @JvmName("djywpounondjtavd")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("hxguvoxpkdygcgfb")
    public suspend fun slsParametersId(`value`: Output<String>) {
        this.slsParametersId = value
    }

    /**
     * @param value (Available since v1.211.1) The ARN of the API operation.
     */
    @JvmName("nophxytmyknreqky")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The name of the Simple Log Service Logstore.
     */
    @JvmName("mbhugsvfynrkcsao")
    public suspend fun logStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStore = mapped
    }

    /**
     * @param value The name of the Simple Log Service project.
     */
    @JvmName("oukekrbbaehgolxl")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The region where Simple Log Service is deployed.
     */
    @JvmName("hgssntllmqilcwif")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("wrgnlfigahyedaib")
    public suspend fun slsParametersId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsParametersId = mapped
    }

    internal fun build(): EventRuleSlsParameterArgs = EventRuleSlsParameterArgs(
        arn = arn,
        logStore = logStore,
        project = project,
        region = region,
        slsParametersId = slsParametersId,
    )
}
