@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.EventRuleWebhookParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property method The HTTP request method.
 * @property protocol The name of the protocol.
 * @property url The callback URL.
 * @property webhookParametersId The ID of the recipient that receives alert notifications.
 */
public data class EventRuleWebhookParameterArgs(
    public val method: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val url: Output<String>? = null,
    public val webhookParametersId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.EventRuleWebhookParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.EventRuleWebhookParameterArgs =
        com.pulumi.alicloud.cms.inputs.EventRuleWebhookParameterArgs.builder()
            .method(method?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 }))
            .webhookParametersId(webhookParametersId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventRuleWebhookParameterArgs].
 */
@PulumiTagMarker
public class EventRuleWebhookParameterArgsBuilder internal constructor() {
    private var method: Output<String>? = null

    private var protocol: Output<String>? = null

    private var url: Output<String>? = null

    private var webhookParametersId: Output<String>? = null

    /**
     * @param value The HTTP request method.
     */
    @JvmName("dwaysoxcgfqtkhvo")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value The name of the protocol.
     */
    @JvmName("hvjeyqosuofkxfyi")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The callback URL.
     */
    @JvmName("qeroxywekymtwpbw")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("xijutwwupemqtqkx")
    public suspend fun webhookParametersId(`value`: Output<String>) {
        this.webhookParametersId = value
    }

    /**
     * @param value The HTTP request method.
     */
    @JvmName("mvqifboxibwupoqq")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The name of the protocol.
     */
    @JvmName("yhcabsqgffblhnhi")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The callback URL.
     */
    @JvmName("fjvbhtnrhgseicil")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value The ID of the recipient that receives alert notifications.
     */
    @JvmName("aqkwdgskmjpebpfi")
    public suspend fun webhookParametersId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookParametersId = mapped
    }

    internal fun build(): EventRuleWebhookParameterArgs = EventRuleWebhookParameterArgs(
        method = method,
        protocol = protocol,
        url = url,
        webhookParametersId = webhookParametersId,
    )
}
